/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.icon.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.icon.service.TmIconService;
import com.biz.eisp.mdm.icon.vo.TmIconVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/iconController"})
public class TmIconController
extends BaseController {
    @Autowired
    private TmIconService iconService;

    @RequestMapping(params={"goIconList"})
    public ModelAndView goIconList(HttpServletRequest req, HttpServletResponse response) {
        return new ModelAndView("com/biz/eisp/mdm/icon/tmIconMain");
    }

    @RequestMapping(params={"findIconMainGrid"})
    @ResponseBody
    public DataGrid findIconMainGrid(HttpServletRequest req, TmIconVo icon, HttpServletResponse response) {
        this.page = new EuPage(req);
        List icons = this.iconService.findIconMainGrid(icon, this.page);
        return new DataGrid(icons, this.page);
    }

    @RequestMapping(params={"addOrUpdate"})
    @ResponseBody
    public AjaxJson addOrUpdateIcon(TmIconVo icon, HttpServletRequest req, HttpServletResponse response) {
        String result = this.iconService.saveOrUpdateIcon(icon);
        AjaxJson msg = new AjaxJson();
        msg.setMsg(result);
        return msg;
    }

    @RequestMapping(params={"goSaveOrUpdateForm"})
    public ModelAndView goSaveOrUpdateForm(TmIconVo ic, HttpServletRequest req, HttpServletResponse response) {
        if (StringUtil.isNotEmpty((String)ic.getId())) {
            TmIconVo icon = this.iconService.getIconById(ic.getId());
            req.setAttribute("icon", (Object)icon);
        }
        return new ModelAndView("com/biz/eisp/mdm/icon/tmIconForm");
    }

    @RequestMapping(params={"delIcon"})
    @ResponseBody
    public AjaxJson delIcon(String ids) {
        AjaxJson j = this.iconService.delIcon(ids);
        return j;
    }
}

