/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.productPrice.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.customer.service.TmCustomerService;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.productInfo.service.TmProductInfoService;
import com.biz.eisp.mdm.productInfo.vo.TmProductInfoVo;
import com.biz.eisp.mdm.productPrice.service.TmProductPriceService;
import com.biz.eisp.mdm.productPrice.vo.TmProductPriceVo;
import com.biz.eisp.mdm.terminal.service.TmTerminalService;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmProductPriceController"})
public class TmProductPriceController
extends BaseController {
    @Autowired
    private TmProductPriceService tmProductPriceService;
    @Autowired
    private TmProductInfoService tmProductInfoService;
    @Autowired
    private TmCustomerService tmCustomerService;
    @Autowired
    private TmTerminalService tmTerminalService;

    @RequestMapping(params={"goProductPriceList"})
    public ModelAndView goProductPriceList(HttpServletRequest req, HttpServletResponse response) {
        return new ModelAndView("com/biz/eisp/mdm/tmProductPrice/tmProductPriceMain");
    }

    @RequestMapping(params={"findProductPriceMainGrid"})
    @ResponseBody
    public DataGrid findProductPriceMainGrid(HttpServletRequest req, TmProductPriceVo tmProductPriceVo, HttpServletResponse response) {
        this.page = new EuPage(req);
        List icons = this.tmProductPriceService.findProductPriceMainGrid(tmProductPriceVo, this.page);
        return new DataGrid(icons, this.page);
    }

    @RequestMapping(params={"addOrUpdate"})
    @ResponseBody
    public AjaxJson addOrUpdateIcon(TmProductPriceVo tmProductPriceVo, HttpServletRequest req, HttpServletResponse response) {
        String result = this.tmProductPriceService.saveOrUpdateProductPrice(tmProductPriceVo);
        AjaxJson msg = new AjaxJson();
        msg.setMsg(result);
        return msg;
    }

    @RequestMapping(params={"goSaveOrUpdateForm"})
    public ModelAndView goSaveOrUpdateForm(TmProductPriceVo ic, HttpServletRequest req, HttpServletResponse response) {
        if (StringUtil.isNotEmpty((String)ic.getId())) {
            TmProductPriceVo vo = this.tmProductPriceService.getProductPriceById(ic.getId());
            req.setAttribute("vo", (Object)vo);
        }
        return new ModelAndView("com/biz/eisp/mdm/tmProductPrice/tmProductPriceForm");
    }

    @RequestMapping(params={"delProductPrice"})
    @ResponseBody
    public AjaxJson delProductPrice(String ids) {
        AjaxJson j = this.tmProductPriceService.delProductPrice(ids);
        return j;
    }

    @RequestMapping(params={"goTmProductInfoMain"})
    public ModelAndView goTmProductInfoMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/tmProductPrice/tmProductInfoMain");
    }

    @RequestMapping(params={"findTmProductInfoList"})
    @ResponseBody
    public DataGrid findTmProductInfoList(HttpServletRequest request, TmProductInfoVo productVo) {
        this.page = new EuPage(request);
        List icons = this.tmProductInfoService.findProductInfoMainGrid(productVo, this.page);
        return new DataGrid(icons, this.page);
    }

    @RequestMapping(params={"goTmCustomerMain"})
    public ModelAndView goTmCustomerMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/tmProductPrice/tmCustomerListMain");
    }

    @RequestMapping(params={"findTmCustomerList"})
    @ResponseBody
    public DataGrid findTmCustomerList(TmCustomerVo customerVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List customerList = this.tmCustomerService.findTmCustomerList(customerVo, (Page)page);
        return new DataGrid(customerList, (Page)page);
    }

    @RequestMapping(params={"goTmTerminaMain"})
    public ModelAndView goTmTerminaMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/tmProductPrice/tmTerminaListMain");
    }

    @RequestMapping(params={"findTmTerminalList"})
    @ResponseBody
    public DataGrid findTmTerminalList(TmTerminalVo terminalVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List terminalList = this.tmTerminalService.findTmTerminalList(terminalVo, (Page)page);
        return new DataGrid(terminalList, (Page)page);
    }
}

