/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.web.system.controller.core;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.redis.util.RedisUtils;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.web.system.entity.MutiLangEntity;
import com.biz.eisp.mdm.web.system.service.MutiLangServiceI;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/mutiLangController"})
public class MutiLangController
extends BaseController {
    @Autowired
    private MutiLangServiceI mutiLangService;
    @Autowired
    private BaseService baseService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"mutiLang"})
    public ModelAndView mutiLang(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/mutilang/mutiLangList");
    }

    @RequestMapping(params={"datagrid"})
    @ResponseBody
    public DataGrid datagrid(MutiLangEntity mutiLang, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List mutiLangEntities = this.mutiLangService.findDatagridPage(mutiLang, (Page)page);
        return new DataGrid(mutiLangEntities, (Page)page);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(MutiLangEntity mutiLang, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            mutiLang = (MutiLangEntity)this.baseService.get(MutiLangEntity.class, (Serializable)((Object)mutiLang.getId()));
            String langCode = mutiLang.getLangCode();
            String langKey = mutiLang.getLangKey();
            this.mutiLangService.delete((Object)mutiLang);
            j.setMsg("\u64cd\u4f5c\u6210\u529f");
            try {
                RedisService redisService = RedisUtils.getRedisService();
                String key = "MUTI_LANG_" + langCode + "_" + langKey;
                redisService.del(new String[]{key});
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(MutiLangEntity mutiLang, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u64cd\u4f5c\u6210\u529f";
        try {
            if (StringUtil.isNotEmpty((String)mutiLang.getId())) {
                MutiLangEntity t = (MutiLangEntity)this.mutiLangService.get(MutiLangEntity.class, (Serializable)((Object)mutiLang.getId()));
                MyBeanUtils.copyBeanNotNull2Bean((Object)mutiLang, (Object)t);
                this.mutiLangService.saveOrUpdate((Object)t);
            } else {
                this.mutiLangService.save((Object)mutiLang);
            }
            try {
                RedisService redisService = RedisUtils.getRedisService();
                String key = "MUTI_LANG_" + mutiLang.getLangCode() + "_" + mutiLang.getLangKey();
                redisService.setDays(key, (Object)mutiLang.getLangContext(), 30L);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u64cd\u4f5c\u5931\u8d25";
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(MutiLangEntity mutiLang, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((String)mutiLang.getId())) {
            mutiLang = (MutiLangEntity)this.mutiLangService.get(MutiLangEntity.class, (Serializable)((Object)mutiLang.getId()));
            req.setAttribute("mutiLangPage", (Object)mutiLang);
        }
        return new ModelAndView("com/biz/eisp/mdm/mutilang/mutiLang");
    }

    @RequestMapping(params={"refreshCach"})
    @ResponseBody
    public AjaxJson refreshCach(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            this.mutiLangService.refleshMutiLangCach();
            this.message = this.mutiLangService.getLang("common.refresh.success");
        }
        catch (Exception e) {
            this.message = this.mutiLangService.getLang("common.refresh.fail");
        }
        j.setMsg(this.message);
        return j;
    }
}

