-- Add/modify columns 
alter table TA_BASE_BUSINESS_OBJ add process_detail varchar2(2000);
-- Add comments to the columns 
comment on column TA_BASE_BUSINESS_OBJ.process_detail
  is '流程详情';


===========================================================================================================================
-- Create table
create table ta_Key_indicators_conf
(
  id           varchar2(64) not null,
  title        varchar2(2000),
  field        varchar2(2000),
  service_name varchar2(128),
  process_key  varchar2(128)
)
;
-- Add comments to the table 
comment on table ta_Key_indicators_conf
  is '业务关键指标配置';
-- Add comments to the columns 
comment on column ta_Key_indicators_conf.id
  is '主键';
comment on column ta_Key_indicators_conf.title
  is '关键指标的显示表头（以逗号隔开）';
comment on column ta_Key_indicators_conf.field
  is '关键指标显示字段(以逗号隔开)';
comment on column ta_Key_indicators_conf.service_name
  is '实现关键指标父级接口的service的加载名字';
comment on column ta_Key_indicators_conf.process_key
  is '流程定义key';

-- Create/Recreate primary, unique and foreign key constraints 
alter table TA_KEY_INDICATORS_CONF
  add constraint pk_ta_key_indicators_conf primary key (ID);
alter table TA_KEY_INDICATORS_CONF
  add constraint un_ta_key_indicators_conf unique (PROCESS_KEY);



===========================================================================================================================
-- Create table
create table ta_process_approval_log
(
  id          varchar2(64) not null,
  create_date timestamp,
  account     varchar2(128),
  name        varchar2(128),
  type        number(1),
  content     varchar2(2000)
)
;
-- Add comments to the table 
comment on table ta_process_approval_log
  is '工作流审批日志';
-- Add comments to the columns 
comment on column ta_process_approval_log.id
  is '主键';
comment on column ta_process_approval_log.create_date
  is '审批时间';
comment on column ta_process_approval_log.account
  is '审批人账号';
comment on column ta_process_approval_log.name
  is '审批人姓名';
comment on column ta_process_approval_log.type
  is '类型(1 通过 2 驳回 3 沟通)';
comment on column ta_process_approval_log.content
  is '审批内容';
-- Create/Recreate primary, unique and foreign key constraints 
alter table ta_process_approval_log
  add constraint pk_ta_process_approval_log primary key (ID);

-- Add/modify columns 
alter table TA_PROCESS_APPROVAL_LOG add process_inst_id varchar2(128);
alter table TA_PROCESS_APPROVAL_LOG add task_def_key varchar2(128);
-- Add comments to the columns 
comment on column TA_PROCESS_APPROVAL_LOG.process_inst_id
  is '流程实例id';
comment on column TA_PROCESS_APPROVAL_LOG.task_def_key
  is '任务定义key';


===========================================================================================================================
-- Add/modify columns 
alter table TA_PROCESS_NODE add position_code varchar2(50);
alter table TA_PROCESS_NODE add sign number(1);
alter table TA_PROCESS_NODE add sort number;
alter table TA_PROCESS_NODE add filter number(1);
-- Add comments to the columns 
comment on column TA_PROCESS_NODE.position_code
  is '岗位编码';
comment on column TA_PROCESS_NODE.sign
  is '是否会签';
comment on column TA_PROCESS_NODE.sort
  is '排个序';
comment on column TA_PROCESS_NODE.filter
  is '组织过滤';