<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>

<t:datagrid name="dictList" title="数据字典管理" idField="id" treegrid="true"  fit="true" fitColumns="true"
                actionUrl="tmDictDataController.do?dictGrid" pagination="false"  >
        <t:dgCol title="主键" field="id" treefield="id" hidden="true"></t:dgCol>
        <t:dgCol title="字典名称" field="name" treefield="text"></t:dgCol>
        <t:dgCol title="字典类型编码" field="dictTypeCode" treefield="dictTypeCode"></t:dgCol>
        <t:dgCol title="字典值编码" field="dictCode" treefield="dictCode"></t:dgCol>
        <t:dgCol title="类型" field="type" treefield="type" hidden="true"></t:dgCol>
        <t:dgCol title="描述" field="desc" treefield="desc"></t:dgCol>
        <t:dgCol title="创建时间" field="createDate"  treefield="createDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
        <t:dgCol title="创建人" field="createName" treefield="createName"></t:dgCol>
        <t:dgCol title="最近修改时间" field="updateDate"  treefield="updateDate"  formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
        <t:dgCol title="最近修改人" field="updateName" treefield="updateName"></t:dgCol>
        <t:dgCol title="操作" field="opt"></t:dgCol>
        <t:dgDelOpt url="tmDictTypeController.do?deleteDictType&id={id}" title="删除"></t:dgDelOpt>
        <t:dgToolBar title="添加类型"  icon="icon-add" url="tmDictTypeController.do?goSaveDictType" funname="add"></t:dgToolBar>
        <t:dgToolBar title="添加值"  icon="icon-add" url="tmDictDataController.do?goSaveDictData" funname="addData" ></t:dgToolBar>
        <t:dgToolBar title="修改类型"  icon="icon-edit" url="tmDictTypeController.do?goUpdateType" funname="updateType"></t:dgToolBar>
        <t:dgToolBar title="修改值"  icon="icon-edit" url="tmDictDataController.do?goUpdateData" funname="updateData"></t:dgToolBar>  
        
</t:datagrid>
<script type="text/javascript">
/**
 * 添加数据类型值
 */
function addData(title, url, id, width, height){
    var rowsData = $('#dictList').treegrid('getSelections');
    if (!rowsData || rowsData.length == 0) {
        tip('请选择编辑项目');
        return;
    }
    if (rowsData.length > 1) {
        tip('请选择一条记录再编辑');
        return;
    }
    var rowData = $('#dictList').treegrid('getSelected');
    if(rowData){
   		url += '&id='+rowData.id+'&dictTypeCode='+rowData.dictTypeCode;
    }
    createwindow(title, url, width, height);
}
/**
 * 修改数据字典类型方法
 */
function updateType(title,url, id,width,height) {
	var rowsData = $('#dictList').treegrid('getSelections');
    if (!rowsData || rowsData.length == 0) {
        tip('请选择编辑项目');
        return;
    }
    if (rowsData.length > 1) {
        tip('请选择一条记录再编辑');
        return;
    }
    var rowData = $('#dictList').treegrid('getSelected');
    if(rowData){
    	var type = rowData.id;
    	console.log(typeof type);
    	if(type.split("_")[1] =='2'){
    		 tip('请选择数据字典类型修改');
    		 return;
    	}
    	url += '&id='+rowData.id+'&dictTypeCode='+rowData.dictTypeCode;
    }
    createwindow(title, url, width, height);
}
/**
 * 修改项目类型值方法
 */
function updateData(title,url, id,width,height) {
	var rowsData = $('#dictList').treegrid('getSelections');
    if (!rowsData || rowsData.length == 0) {
        tip('请选择编辑项目');
        return;
    }
    if (rowsData.length > 1) {
        tip('请选择一条记录再编辑');
        return;
    }
    var rowData = $('#dictList').treegrid('getSelected');
    if(rowData){
    	var type = rowData.id;
    	
    	if(type.split("_")[1] =='1'){
    		 tip('请选择数据字典值修改');
    		 return;
    	}
    	url += '&id='+rowData.id+'&dictTypeCode='+rowData.dictTypeCode;
    }
    createwindow(title, url, width, height);
}
</script>


