/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.utils.ApplicationContextUtils;
import java.lang.reflect.InvocationTargetException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class JdbcProxy {
    public static final Log log = LogFactory.getLog(JdbcProxy.class);
    private JdbcTemplate jdbcTemplate = null;
    private Connection conn = null;
    private PreparedStatement pstmt = null;
    private Statement stmt = null;

    public JdbcProxy() throws SQLException {
        this("jdbcTemplate");
    }

    public JdbcProxy(String jdbcTemplateName) throws SQLException {
        this.jdbcTemplate = (JdbcTemplate)ApplicationContextUtils.getContext().getBean(jdbcTemplateName);
        this.conn = this.jdbcTemplate.getDataSource().getConnection();
        this.stmt = this.conn.createStatement();
    }

    public void prepareStatement(String sql) throws SQLException {
        if (this.pstmt != null) {
            this.pstmt.close();
            this.pstmt = null;
        }
        this.pstmt = this.conn.prepareStatement(sql);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet rs = null;
        try {
            rs = this.stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            log.error((Object)(e.getMessage() + " : " + sql));
            throw e;
        }
        return rs;
    }

    public <T> List<T> executeQuery(String sql, Class<T> clazz) throws SQLException {
        List list = null;
        try (ResultSet rs = null;){
            rs = this.stmt.executeQuery(sql);
            list = JdbcProxy.getEntityList((ResultSet)rs, (long)Long.MAX_VALUE, clazz);
        }
        return list;
    }

    public <T> T executeUniqueQuery(String sql, Class<T> clazz) throws SQLException {
        T object = null;
        Iterator it = this.executeQuery(sql, clazz).iterator();
        if (it.hasNext()) {
            object = (T)it.next();
        }
        return object;
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet rs = null;
        try {
            rs = this.pstmt.executeQuery();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
        return rs;
    }

    public <T> List<T> executeQuery(Class<T> clazz) throws SQLException {
        List list = null;
        try (ResultSet rs = null;){
            rs = this.pstmt.executeQuery();
            list = JdbcProxy.getEntityList((ResultSet)rs, (long)Long.MAX_VALUE, clazz);
        }
        return list;
    }

    public <T> T executeUniqueQuery(Class<T> clazz) throws SQLException {
        T object = null;
        Iterator it = this.executeQuery(clazz).iterator();
        if (it.hasNext()) {
            object = (T)it.next();
        }
        return object;
    }

    public int executeUpdate(String sql) throws SQLException {
        int n = 0;
        try {
            n = this.stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            log.error((Object)(e.getMessage() + " : " + sql));
            throw e;
        }
        return n;
    }

    public int executeUpdate() throws SQLException {
        int n = 0;
        try {
            n = this.pstmt.executeUpdate();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
        return n;
    }

    public static <T> List<T> getEntityList(ResultSet rs, long size, Class<T> clazz) throws SQLException {
        int i;
        ArrayList<T> list = new ArrayList<T>();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        String[] columns = new String[columnCount + 1];
        for (i = 1; i <= columnCount; ++i) {
            columns[i] = meta.getColumnLabel(i);
        }
        i = 0;
        while ((long)i < size && rs.next()) {
            try {
                T bean = clazz.newInstance();
                for (int j = 1; j <= columnCount; ++j) {
                    BeanUtils.copyProperty(bean, (String)columns[j], (Object)rs.getString(j));
                }
                list.add(bean);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return list;
    }

    public static <T> List<T> getEntityList(ResultSet rs, Class<T> clazz) throws SQLException {
        return JdbcProxy.getEntityList((ResultSet)rs, (long)Long.MAX_VALUE, clazz);
    }

    public static List<Object[]> getObjectArrayList(ResultSet rs, long size) throws SQLException {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        int i = 0;
        while ((long)i < size && rs.next()) {
            Object[] object = new Object[columnCount];
            for (int j = 0; j < columnCount; ++j) {
                object[j] = rs.getObject(j + 1);
            }
            list.add(object);
            ++i;
        }
        return list;
    }

    public static List<Object[]> getObjectArrayList(ResultSet rs) throws SQLException {
        return JdbcProxy.getObjectArrayList((ResultSet)rs, (long)Long.MAX_VALUE);
    }

    public static List<Map> getObjectMapList(ResultSet rs, long size) throws SQLException {
        ArrayList<Map> list = new ArrayList<Map>();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        HashMap<String, Object> object = null;
        int i = 0;
        while ((long)i < size && rs.next()) {
            object = new HashMap<String, Object>();
            for (int j = 1; j <= columnCount; ++j) {
                String label = meta.getColumnLabel(j);
                object.put(label, rs.getObject(label));
            }
            list.add(object);
            ++i;
        }
        return list;
    }

    public static List<Map> getObjectMapList(ResultSet rs) throws SQLException {
        return JdbcProxy.getObjectMapList((ResultSet)rs, (long)Long.MAX_VALUE);
    }

    public void setAutoCommit(boolean b) throws SQLException {
        this.conn.setAutoCommit(b);
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    public void setLong(int i, Long x) throws SQLException {
        this.pstmt.setLong(i, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.pstmt.setBlob(i, x);
    }

    public void setString(int i, String x) throws SQLException {
        this.pstmt.setString(i, x);
    }

    public void setInt(int i, Integer x) throws SQLException {
        this.pstmt.setInt(i, x);
    }

    public void setDate(int i, Date x) throws SQLException {
        this.pstmt.setDate(i, x);
    }

    public void setTime(int i, Time x) throws SQLException {
        this.pstmt.setTime(i, x);
    }

    public void close() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        try {
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

