/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.utils;

import com.biz.eisp.base.common.util.ResourceUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JwtUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String secret = ResourceUtil.getDbConfigProperty((String)"jwt.secret");
    private long expire = Long.valueOf(ResourceUtil.getDbConfigProperty((String)"jwt.expire"));
    private String header = ResourceUtil.getDbConfigProperty((String)"jwt.header");

    public String generateToken(String userId) {
        Date nowDate = new Date();
        Date expireDate = new Date(nowDate.getTime() + this.expire * 1000L);
        return Jwts.builder().setHeaderParam("typ", (Object)"JWT").setSubject(userId).setIssuedAt(nowDate).setExpiration(expireDate).signWith(SignatureAlgorithm.HS256, this.secret).compact();
    }

    public Claims getClaimByToken(String token) {
        try {
            return (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            this.logger.debug("token\u9a8c\u8bc1\u9519\u8bef,\u8bf7\u91cd\u65b0\u767b\u9646 ", (Throwable)e);
            return null;
        }
    }

    public boolean isTokenExpired(Date expiration) {
        return expiration.before(new Date());
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }
}

