/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.position.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.JsonUtil;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.pojo.glob.entity.ActIdUserEntity;
import com.biz.eisp.base.utils.AppcenterUtil;
import com.biz.eisp.base.utils.UserRedis;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.actrole.entity.TmActRoleEntity;
import com.biz.eisp.mdm.actrole.entity.TmRPositionActRoleEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import com.biz.eisp.mdm.position.dao.TmPositionDao;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.entity.TmRPositionRoleEntity;
import com.biz.eisp.mdm.position.service.TmPositionExtendService;
import com.biz.eisp.mdm.position.service.TmPositionSearchExtendService;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.transformer.TmPositionEntityToTmPositionVo;
import com.biz.eisp.mdm.position.transformer.TmPositionVoToTmPositionEntity;
import com.biz.eisp.mdm.position.vo.QueryTmpositionVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmUserPositionEntity;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmPositionService")
@Transactional
public class TmPositionServiceImpl
extends BaseServiceImpl
implements TmPositionService {
    private static final String saveActIdUser = ResourceUtil.getSysConfigProperty((String)"springbootUrl") + "/activiti/activitiConfigApiController/saveActIdUser";
    @Autowired
    private TmPositionDao tmPositionDao;
    @Autowired(required=false)
    private TmPositionExtendService tmPositionExtendService;
    @Autowired(required=false)
    private TmPositionSearchExtendService tmPositionSearchExtendService;
    @Autowired
    private RedisService redisService;

    public List<TmPositionVo> findTmPositionList(TmPositionVo tmPositionVo, Page page) {
        List voList;
        String sql = "";
        if (this.tmPositionSearchExtendService != null) {
            sql = this.tmPositionSearchExtendService.buildSearchSql(tmPositionVo);
            if (StringUtil.isEmpty((String)sql)) {
                sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_POSITION, (Object)tmPositionVo);
                sql = this.tmPositionSearchExtendService.extendSearchSql(tmPositionVo, sql);
            }
        } else {
            sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_POSITION, (Object)tmPositionVo);
            sql = this.appendPositionCondition(sql, (Object)tmPositionVo);
        }
        if (!CollectionUtils.isEmpty((Collection)(voList = this.tmPositionDao.findTmPositionList(tmPositionVo, page, sql)))) {
            for (TmPositionVo tmPositionVo2 : voList) {
                this.HandleRoleName(tmPositionVo2);
            }
        }
        return voList;
    }

    public List<TmPositionVo> findNoAnyRolePositionList(TmPositionVo tmPositionVo, Page page) {
        List voList = this.tmPositionDao.findNoAnyRolePositionList(tmPositionVo, page);
        return voList;
    }

    public List<TmPositionVo> findNoAnyActRolePositionList(TmPositionVo tmPositionVo, Page page) {
        List voList = this.tmPositionDao.findNoAnyActRolePositionList(tmPositionVo, page);
        return voList;
    }

    public List<TmPositionVo> findNoThisRolePositionList(TmPositionVo tmPositionVo, Page page) {
        List voList = this.tmPositionDao.findNoThisRolePositionList(tmPositionVo, page);
        return voList;
    }

    public List<TmPositionVo> findNoThisActRolePositionList(TmPositionVo tmPositionVo, Page page) {
        List voList = this.tmPositionDao.findNoThisActRolePositionList(tmPositionVo, page);
        return voList;
    }

    public List<TmPositionVo> findThisRolePositionList(TmPositionVo tmPositionVo, Page page) {
        List voList = this.tmPositionDao.findThisRolePositionList(tmPositionVo, page);
        return voList;
    }

    public List<TmPositionVo> findThisActRolePositionList(TmPositionVo tmPositionVo, Page page) {
        List voList = this.tmPositionDao.findThisActRolePositionList(tmPositionVo, page);
        return voList;
    }

    public List<TmPositionVo> findTmPositionByOrgSelectList(TmPositionVo tmPositionVo, Page page) {
        List list = this.tmPositionDao.findTmPositionByOrgSelectList(tmPositionVo, page);
        return list;
    }

    public List<TmPositionVo> findTmPositionQuerySelectList(TmPositionVo tmPositionVo, Page page) {
        List list = this.tmPositionDao.findTmPositionQuerySelectList(tmPositionVo, page);
        return list;
    }

    public String appendPositionCondition(String sql, Object paramObj) {
        TmPositionVo tmPositionVo = new TmPositionVo();
        if (paramObj != null) {
            tmPositionVo = (TmPositionVo)paramObj;
        }
        String isRoleSerchSql = "";
        if (StringUtil.isNotBlank((String)tmPositionVo.getRoleIds())) {
            isRoleSerchSql = ",trpr.role_id";
        }
        String joinSql = "select p.id newId,o.org_name,o.id org_id, tmo.org_name AS parentOrgName,pp.position_code AS parentCode " + isRoleSerchSql;
        joinSql = joinSql + " ,trup.is_main AS isMain,trup.user_id,tu.username AS userName,tu.fullname AS fullName, ptu.fullname AS parentUserName,trup.id AS tmRPositionUserId ";
        joinSql = joinSql + " FROM tm_position p LEFT JOIN tm_org o ON o.id = p.org_id LEFT JOIN tm_r_user_position trup ON trup.position_id=p.id LEFT JOIN tm_user tu ON tu.id = trup.user_id LEFT JOIN tm_position pp ON pp.id = p.parent_id LEFT JOIN tm_org tmo ON pp.org_id = tmo.id LEFT JOIN tm_r_user_position ptup ON pp.id=ptup.position_id LEFT JOIN tm_user ptu ON ptu.id=ptup.user_id";
        String onSql = "t1.newId=t.id";
        String sqlWhere = "";
        if (StringUtil.isNotEmpty((String)tmPositionVo.getId())) {
            sql = sql + " and t.id='" + tmPositionVo.getId() + "'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getCurentOrg()) && StringUtil.isEmpty((String)tmPositionVo.getId())) {
            String posId = ResourceUtil.getString((String)"position");
            if (StringUtil.isEmpty((String)posId)) {
                posId = ResourceUtil.getCurrPosition().getId();
            }
            if (StringUtil.isNotEmpty((String)posId)) {
                sql = sql + " and t.id <>'" + posId + "'";
            }
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getFlag())) {
            String excludeId = StringUtil.isNotEmpty((String)tmPositionVo.getExcludeId()) ? tmPositionVo.getExcludeId() : "'-1'";
            sqlWhere = sqlWhere + " AND t.id not in (select position_id from tm_r_user_position WHERE user_id is not null AND position_id not in (" + excludeId + "))";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getNotInId())) {
            sqlWhere = sqlWhere + " AND t.id not in (" + tmPositionVo.getNotInId() + ")";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getRoleIds())) {
            joinSql = joinSql + " LEFT JOIN tm_r_position_role trpr ON p.id=trpr.position_id";
            sqlWhere = sqlWhere + " AND t1.role_id ='" + tmPositionVo.getRoleIds() + "'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getParentUserName())) {
            sqlWhere = sqlWhere + " AND t1.parentUserName like '%" + tmPositionVo.getParentUserName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getParentName())) {
            sqlWhere = sqlWhere + " AND t.parentName like '%" + tmPositionVo.getParentName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getFullName())) {
            sqlWhere = sqlWhere + " AND t1.fullname like '%" + tmPositionVo.getFullName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getUserName())) {
            sqlWhere = sqlWhere + " AND t1.username like '%" + tmPositionVo.getUserName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getUserId())) {
            sqlWhere = sqlWhere + " AND t1.user_id ='" + tmPositionVo.getUserId() + "'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getCurentOrg())) {
            sqlWhere = sqlWhere + " AND t.orgId in (select id from tm_org )";
            if (StringUtil.isNotBlank((String)tmPositionVo.getCurentId())) {
                sqlWhere = sqlWhere + " AND t.id <>'" + tmPositionVo.getCurentId() + "'";
            }
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getOrgId())) {
            sqlWhere = sqlWhere + " AND t.orgId ='" + tmPositionVo.getOrgId() + "'";
        }
        String orderSql = " order by t.updateDate desc";
        return DynamicConfigUtil.getInstance().appendCustomCondition(sql, joinSql, onSql, sqlWhere, orderSql);
    }

    private void HandleRoleName(TmPositionVo positionVo) {
        List roles = this.tmPositionDao.findTmRoleByPosition(positionVo);
        StringBuffer bufferNames = new StringBuffer();
        StringBuffer bufferIds = new StringBuffer();
        if (!CollectionUtils.isEmpty((Collection)roles)) {
            for (TmRoleEntity tmRoleEntity : roles) {
                if (bufferNames.length() > 0) {
                    bufferNames.append(",");
                    bufferIds.append(",");
                }
                bufferNames.append(tmRoleEntity.getRoleName());
                bufferIds.append(tmRoleEntity.getId());
            }
            positionVo.setRoleNames(bufferNames.toString());
            positionVo.setRoleIds(bufferIds.toString());
        }
        StringBuffer actRoleBufferNames = new StringBuffer();
        StringBuffer actRoleBufferIds = new StringBuffer();
        List actRoles = this.tmPositionDao.findTmActRoleByPosition(positionVo);
        if (!CollectionUtils.isEmpty((Collection)actRoles)) {
            for (TmActRoleEntity actRole : actRoles) {
                if (actRoleBufferNames.length() > 0) {
                    actRoleBufferNames.append(",");
                    actRoleBufferIds.append(",");
                }
                actRoleBufferNames.append(actRole.getRoleName());
                actRoleBufferIds.append(actRole.getId());
            }
            positionVo.setWorkflowRoleNames(actRoleBufferNames.toString());
            positionVo.setWorkflowRoleIds(actRoleBufferIds.toString());
        }
    }

    public void saveTmPosition(TmPositionVo tmPositionVo, Page page) {
        TmPositionEntity tmPositionEntity = null;
        String positionId = "";
        if (this.tmPositionExtendService != null) {
            try {
                this.tmPositionExtendService.validate(tmPositionVo, page);
            }
            catch (BusinessException e) {
                throw new BusinessException("\u6570\u636e\u9a8c\u8bc1\u4e0d\u901a\u8fc7" + e.getMessage());
            }
            tmPositionEntity = this.tmPositionExtendService.saveBefore(tmPositionVo, page);
        }
        if (tmPositionEntity == null) {
            tmPositionEntity = new TmPositionVoToTmPositionEntity((TmPositionService)this).apply(tmPositionVo);
        }
        if (this.tmPositionExtendService != null) {
            tmPositionEntity = this.tmPositionExtendService.saveBefore(tmPositionEntity, tmPositionVo, page);
        }
        this.saveOrUpdate(tmPositionEntity);
        positionId = tmPositionEntity.getId();
        if (this.tmPositionExtendService != null) {
            tmPositionEntity = this.tmPositionExtendService.savePost(tmPositionEntity, tmPositionVo, page);
            this.tmPositionExtendService.saveActIdUserBefore(tmPositionEntity, tmPositionVo, page);
        }
        this.saveActIdUser(tmPositionEntity);
        String hql = "FROM TmRPositionRoleEntity where tmPosition.id is null";
        List list = this.findByHql(hql, new Object[0]);
        for (TmRPositionRoleEntity prole : list) {
            String proleId = prole.getId();
            super.addLogAndRemoveInvalidInfo(proleId, (Object)prole, positionId, null);
        }
        this.executeSql("DELETE FROM TM_R_POSITION_ROLE WHERE POSITION_ID IS NULL", new Object[0]);
        String hql1 = "FROM TmRPositionActRoleEntity where tmPosition.id is null";
        List list1 = this.findByHql(hql1, new Object[0]);
        for (TmRPositionActRoleEntity prole : list1) {
            String proleId = prole.getId();
            super.addLogAndRemoveInvalidInfo(proleId, (Object)prole, positionId, null);
        }
        this.executeSql("DELETE FROM TM_R_POSITION_ACT_ROLE WHERE POSITION_ID IS NULL", new Object[0]);
    }

    private void saveActIdUser(TmPositionEntity tmPositionEntity) {
        ActIdUserEntity actIdUserEntity = new ActIdUserEntity();
        if (!StringUtil.isNotEmpty((Object)actIdUserEntity)) {
            actIdUserEntity = new ActIdUserEntity();
            actIdUserEntity.setId(tmPositionEntity.getPositionCode());
            actIdUserEntity.setRev(Globals.REV);
            actIdUserEntity.setLast(tmPositionEntity.getPositionName());
        } else {
            actIdUserEntity.setId(tmPositionEntity.getPositionCode());
            actIdUserEntity.setRev(Globals.REV);
            actIdUserEntity.setLast(tmPositionEntity.getPositionName());
        }
        this.saveOrUpdate((Object)actIdUserEntity);
    }

    public void deleteTmPosition(String ids, Page page) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] positionIds;
            for (String positionId : positionIds = ids.split(",")) {
                TmPositionEntity tmPositionEntity = (TmPositionEntity)this.get(TmPositionEntity.class, (Serializable)((Object)positionId));
                if (tmPositionEntity == null || !StringUtil.isNotEmpty((String)tmPositionEntity.getId())) continue;
                if (CollectionUtil.listNotEmptyNotSizeZero((List)tmPositionEntity.getTmPositionList())) {
                    throw new BusinessException("\u5305\u542b\u4e0b\u7ea7\u804c\u4f4d,\u65e0\u6cd5\u5220\u9664");
                }
                List list = this.findByProperty(TmUserPositionEntity.class, "tmPosition.id", (Object)tmPositionEntity.getId());
                for (TmUserPositionEntity userPosition : list) {
                    userPosition.setTmUser((TmUserEntity)this.get(TmUserEntity.class, (Serializable)((Object)userPosition.getTmUser().getId())));
                }
                this.deleteAllEntity((Collection)list);
                this.delete((Object)tmPositionEntity);
            }
        }
    }

    public AjaxJson startOrStopPosition(TmPositionVo tmPositionVo) {
        AjaxJson j = new AjaxJson();
        TmPositionEntity positionEntity = (TmPositionEntity)this.get(TmPositionEntity.class, (Serializable)((Object)tmPositionVo.getId()));
        if (StringUtil.isNotEmpty((Object)positionEntity)) {
            if (positionEntity.getEnableStatus().equals(tmPositionVo.getEnableStatus())) {
                j.setSuccess(false);
                String fg = Globals.ZERO.equals(tmPositionVo.getEnableStatus()) ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                positionEntity.setEnableStatus(tmPositionVo.getEnableStatus());
                this.updateEntity((Object)positionEntity);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }

    public ValidForm validateTmposition(TmPositionVo tmPositionVo, String param) {
        ValidForm validForm = new ValidForm();
        String hql = "";
        if (StringUtil.isNotEmpty((String)tmPositionVo.getId())) {
            if (StringUtil.isNotEmpty((String)tmPositionVo.getType())) {
                List list;
                if (StringUtil.equals((String)"0", (String)tmPositionVo.getType())) {
                    hql = "from TmPositionEntity where positionCode=? and id<>? and enableStatus=?";
                    list = this.findByHql(hql, new Object[]{param, tmPositionVo.getId(), Globals.ZERO});
                    if (!CollectionUtils.isEmpty((Collection)list)) {
                        validForm.setInfo("\u804c\u4f4d\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
                        validForm.setStatus("n");
                    }
                }
                if (StringUtil.equals((String)"1", (String)tmPositionVo.getType())) {
                    hql = "from TmPositionEntity where positionName=? and id<>? and enableStatus=?";
                    list = this.findByHql(hql, new Object[]{param, tmPositionVo.getId(), Globals.ZERO});
                    if (!CollectionUtils.isEmpty((Collection)list)) {
                        validForm.setInfo("\u804c\u4f4d\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
                        validForm.setStatus("n");
                    }
                }
            }
        } else if (StringUtil.isNotEmpty((String)tmPositionVo.getType())) {
            if (StringUtil.equals((String)"0", (String)tmPositionVo.getType())) {
                hql = "from TmPositionEntity where positionCode=? and enableStatus=?";
                List list = this.findByHql(hql, new Object[]{param, Globals.ZERO});
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    validForm.setInfo("\u804c\u4f4d\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
            if (StringUtil.equals((String)"1", (String)tmPositionVo.getType())) {
                hql = "from TmPositionEntity where positionName=? and enableStatus=?";
                List nameList = this.findByHql(hql, new Object[]{param, Globals.ZERO});
                if (!CollectionUtils.isEmpty((Collection)nameList)) {
                    validForm.setInfo("\u804c\u4f4d\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
        }
        return validForm;
    }

    public List<ComboTree> getPositionForComboTree(HttpServletRequest request, ComboTree comboTree) {
        String selfId = request.getParameter("selfId");
        List positionList = new ArrayList();
        if (StringUtil.isNotEmpty((String)selfId)) {
            positionList = this.findByProperty(TmPositionEntity.class, "id", (Object)selfId);
        } else if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            positionList = this.findByProperty(TmPositionEntity.class, "tmPosition.id", (Object)comboTree.getId());
        } else {
            Criterion cr = Restrictions.isNull((String)"tmPosition.id");
            positionList = this.findByCriteria(TmPositionEntity.class, new Criterion[]{cr});
        }
        ArrayList<ComboTree> comboTrees = new ArrayList();
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "positionName", "positions");
        comboTrees = this.comboTree(positionList, comboTreeModel, null, false);
        return comboTrees;
    }

    public AjaxJson changePositionForOrg(TmOrgVo tmOrgVo) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((String)tmOrgVo.getPositionIds())) {
            String[] posIds;
            TmPositionEntity tmPositionEntity = null;
            TmOrgEntity tmOrgEntity = null;
            for (String posId : posIds = tmOrgVo.getPositionIds().split(",")) {
                tmPositionEntity = (TmPositionEntity)this.get(TmPositionEntity.class, (Serializable)((Object)posId));
                if (!StringUtil.isNotEmpty((Object)tmPositionEntity)) continue;
                tmOrgEntity = (TmOrgEntity)this.get(TmOrgEntity.class, (Serializable)((Object)tmOrgVo.getOrgId()));
                tmPositionEntity.setTmOrg(tmOrgEntity);
                tmPositionEntity.setTmPosition(null);
                this.saveOrUpdate((Object)tmPositionEntity);
            }
            j.setMsg("\u8c03\u6574\u5173\u7cfb\u6210\u529f");
        } else {
            j.setSuccess(false);
            j.setMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
        }
        return j;
    }

    public void changeTmPosition(TmPositionVo tmPositionVo) {
        String hql = " from TmUserPositionEntity up where up.tmUser.id=? ";
        List userPositionEntities = this.findByHql(hql, new Object[]{tmPositionVo.getUserId()});
        TmPositionEntity pos = new TmPositionEntity();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)userPositionEntities)) {
            for (TmUserPositionEntity entity : userPositionEntities) {
                if (tmPositionVo.getId().equals(entity.getTmPosition().getId())) {
                    pos = entity.getTmPosition();
                    entity.setIsMain("0");
                } else {
                    entity.setIsMain("1");
                }
                this.updateEntity((Object)entity);
            }
        }
        ResourceUtil.addString((String)"position", (String)tmPositionVo.getId());
        String key = AppcenterUtil.getUserKey();
        UserRedis userRedis = UserUtils.getUser();
        userRedis.setPosCode(pos.getPositionCode());
        userRedis.setPosId(pos.getId());
        userRedis.setPosName(pos.getPositionName());
        String value = JsonUtil.bean2json((Object)userRedis);
        this.redisService.setSeconds("LOGIN_SUCCESS_" + key, (Object)value, 86400L);
    }

    public List<TmPositionVo> findPositionListByOrgId(String orgId) {
        String hql = "from TmPositionEntity pe where tmOrg.id = ?";
        List entityList = this.findByHql(hql, new Object[]{orgId});
        List list = Lists.transform((List)entityList, (Function)new TmPositionEntityToTmPositionVo());
        return list;
    }

    public List<TmPositionVo> findOtherTmUserInfo() {
        String userId = ResourceUtil.getSessionTmUserVo().getId();
        TmPositionVo tmPositionVo = new TmPositionVo();
        tmPositionVo.setUserId(userId);
        return this.tmPositionDao.findOtherTmUserInfo(tmPositionVo);
    }

    public List<TmPositionVo> findPositionByConditions(TmPositionVo query, Page page) {
        List list = this.tmPositionDao.findTmPositionParentByCondition(query, page);
        return list;
    }

    public List<TmPositionVo> findTmPositionByAllPossible(QueryTmpositionVo queryTmpositionVo, Page page) {
        return this.tmPositionDao.findTmPositionByAllPossible(queryTmpositionVo, page);
    }

    public List<TmLogVo> findPositionLogList(TmLogVo tmLogVo, Page page) {
        return this.tmPositionDao.findPositionLogList(tmLogVo, page);
    }

    public long isMainPosition(String posId) {
        String sql = "select count(1) from tm_r_user_position where position_id=? and is_main=?";
        long count = this.getCountForJdbcParam(sql, new Object[]{posId, Globals.Main_Position_Type});
        return count;
    }

    public void updatePositionIsMain(String userId, String mainPosId) {
        String sql1 = " update tm_r_user_position set is_main = ? where user_id=? ";
        this.executeSql(sql1, new Object[]{Globals.PartTime_Position_Type, userId});
        String sql2 = " update tm_r_user_position set is_main = ? where position_id=? ";
        this.executeSql(sql2, new Object[]{Globals.Main_Position_Type, mainPosId});
    }

    public void addPositionRoleRelation(String positionIds, String roleId) {
        String[] positionIdArr;
        for (String positionId : positionIdArr = positionIds.split(",")) {
            this.addPositionRoleRelationItem(positionId, roleId);
        }
    }

    public void addPositionActRoleRelation(String positionIds, String roleId) {
        String[] positionIdArr;
        for (String positionId : positionIdArr = positionIds.split(",")) {
            this.addPositionActRoleRelationItem(positionId, roleId);
        }
    }

    private void addPositionRoleRelationItem(String positionId, String roleId) {
        String hql = "from TmRPositionRoleEntity where tmRole.id = ? and tmPosition.id = ?";
        List rPositionRoleEntityList = this.findByHql(hql, new Object[]{roleId, positionId});
        if (CollectionUtil.listNotEmptyNotSizeZero((List)rPositionRoleEntityList)) {
            throw new BusinessException("\u5df2\u7ecf\u5173\u8054\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        TmRPositionRoleEntity rPositionRoleEntity = new TmRPositionRoleEntity();
        TmPositionEntity positionEntity = (TmPositionEntity)this.get(TmPositionEntity.class, (Serializable)((Object)positionId));
        if (positionEntity == null) {
            throw new BusinessException("\u804c\u4f4dId\u503c\u4e0d\u5b58\u5728");
        }
        TmRoleEntity roleEntity = (TmRoleEntity)this.get(TmRoleEntity.class, (Serializable)((Object)roleId));
        if (roleEntity == null) {
            throw new BusinessException("\u89d2\u8272Id\u503c\u4e0d\u5b58\u5728");
        }
        rPositionRoleEntity.setTmPosition(positionEntity);
        rPositionRoleEntity.setTmRole(roleEntity);
        this.save((Object)rPositionRoleEntity);
    }

    private void addPositionActRoleRelationItem(String positionId, String roleId) {
        String hql = "from TmRPositionActRoleEntity where tmActRole.id = ? and tmPosition.id = ?";
        List rPositionActRoleEntityList = this.findByHql(hql, new Object[]{roleId, positionId});
        if (CollectionUtil.listNotEmptyNotSizeZero((List)rPositionActRoleEntityList)) {
            throw new BusinessException("\u5df2\u7ecf\u5173\u8054\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        TmRPositionActRoleEntity rPositionActRoleEntity = new TmRPositionActRoleEntity();
        TmPositionEntity positionEntity = (TmPositionEntity)this.get(TmPositionEntity.class, (Serializable)((Object)positionId));
        if (positionEntity == null) {
            throw new BusinessException("\u804c\u4f4dId\u503c\u4e0d\u5b58\u5728");
        }
        TmActRoleEntity roleEntity = (TmActRoleEntity)this.get(TmActRoleEntity.class, (Serializable)((Object)roleId));
        if (roleEntity == null) {
            throw new BusinessException("\u89d2\u8272Id\u503c\u4e0d\u5b58\u5728");
        }
        rPositionActRoleEntity.setTmPosition(positionEntity);
        rPositionActRoleEntity.setTmActRole(roleEntity);
        this.save((Object)rPositionActRoleEntity);
    }

    public void deletePositionRoleRelation(String relationIds) {
        String[] relationIdArr;
        for (String relationId : relationIdArr = relationIds.split(",")) {
            TmRPositionRoleEntity rPositionRoleEntity = (TmRPositionRoleEntity)this.get(TmRPositionRoleEntity.class, (Serializable)((Object)relationId));
            this.addDeletePositionRoleRelationLog(rPositionRoleEntity);
            this.delete((Object)rPositionRoleEntity);
        }
    }

    public void deletePositionActRoleRelation(String relationIds) {
        String[] relationIdArr;
        for (String relationId : relationIdArr = relationIds.split(",")) {
            TmRPositionActRoleEntity rPositionActRoleEntity = (TmRPositionActRoleEntity)this.get(TmRPositionActRoleEntity.class, (Serializable)((Object)relationId));
            this.addDeletePositionActRoleRelationLog(rPositionActRoleEntity);
            this.delete((Object)rPositionActRoleEntity);
        }
    }

    private void addDeletePositionRoleRelationLog(TmRPositionRoleEntity rPositionRoleEntity) {
        String logContent = "\u53d6\u6d88\u5173\u8054\u89d2\u8272[" + rPositionRoleEntity.getTmRole().getRoleCode() + "-" + rPositionRoleEntity.getTmRole().getRoleName() + "]";
        super.addLogAndRemoveInvalidInfo(rPositionRoleEntity.getId(), (Object)rPositionRoleEntity, rPositionRoleEntity.getTmPosition().getId(), logContent);
    }

    private void addDeletePositionActRoleRelationLog(TmRPositionActRoleEntity rPositionActRoleEntity) {
        String logContent = "\u53d6\u6d88\u5173\u8054\u89d2\u8272[" + rPositionActRoleEntity.getTmActRole().getRoleCode() + "-" + rPositionActRoleEntity.getTmActRole().getRoleName() + "]";
        super.addLogAndRemoveInvalidInfo(rPositionActRoleEntity.getId(), (Object)rPositionActRoleEntity, rPositionActRoleEntity.getTmPosition().getId(), logContent);
    }

    public void updatePositionRoleRelation(String relationIds, String roleId) {
        String[] relationIdArr;
        for (String relationId : relationIdArr = relationIds.split(",")) {
            this.updatePositionRoleRelationItem(relationId, roleId);
        }
    }

    public void updatePositionActRoleRelation(String relationIds, String roleId) {
        String[] relationIdArr;
        for (String relationId : relationIdArr = relationIds.split(",")) {
            this.updatePositionActRoleRelationItem(relationId, roleId);
        }
    }

    public List<TmPositionEntity> findBelowPosIdByPosId(String posId) {
        return this.tmPositionDao.findBelowPosIdByPosId(posId);
    }

    private void updatePositionRoleRelationItem(String relationId, String roleId) {
        TmRPositionRoleEntity rPositionRoleEntity = (TmRPositionRoleEntity)this.get(TmRPositionRoleEntity.class, (Serializable)((Object)relationId));
        TmRoleEntity roleEntity = (TmRoleEntity)this.get(TmRoleEntity.class, (Serializable)((Object)roleId));
        if (roleEntity == null) {
            throw new BusinessException("\u89d2\u8272Id\u503c\u4e0d\u5b58\u5728");
        }
        this.addUpdatePositionRoleRelationItemLog(rPositionRoleEntity, roleEntity);
        rPositionRoleEntity.setTmRole(roleEntity);
        this.updateEntity((Object)rPositionRoleEntity);
    }

    private void updatePositionActRoleRelationItem(String relationId, String roleId) {
        TmRPositionActRoleEntity rPositionActRoleEntity = (TmRPositionActRoleEntity)this.get(TmRPositionActRoleEntity.class, (Serializable)((Object)relationId));
        TmActRoleEntity roleEntity = (TmActRoleEntity)this.get(TmActRoleEntity.class, (Serializable)((Object)roleId));
        if (roleEntity == null) {
            throw new BusinessException("\u89d2\u8272Id\u503c\u4e0d\u5b58\u5728");
        }
        this.addUpdatePositionActRoleRelationItemLog(rPositionActRoleEntity, roleEntity);
        rPositionActRoleEntity.setTmActRole(roleEntity);
        this.updateEntity((Object)rPositionActRoleEntity);
    }

    private void addUpdatePositionRoleRelationItemLog(TmRPositionRoleEntity rPositionRoleEntity, TmRoleEntity newRoleEntity) {
        String logContent = "\u66ff\u6362\u89d2\u8272[" + rPositionRoleEntity.getTmRole().getRoleCode() + "-" + rPositionRoleEntity.getTmRole().getRoleName() + "]\u4e3a[" + newRoleEntity.getRoleCode() + "-" + newRoleEntity.getRoleName() + "]";
        super.addLogAndRemoveInvalidInfo(rPositionRoleEntity.getId(), (Object)rPositionRoleEntity, rPositionRoleEntity.getTmPosition().getId(), logContent, "UPDATE");
    }

    private void addUpdatePositionActRoleRelationItemLog(TmRPositionActRoleEntity rPositionActRoleEntity, TmActRoleEntity newRoleEntity) {
        String logContent = "\u66ff\u6362\u89d2\u8272[" + rPositionActRoleEntity.getTmActRole().getRoleCode() + "-" + rPositionActRoleEntity.getTmActRole().getRoleName() + "]\u4e3a[" + newRoleEntity.getRoleCode() + "-" + newRoleEntity.getRoleName() + "]";
        super.addLogAndRemoveInvalidInfo(rPositionActRoleEntity.getId(), (Object)rPositionActRoleEntity, rPositionActRoleEntity.getTmPosition().getId(), logContent, "UPDATE");
    }
}

