/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.productInfo.controller;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.service.TbAttachmentService;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.entity.TbAttachmentEntity;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.product.service.TmProductService;
import com.biz.eisp.mdm.product.vo.TmProductVo;
import com.biz.eisp.mdm.productInfo.service.TmProductInfoService;
import com.biz.eisp.mdm.productInfo.vo.TmProductInfoVo;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmProductInfoController"})
public class TmProductInfoController
extends BaseController {
    @Autowired
    private TmProductInfoService tmProductInfoService;
    @Autowired
    private TmProductService tmProductService;
    @Autowired
    private TbAttachmentService tbAttachmentService;

    @RequestMapping(params={"goProductInfoList"})
    public ModelAndView goProductInfoList(HttpServletRequest req, HttpServletResponse response) {
        return new ModelAndView("com/biz/eisp/mdm/tmProductInfo/tmProductInfoMain");
    }

    @RequestMapping(params={"goUploadProductPic"})
    public ModelAndView goUploadProductPic(String id, String extendService, String attachmentType, HttpServletRequest request) {
        List voList = this.tbAttachmentService.findTbAttachmentList(id, attachmentType);
        request.setAttribute("voList", (Object)voList);
        request.setAttribute("businessKey", (Object)id);
        request.setAttribute("attachmentType", (Object)attachmentType);
        request.setAttribute("extendService", (Object)extendService);
        String extend = request.getParameter("extend");
        if (StringUtil.isEmpty((String)extend)) {
            extend = "*.*";
        }
        request.setAttribute("extend", (Object)extend);
        return new ModelAndView("com/biz/eisp/mdm/tmProductInfo/uploadProductPic");
    }

    @RequestMapping(params={"findProductInfoMainGrid"})
    @ResponseBody
    public DataGrid findProductInfoMainGrid(HttpServletRequest req, TmProductInfoVo tmProductInfoVo, HttpServletResponse response) {
        this.page = new EuPage(req);
        List icons = this.tmProductInfoService.findProductInfoMainGrid(tmProductInfoVo, this.page);
        return new DataGrid(icons, this.page);
    }

    @RequestMapping(params={"saveFiles"})
    @ResponseBody
    public AjaxJson saveFiles(HttpServletRequest req, HttpServletResponse response, String fileJson, String businessKey) {
        AjaxJson msg = new AjaxJson();
        if (StringUtil.isNotEmpty((String)fileJson)) {
            List fileEntities = JSONArray.parseArray((String)fileJson, TbAttachmentEntity.class);
            for (TbAttachmentEntity fileEntity : fileEntities) {
                fileEntity.setBusinessKey(businessKey);
                this.tbAttachmentService.save((Object)fileEntity);
            }
        }
        return msg;
    }

    @ResponseBody
    @RequestMapping(params={"deletefile"})
    public AjaxJson deletefile(String id) {
        AjaxJson j = new AjaxJson();
        try {
            TbAttachmentEntity tbAttachmentEntity = (TbAttachmentEntity)this.tbAttachmentService.get(TbAttachmentEntity.class, (Serializable)((Object)id));
            this.tbAttachmentService.delete((Object)tbAttachmentEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"addOrUpdate"})
    @ResponseBody
    public AjaxJson addOrUpdateIcon(TmProductInfoVo tmProductInfoVo, HttpServletRequest req, HttpServletResponse response) {
        AjaxJson msg = new AjaxJson();
        if (StringUtil.isNotEmpty((String)tmProductInfoVo.getId())) {
            List list1;
            TmProductInfoVo vo1;
            List list2;
            TmProductInfoVo vo2;
            TmProductInfoVo productInfoVo = this.tmProductInfoService.getProductInfoById(tmProductInfoVo.getId());
            if (StringUtil.isNotEmpty((String)productInfoVo.getProductInfoCode())) {
                if (!productInfoVo.getProductInfoCode().equals(tmProductInfoVo.getProductInfoCode())) {
                    vo2 = new TmProductInfoVo();
                    vo2.setProductInfoCode(tmProductInfoVo.getProductInfoCode());
                    list2 = this.tmProductInfoService.getTmProductInfoList(vo2);
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)list2)) {
                        msg.setSuccess(false);
                        msg.setMsg("\u4ea7\u54c1\u7f16\u7801\u5df2\u5b58\u5728");
                        return msg;
                    }
                }
            } else {
                vo2 = new TmProductInfoVo();
                vo2.setProductInfoCode(tmProductInfoVo.getProductInfoCode());
                list2 = this.tmProductInfoService.getTmProductInfoList(vo2);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)list2)) {
                    msg.setSuccess(false);
                    msg.setMsg("\u4ea7\u54c1\u7f16\u7801\u5df2\u5b58\u5728");
                    return msg;
                }
            }
            if (StringUtil.isNotEmpty((String)productInfoVo.getAiCode())) {
                if (!productInfoVo.getAiCode().equals(tmProductInfoVo.getAiCode())) {
                    vo1 = new TmProductInfoVo();
                    vo1.setAiCode(tmProductInfoVo.getAiCode());
                    list1 = this.tmProductInfoService.getTmProductInfoList(vo1);
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)list1)) {
                        msg.setSuccess(false);
                        msg.setMsg("AI\u7f16\u7801\u5df2\u5b58\u5728");
                        return msg;
                    }
                }
            } else {
                vo1 = new TmProductInfoVo();
                vo1.setAiCode(tmProductInfoVo.getAiCode());
                list1 = this.tmProductInfoService.getTmProductInfoList(vo1);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)list1)) {
                    msg.setSuccess(false);
                    msg.setMsg("AI\u7f16\u7801\u5df2\u5b58\u5728");
                    return msg;
                }
            }
            String result = this.tmProductInfoService.saveOrUpdateProductInfo(tmProductInfoVo);
            msg.setMsg(result);
        } else {
            TmProductInfoVo vo1 = new TmProductInfoVo();
            vo1.setAiCode(tmProductInfoVo.getAiCode());
            List list1 = this.tmProductInfoService.getTmProductInfoList(vo1);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list1)) {
                msg.setSuccess(false);
                msg.setMsg("AI\u7f16\u7801\u5df2\u5b58\u5728");
                return msg;
            }
            TmProductInfoVo vo2 = new TmProductInfoVo();
            vo2.setProductInfoCode(tmProductInfoVo.getProductInfoCode());
            List list2 = this.tmProductInfoService.getTmProductInfoList(vo2);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list2)) {
                msg.setSuccess(false);
                msg.setMsg("\u4ea7\u54c1\u7f16\u7801\u5df2\u5b58\u5728");
                return msg;
            }
            String result = this.tmProductInfoService.saveOrUpdateProductInfo(tmProductInfoVo);
            msg.setMsg(result);
        }
        return msg;
    }

    @RequestMapping(params={"goSaveOrUpdateForm"})
    public ModelAndView goSaveOrUpdateForm(TmProductInfoVo ic, HttpServletRequest req, HttpServletResponse response) {
        if (StringUtil.isNotEmpty((String)ic.getId())) {
            TmProductInfoVo vo = this.tmProductInfoService.getProductInfoById(ic.getId());
            req.setAttribute("vo", (Object)vo);
        }
        return new ModelAndView("com/biz/eisp/mdm/tmProductInfo/tmProductInfoForm");
    }

    @RequestMapping(params={"delProductInfo"})
    @ResponseBody
    public AjaxJson delProductInfo(String ids) {
        AjaxJson j = this.tmProductInfoService.delProductInfo(ids);
        return j;
    }

    @RequestMapping(params={"goTmProductMain"})
    public ModelAndView goTmProductLevelMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/tmProductInfo/tmSelectProductMain");
    }

    @RequestMapping(params={"findTmProductList"})
    @ResponseBody
    public List<TmProductVo> findTmProductList(HttpServletRequest request, TmProductVo productVo) {
        List voList = this.tmProductService.findTmProductList(productVo);
        return voList;
    }

    @RequestMapping(params={"validateProductInfoCode"})
    @ResponseBody
    public ValidForm validateProductInfoCode(HttpServletRequest request, TmProductInfoVo vo) {
        String param = OConvertUtils.getString((String)request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        try {
            vo.setProductInfoCode(param);
            List list = this.tmProductInfoService.getTmProductInfoList(vo);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                validForm.setStatus("n");
                validForm.setInfo("\u4ea7\u54c1\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return validForm;
    }
}

