/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.terminal.transformer;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.generatednum.num.util.TbNumRuleProvider;
import com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.util.ValidateUtil;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.product.entity.TmProductEntity;
import com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGDetailEntity;
import com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGEntity;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.service.TmTerminalService;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TmTerminalVoToTmTerminalEntity
implements Function<TmTerminalVo, TmTerminalEntity> {
    private TmTerminalService tmTerminalService;
    private TbNumRuleProvider tbNumRuleProvider = null;
    private List<TmBusinessGroupVo> addBusinessGroupVoList;
    private List<TmBusinessGroupVo> deleteBusinessGroupVoList;
    private String[] channelCodes;
    private String[] orgIds;
    private String[] productCodes;
    private String[] businessAreaCodes;
    private String[] bgExtChar1s;
    private String[] bgExtChar2s;

    public TmTerminalVoToTmTerminalEntity(TmTerminalService tmTerminalService, List<TmBusinessGroupVo> addBusinessGroupVoList, List<TmBusinessGroupVo> deleteBusinessGroupVoList) {
        this.tmTerminalService = tmTerminalService;
        this.tbNumRuleProvider = (TbNumRuleProvider)ApplicationContextUtils.getContext().getBean("tbNumRuleProvider");
        this.addBusinessGroupVoList = addBusinessGroupVoList;
        this.deleteBusinessGroupVoList = deleteBusinessGroupVoList;
    }

    public TmTerminalEntity apply(TmTerminalVo input) {
        TmOrgEntity tmOrg;
        TmTerminalEntity terminalEntity = null;
        if (StringUtil.isNotEmpty((String)input.getId())) {
            terminalEntity = (TmTerminalEntity)this.tmTerminalService.get(TmTerminalEntity.class, (Serializable)((Object)input.getId()));
        } else {
            if (StringUtil.isEmpty((String)input.getTerminalName())) {
                throw new BusinessException("\u7ec8\u7aef\u540d\u79f0\u4e3a\u7a7a");
            }
            List list = this.tmTerminalService.findByHql("from TmTerminalEntity where terminalName=? ", new Object[]{input.getTerminalName()});
            if (list == null || list.size() > 0) {
                // empty if block
            }
            terminalEntity = new TmTerminalEntity();
            if (StringUtil.isEmpty((String)input.getTerminalCode())) {
                TbNumRuleProvider tbNumRuleProvider = (TbNumRuleProvider)ApplicationContextUtils.getContext().getBean("tbNumRuleProvider");
                String terminalCode = tbNumRuleProvider.getMaxNum("terminal");
                terminalEntity.setTerminalCode(terminalCode);
                input.setTerminalCode(terminalCode);
            } else {
                terminalEntity.setTerminalCode(input.getTerminalCode());
            }
        }
        if (StringUtil.isNotEmpty((String)input.getTerminalName()) && ValidateUtil.validateName((String)input.getTerminalName(), (String)"[`~!@#$%^&* +=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u2019\u3002\uff0c\u3001\uff1f]")) {
            throw new BusinessException("\u68c0\u6d4b\u5230\u7ec8\u7aef\u540d\u79f0\u5305\u542b\u975e\u6cd5\u5b57\u7b26:" + input.getTerminalName());
        }
        if (StringUtil.isNotEmpty((String)input.getErpCode()) && !ValidateUtil.validateName((String)input.getErpCode(), (String)"[a-z0-9A-Z]")) {
            throw new BusinessException("\u68c0\u6d4b\u5230\u7ec8\u7aefERP\u7f16\u7801\u5305\u542b\u975e\u6cd5\u5b57\u7b26:" + input.getErpCode() + "\uff0c\u53ea\u80fd\u4e3a\u6570\u5b57\u548c\u5b57\u6bcd");
        }
        this.copyProperties(input, terminalEntity);
        if (StringUtil.isNotEmpty((String)input.getOrgId())) {
            tmOrg = (TmOrgEntity)this.tmTerminalService.get(TmOrgEntity.class, (Serializable)((Object)input.getOrgId()));
            if (tmOrg == null) {
                throw new BusinessException("\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u627e\u4e0d\u5230:" + input.getOrgId());
            }
            terminalEntity.setTmOrg(tmOrg);
        }
        if (StringUtil.isNotEmpty((String)input.getOrgName())) {
            tmOrg = (TmOrgEntity)this.tmTerminalService.findUniqueByProperty(TmOrgEntity.class, "orgCode", (Object)input.getOrgName());
            if (tmOrg == null) {
                throw new BusinessException("\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u627e\u4e0d\u5230:" + input.getOrgName());
            }
            terminalEntity.setTmOrg(tmOrg);
        }
        terminalEntity.setTmRTermCustPosBGList(this.getTermCustPostList(terminalEntity, input));
        return terminalEntity;
    }

    private void initBusinessGroupInfo(List<TmRTermCustPosBGEntity> termPostList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(termPostList)) {
            for (TmRTermCustPosBGEntity entity : termPostList) {
                List detailEntityList = this.tmTerminalService.findByProperty(TmRTermCustPosBGDetailEntity.class, "businessGroup", (Object)entity.getBusinessGroup());
                for (TmRTermCustPosBGDetailEntity detailEntity : detailEntityList) {
                    TmBusinessGroupVo businessGroupVo = new TmBusinessGroupVo();
                    businessGroupVo.setBusinessGroup(detailEntity.getBusinessGroup());
                    businessGroupVo.setDetailCode(detailEntity.getDetailCode());
                    businessGroupVo.setDetailName(detailEntity.getDetailName());
                    businessGroupVo.setTypeCode(detailEntity.getTypeCode());
                    businessGroupVo.setTypeName(detailEntity.getTypeName());
                    businessGroupVo.setPositionId(entity.getTmPosition() == null ? "" : entity.getTmPosition().getId());
                    businessGroupVo.setOrgId(entity.getOrgId());
                    TmCustomerEntity customerEntity = entity.getTmCustomer();
                    if (customerEntity != null) {
                        businessGroupVo.setCustomerId(customerEntity.getId());
                        businessGroupVo.setCustomerCode(customerEntity.getCustomerCode());
                        businessGroupVo.setCustomerName(customerEntity.getCustomerName());
                    }
                    this.deleteBusinessGroupVoList.add(businessGroupVo);
                }
            }
        }
    }

    private void initBusinessGroupVoInfo(TmTerminalVo input) {
        this.channelCodes = StringUtils.isNotBlank((CharSequence)input.getChannelCode()) ? input.getChannelCode().split(",", -1) : null;
        this.orgIds = StringUtils.isNotBlank((CharSequence)input.getBusinessGroupOrgId()) ? input.getBusinessGroupOrgId().split(",", -1) : null;
        this.productCodes = StringUtils.isNotBlank((CharSequence)input.getProductCode()) ? input.getProductCode().split(",", -1) : null;
        this.businessAreaCodes = StringUtils.isNotBlank((CharSequence)input.getBusinessAreaCode()) ? input.getBusinessAreaCode().split(",", -1) : null;
        this.bgExtChar1s = StringUtils.isNotBlank((CharSequence)input.getBgExtChar1s()) ? input.getBgExtChar1s().split(",") : null;
        this.bgExtChar2s = StringUtils.isNotBlank((CharSequence)input.getBgExtChar2s()) ? input.getBgExtChar2s().split(",") : null;
    }

    private List<TmRTermCustPosBGEntity> getTermCustPostList(TmTerminalEntity terminalEntity, TmTerminalVo tmTerminalVo) {
        ArrayList<TmRTermCustPosBGEntity> custPostList = new ArrayList<TmRTermCustPosBGEntity>();
        this.initBusinessGroupInfo(terminalEntity.getTmRTermCustPosBGList());
        String relationIndex = tmTerminalVo.getRelationIndex();
        String customerId = tmTerminalVo.getCustomerId();
        String positionId = tmTerminalVo.getPositionIds();
        String termCustId = tmTerminalVo.getTermCustId();
        String[] relationIndexs = null;
        String[] customerIds = null;
        String[] positionIds = null;
        String[] ids = null;
        if (StringUtil.isEmpty((String)relationIndex)) {
            if (StringUtil.isNotEmpty((String)positionId) && StringUtil.isNotEmpty((String)customerId)) {
                customerIds = customerId.split(",");
                positionIds = positionId.split(",");
                relationIndexs = positionIds.length > customerIds.length ? positionIds : customerIds;
                ids = new String[relationIndexs.length];
            } else if (StringUtil.isNotEmpty((String)customerId) && StringUtil.isEmpty((String)positionId)) {
                relationIndexs = customerIds = customerId.split(",");
                positionIds = new String[relationIndexs.length];
                ids = new String[relationIndexs.length];
            } else if (StringUtil.isEmpty((String)customerId) && StringUtil.isNotEmpty((String)positionId)) {
                relationIndexs = positionIds = positionId.split(",");
                customerIds = new String[relationIndexs.length];
                ids = new String[relationIndexs.length];
            }
        } else {
            relationIndexs = relationIndex.split(",");
            ids = new String[relationIndexs.length];
            customerIds = new String[relationIndexs.length];
            positionIds = new String[relationIndexs.length];
            if (StringUtil.isNotEmpty((String)customerId)) {
                customerIds = customerId.split(",");
            }
            if (StringUtil.isNotEmpty((String)positionId)) {
                positionIds = positionId.split(",");
            }
            if (StringUtil.isNotEmpty((String)termCustId)) {
                ids = termCustId.split(",");
            }
        }
        this.initBusinessGroupVoInfo(tmTerminalVo);
        if (relationIndexs == null || relationIndexs.length == 0) {
            return custPostList;
        }
        for (int i = 0; i < relationIndexs.length; ++i) {
            TmRTermCustPosBGEntity tmTermCustPosBgEntity = new TmRTermCustPosBGEntity();
            tmTermCustPosBgEntity.setTmTerminal(terminalEntity);
            String postId = "";
            if (positionIds.length > i) {
                postId = positionIds[i];
            }
            String custId = "";
            if (customerIds.length > i) {
                custId = customerIds[i];
            }
            String id = "";
            if (ids.length > i) {
                id = ids[i];
            }
            if (StringUtil.isNotEmpty((String)id)) {
                tmTermCustPosBgEntity = (TmRTermCustPosBGEntity)this.tmTerminalService.get(TmRTermCustPosBGEntity.class, (Serializable)((Object)id));
                TmPositionEntity newPostEntity = null;
                TmCustomerEntity customerEntity = null;
                if (StringUtils.isNotBlank((CharSequence)postId)) {
                    newPostEntity = (TmPositionEntity)this.tmTerminalService.get(TmPositionEntity.class, (Serializable)((Object)postId));
                    this.setPositionValue(newPostEntity.getId(), tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
                }
                tmTermCustPosBgEntity.setTmPosition(newPostEntity);
                if (StringUtils.isNotBlank((CharSequence)custId)) {
                    customerEntity = (TmCustomerEntity)this.tmTerminalService.get(TmCustomerEntity.class, (Serializable)((Object)custId));
                }
                tmTermCustPosBgEntity.setTmCustomer(customerEntity);
                if (this.orgIds != null && this.orgIds.length > i) {
                    tmTermCustPosBgEntity.setOrgId(this.orgIds[i]);
                    this.setOrgValue(this.orgIds[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
                }
                if (this.bgExtChar1s != null && this.bgExtChar1s.length > i) {
                    tmTermCustPosBgEntity.setExtChar1(this.bgExtChar1s[i]);
                }
                if (this.bgExtChar2s != null && this.bgExtChar2s.length > i) {
                    tmTermCustPosBgEntity.setExtChar2(this.bgExtChar2s[i]);
                }
                this.setChannelValue(this.channelCodes == null ? null : this.channelCodes[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
                this.setProductValue(this.productCodes == null ? null : this.productCodes[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
                this.setBusinessAreaValue(this.businessAreaCodes == null ? null : this.businessAreaCodes[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
                custPostList.add(tmTermCustPosBgEntity);
                continue;
            }
            tmTermCustPosBgEntity.setBusinessGroup(this.tbNumRuleProvider.getMaxNum("business_group"));
            if (StringUtil.isNotEmpty((String)postId)) {
                TmPositionEntity position = (TmPositionEntity)this.tmTerminalService.get(TmPositionEntity.class, (Serializable)((Object)postId));
                if (position == null) {
                    for (TmRTermCustPosBGEntity custPostEntity : custPostList) {
                        if (!custPostEntity.getTmPosition().getPositionCode().equals(postId)) continue;
                        throw new BusinessException("\u5bf9\u5e94\u804c\u4f4d\u4fe1\u606f[" + postId + "]\u5b58\u5728\u76f8\u540c\u7684\u591a\u4e2a\u7f16\u7801");
                    }
                    position = (TmPositionEntity)this.tmTerminalService.findUniqueByProperty(TmPositionEntity.class, "positionCode", (Object)postId);
                }
                if (position == null) {
                    throw new BusinessException("\u804c\u4f4d\u4fe1\u606f[" + positionId + "]\u4e0d\u5b58\u5728");
                }
                if (Globals.ONE.equals(position.getEnableStatus())) {
                    throw new BusinessException("\u804c\u4f4d\u4fe1\u606f[" + positionId + "]\u5df2\u505c\u7528");
                }
                tmTermCustPosBgEntity.setTmPosition(position);
                this.setPositionValue(position.getId(), tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
            }
            if (StringUtil.isNotEmpty((String)custId)) {
                TmCustomerEntity customer = (TmCustomerEntity)this.tmTerminalService.get(TmCustomerEntity.class, (Serializable)((Object)custId));
                if (customer == null) {
                    for (TmRTermCustPosBGEntity custPostEntity : custPostList) {
                        if (!custPostEntity.getTmCustomer().getCustomerCode().equals(custId) || !StringUtil.isNotEmpty((String)positionId) || !positionId.equals(custPostEntity.getTmPosition().getPositionCode())) continue;
                        throw new BusinessException("\u5bf9\u5e94\u4e0a\u7ea7\u5ba2\u6237\u4fe1\u606f[" + custId + "]\u5b58\u5728\u76f8\u540c\u7684\u591a\u4e2a\u7f16\u7801");
                    }
                    customer = (TmCustomerEntity)this.tmTerminalService.findUniqueByProperty(TmCustomerEntity.class, "customerCode", (Object)custId);
                }
                if (customer == null) {
                    throw new BusinessException("\u4e0a\u7ea7\u5ba2\u6237\u4fe1\u606f[" + custId + "]\u4e0d\u5b58\u5728");
                }
                if (Globals.ONE.equals(customer.getEnableStatus())) {
                    throw new BusinessException("\u4e0a\u7ea7\u5ba2\u6237\u4fe1\u606f[" + custId + "]\u5df2\u505c\u7528");
                }
                tmTermCustPosBgEntity.setTmCustomer(customer);
            }
            if (this.orgIds != null && this.orgIds.length > i) {
                tmTermCustPosBgEntity.setOrgId(this.orgIds[i]);
                this.setOrgValue(this.orgIds[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
            }
            if (this.bgExtChar1s != null && this.bgExtChar1s.length > i) {
                tmTermCustPosBgEntity.setExtChar1(this.bgExtChar1s[i]);
            }
            if (this.bgExtChar2s != null && this.bgExtChar2s.length > i) {
                tmTermCustPosBgEntity.setExtChar2(this.bgExtChar2s[i]);
            }
            this.setChannelValue(this.channelCodes == null ? null : this.channelCodes[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
            this.setProductValue(this.productCodes == null ? null : this.productCodes[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
            this.setBusinessAreaValue(this.businessAreaCodes == null ? null : this.businessAreaCodes[i], tmTermCustPosBgEntity.getBusinessGroup(), tmTermCustPosBgEntity);
            custPostList.add(tmTermCustPosBgEntity);
        }
        return custPostList;
    }

    private void setBusinessAreaValue(String businessAreaCode, String businessGroup, TmRTermCustPosBGEntity tmTermCustPosBgEntity) {
        if (StringUtils.isNotBlank((CharSequence)businessAreaCode)) {
            String[] detailCodeArr;
            for (String detail : detailCodeArr = businessAreaCode.split(";")) {
                TmBusinessGroupVo vo = new TmBusinessGroupVo();
                vo.setBusinessGroup(businessGroup);
                vo.setDetailCode(detail);
                TmBusinessAreaEntity businessAreaEntity = (TmBusinessAreaEntity)this.tmTerminalService.findUniqueByProperty(TmBusinessAreaEntity.class, "businessAreaCode", (Object)detail);
                vo.setDetailName(businessAreaEntity.getBusinessAreaName());
                vo.setTypeCode("businessAreaCode");
                vo.setTypeName("\u4e1a\u52a1\u533a\u57df");
                vo.setFlag("add");
                vo.setOrgId(tmTermCustPosBgEntity.getOrgId());
                vo.setPositionId(tmTermCustPosBgEntity.getTmPosition() != null ? tmTermCustPosBgEntity.getTmPosition().getId() : "");
                this.addBusinessGroupVoList.add(vo);
            }
        }
    }

    private void setOrgValue(String orgId, String businessGroup, TmRTermCustPosBGEntity tmTermCustPosBgEntity) {
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            TmBusinessGroupVo vo = new TmBusinessGroupVo();
            TmCustomerOrgEntity orgEntity = (TmCustomerOrgEntity)this.tmTerminalService.get(TmCustomerOrgEntity.class, (Serializable)((Object)tmTermCustPosBgEntity.getOrgId()));
            vo.setBusinessGroup(businessGroup);
            vo.setDetailCode("");
            if (orgEntity != null) {
                vo.setDetailName(orgEntity.getCustomerOrgName());
            }
            vo.setTypeCode("orgCode");
            vo.setTypeName("\u6240\u5c5e\u5206\u90e8");
            vo.setFlag("add");
            vo.setOrgId(tmTermCustPosBgEntity.getOrgId());
            vo.setPositionId(tmTermCustPosBgEntity.getTmPosition() != null ? tmTermCustPosBgEntity.getTmPosition().getId() : "");
            this.addBusinessGroupVoList.add(vo);
        }
    }

    private void setPositionValue(String positionId, String businessGroup, TmRTermCustPosBGEntity tmTermCustPosBgEntity) {
        if (StringUtils.isNotBlank((CharSequence)positionId)) {
            TmBusinessGroupVo vo = new TmBusinessGroupVo();
            vo.setBusinessGroup(businessGroup);
            vo.setDetailCode("");
            vo.setDetailName(tmTermCustPosBgEntity.getTmPosition() != null ? tmTermCustPosBgEntity.getTmPosition().getPositionName() : "");
            vo.setTypeCode("positionCode");
            vo.setTypeName("\u5bf9\u63a5\u4eba\u804c\u4f4d");
            vo.setFlag("add");
            vo.setOrgId(tmTermCustPosBgEntity.getOrgId());
            vo.setPositionId(tmTermCustPosBgEntity.getTmPosition() != null ? tmTermCustPosBgEntity.getTmPosition().getId() : "");
            this.addBusinessGroupVoList.add(vo);
        }
    }

    private void setChannelValue(String channelCode, String businessGroup, TmRTermCustPosBGEntity tmTermCustPosBgEntity) {
        if (StringUtils.isNotBlank((CharSequence)channelCode)) {
            String[] detailCodeArr;
            for (String detail : detailCodeArr = channelCode.split(";")) {
                TmBusinessGroupVo vo = new TmBusinessGroupVo();
                vo.setBusinessGroup(businessGroup);
                vo.setDetailCode(detail);
                vo.setDetailName(DictUtil.getDicDataValByCode((String)"channel", (String)detail));
                vo.setTypeCode("channelCode");
                vo.setTypeName("\u6e20\u9053");
                vo.setFlag("add");
                vo.setOrgId(tmTermCustPosBgEntity.getOrgId());
                vo.setPositionId(tmTermCustPosBgEntity.getTmPosition() != null ? tmTermCustPosBgEntity.getTmPosition().getId() : "");
                this.addBusinessGroupVoList.add(vo);
            }
        }
    }

    private void setProductValue(String productCode, String businessGroup, TmRTermCustPosBGEntity tmTermCustPosBgEntity) {
        if (StringUtils.isNotBlank((CharSequence)productCode)) {
            String[] detailCodeArr;
            for (String detail : detailCodeArr = productCode.split(";")) {
                TmBusinessGroupVo vo = new TmBusinessGroupVo();
                vo.setBusinessGroup(businessGroup);
                vo.setDetailCode(detail);
                TmProductEntity productEntity = (TmProductEntity)this.tmTerminalService.findUniqueByProperty(TmProductEntity.class, "productCode", (Object)detail);
                vo.setDetailName(productEntity.getProductName());
                vo.setTypeCode("productCode");
                vo.setTypeName("\u4ea7\u54c1");
                vo.setFlag("add");
                vo.setOrgId(tmTermCustPosBgEntity.getOrgId());
                vo.setPositionId(tmTermCustPosBgEntity.getTmPosition() != null ? tmTermCustPosBgEntity.getTmPosition().getId() : "");
                this.addBusinessGroupVoList.add(vo);
            }
        }
    }

    public void copyProperties(TmTerminalVo vo, TmTerminalEntity entity) {
        entity.setLinkman(vo.getLinkman());
        entity.setLinkmanPhone(vo.getLinkmanPhone());
        entity.setProvince(vo.getProvince());
        entity.setTerminalCode(vo.getTerminalCode());
        entity.setTerminalName(vo.getTerminalName());
        entity.setTerminalType(vo.getTerminalType());
        entity.setAddress(vo.getAddress());
        entity.setArea(vo.getArea());
        entity.setChannelType(vo.getChannelType());
        entity.setCity(vo.getCity());
        entity.setCooperative(vo.getCooperative());
        entity.setEnableStatus(vo.getEnableStatus());
        entity.setErpCode(vo.getErpCode());
        if (StringUtil.isNotEmpty((String)vo.getOrgId())) {
            TmOrgEntity orgEntity = (TmOrgEntity)this.tmTerminalService.get(TmOrgEntity.class, (Serializable)((Object)vo.getOrgId()));
            entity.setTmOrg(orgEntity);
        }
        entity.setExtChar1(vo.getExtChar1());
        entity.setExtChar2(vo.getExtChar2());
        entity.setExtChar3(vo.getExtChar3());
        entity.setExtChar4(vo.getExtChar4());
        entity.setExtChar5(vo.getExtChar5());
        entity.setExtChar6(vo.getExtChar6());
        entity.setExtChar7(vo.getExtChar7());
        entity.setExtChar8(vo.getExtChar8());
        entity.setExtChar9(vo.getExtChar9());
        entity.setExtChar10(vo.getExtChar10());
        entity.setExtChar11(vo.getExtChar11());
        entity.setExtChar12(vo.getExtChar12());
        entity.setExtChar13(vo.getExtChar13());
        entity.setExtChar14(vo.getExtChar14());
        entity.setExtChar15(vo.getExtChar15());
        entity.setExtChar16(vo.getExtChar16());
        entity.setExtChar17(vo.getExtChar17());
        entity.setExtChar18(vo.getExtChar18());
        entity.setExtChar19(vo.getExtChar19());
        entity.setExtChar20(vo.getExtChar20());
        entity.setExtChar21(vo.getExtChar21());
        entity.setExtChar22(vo.getExtChar22());
        entity.setExtChar23(vo.getExtChar23());
        entity.setExtChar24(vo.getExtChar24());
        entity.setExtChar25(vo.getExtChar25());
        entity.setExtChar26(vo.getExtChar26());
        entity.setExtChar27(vo.getExtChar27());
        entity.setExtChar28(vo.getExtChar28());
        entity.setExtChar29(vo.getExtChar29());
        entity.setExtChar30(vo.getExtChar30());
        entity.setExtNumber1(vo.getExtNumber1());
        entity.setExtNumber2(vo.getExtNumber2());
        entity.setExtNumber3(vo.getExtNumber3());
        entity.setExtNumber4(vo.getExtNumber4());
        entity.setExtNumber5(vo.getExtNumber5());
    }
}

