<%@ page language="java" import="java.util.*" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>客户管理</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        #steps form div.form {
            float: left;
            width: 300px !important;
            min-height: 26px;
            padding-left: 115px !important;
        }

        #steps form div.form .Validform_label {
            width: 115px;
            margin-right: 5px;
        }

        #steps form textarea {
            height: 24px;
        }

        .formDiv {
            float: left;
        }
    </style>
</head>
<body>
<t:formvalid formid="formobj" layout="div" dialog="true" refresh="true"
             action="tmCustomerController.do?saveTmCustomer">
    <div>
        <!-- 动态表单加载  -->
        <t:formmdm extendTableName="${extendTableName}" optype="${optype}" objName="${extendTableName}"></t:formmdm>
        <div style="clear:both;"></div>
    </div>
    <!-- 自定义表单 begin -->
    <c:choose>
        <c:when test="${!empty custPostList}">
            <!-- 读取当前客户经理职位信息 begin -->
            <c:forEach var="items" items="${custPostList}" varStatus="idx">
                <div class="formDiv mt10" data-index="${idx.index}">
                    <input type="hidden" name="custPostId" value="${items.id}"/>
                    <input type="hidden" name="relationIndex" value="${idx.index}"/>
                    <div class="form">
                        <label class="Validform_label flex flex-align-items-center flex-justify-content-end"
                               name="orgName">
                            <c:if test="${optype!=2}">
                                <img src='resources/easyui/themes/icons/remove.png' class='formDivRemove'
                                     onclick='removePosition(this)'
                                     style='padding: 4px;cursor: pointer;width: 16px;height: 16px;'/>
                            </c:if>
                            所属部门${idx.index+1}:
                        </label>
                        <input id="orgName" name="orgName" readonly="readonly" value="${items.orgName }" class="inputxt"
                               onClick="chooseOrg(this);"/>
                        <input id="businessGroupOrgId" name="businessGroupOrgId" value="${items.orgId }" type="hidden"/>
                    </div>
                    <div class="form">
                        <label class="Validform_label" name="positionName">对接人职位${idx.index+1}: </label>
                        <input id="positionName" name="positionName" readonly="readonly" value="${items.positionName}"
                               class="inputxt" onClick="choose(this);"/>
                        <input id="positionIds" name="positionIds" value="${items.positionId}" type="hidden"/>
                    </div>
                    <div class="form">
                        <label class="Validform_label" name="fullName">对接人姓名${idx.index+1}: </label>
                        <input id="fullName" name="fullName" readonly="readonly" class="inputxt"
                               value="${items.fullName}"/>
                    </div>
                    <div class="form">
                        <label class="Validform_label" name="mobilephone">对接人电话${idx.index+1}: </label>
                        <input id="mobilephone" name="mobilephone" readonly="readonly" class="inputxt"
                               value="${items.mobilephone}"/>
                    </div>
                    <div class="form">
                        <label class="Validform_label" name="channelName">渠道${idx.index+1}: </label>
                        <textarea rows="4" cols="22" id="channelName" name="channelName" readonly="readonly"
                                  class="inputxt" onClick="chooseChannel(this);">${items.channelName }</textarea>
                        <input id="channelCode" name="channelCode" value="${items.channelCode }" type="hidden"/>
                    </div>
                    <div class="form">
                        <label class="Validform_label" name="productName">产品${idx.index+1}: </label>
                        <textarea rows="4" cols="22" id="productName" name="productName" readonly="readonly"
                                  class="inputxt" onClick="chooseProduct(this);">${items.productName }</textarea>
                        <input id="productCode" name="productCode" value="${items.productCode }" type="hidden"/>
                    </div>
                    <div class="form">
                        <label class="Validform_label" name="businessAreaName">区域${idx.index+1}: </label>
                        <textarea rows="4" cols="22" id="businessAreaName" name="businessAreaName" readonly="readonly"
                                  class="inputxt"
                                  onClick="chooseBusinessArea(this);">${items.businessAreaName }</textarea>
                        <input id="businessAreaCode" name="businessAreaCode" value="${items.businessAreaCode }"
                               type="hidden"/>
                    </div>
                    <div class="form">
                        <label class="Validform_label" name="bgExtChar1s">备注一${idx.index+1}: </label>
                        <input id="bgExtChar1s" value="${items.bgExtChar1}" name="bgExtChar1s" class="inputxt"/>
                    </div>
                    <div class="form">
                        <label class="Validform_label" name="bgExtChar2s">备注二${idx.index+1}: </label>
                        <input id="bgExtChar2s" value="${items.bgExtChar2}" name="bgExtChar2s" class="inputxt"/>
                    </div>
                </div>
            </c:forEach>
            <!-- 读取当前客户经理职位信息 end -->
        </c:when>
        <c:otherwise>
            <!-- 新增默认客户经理职位信息 begin -->
            <div class="formDiv mt10" data-index="${fn:length(custPostList)}">
                <input type="hidden" name="relationIndex" value="${fn:length(custPostList)}"/>
                <div class="form">
                    <label class="Validform_label flex flex-align-items-center flex-justify-content-end" name="orgName">
                        <c:if test="${optype!=2}">
                            <img src='resources/easyui/themes/icons/remove.png' class='formDivRemove'
                                 onclick='removePosition(this)'
                                 style='padding: 4px;cursor: pointer;width: 16px;height: 16px;'/>
                        </c:if>
                        所属部门1:
                    </label>
                    <input id="orgName" name="orgName" readonly="readonly" value="" class="inputxt"
                           onClick="chooseOrg(this);"/>
                    <input id="businessGroupOrgId" name="businessGroupOrgId" value="" type="hidden"/>
                </div>
                <div class="form">
                    <label class="Validform_label" name="positionName">对接人职位1: </label>
                    <input id="positionName" name="positionName" readonly="readonly" value="" class="inputxt"
                           onClick="choose(this);"/>
                    <input id="positionIds" name="positionIds" value="" type="hidden"/>
                </div>
                <div class="form">
                    <label class="Validform_label" name="fullName">对接人姓名1: </label>
                    <input id="fullName" name="fullName" readonly="readonly" class="inputxt" value=""/>
                </div>
                <div class="form">
                    <label class="Validform_label" name="mobilephone">对接人电话1: </label>
                    <input id="mobilephone" name="mobilephone" readonly="readonly" class="inputxt" value=""/>
                </div>
                <div class="form">
                    <label class="Validform_label" name="channelName">渠道1: </label>
                    <textarea rows="4" cols="22" id="channelName" name="channelName" readonly="readonly" value=""
                              class="inputxt" onClick="chooseChannel(this);"></textarea>
                    <input id="channelCode" name="channelCode" value="" type="hidden"/>
                </div>
                <div class="form">
                    <label class="Validform_label" name="productName">产品1: </label>
                    <textarea rows="4" cols="22" id="productName" name="productName" readonly="readonly" value=""
                              class="inputxt" onClick="chooseProduct(this);"></textarea>
                    <input id="productCode" name="productCode" value="" type="hidden"/>
                </div>
                <div class="form">
                    <label class="Validform_label" name="businessAreaName">区域1: </label>
                    <textarea rows="4" cols="22" id="businessAreaName" name="businessAreaName" readonly="readonly"
                              value="" class="inputxt" onClick="chooseBusinessArea(this);"></textarea>
                    <input id="businessAreaCode" name="businessAreaCode" value="" type="hidden"/>
                </div>
                <div class="form">
                    <label class="Validform_label" name="bgExtChar1s">备注一: </label>
                    <input id="bgExtChar1s" value="" name="bgExtChar1s" class="inputxt"/>
                </div>
                <div class="form">
                    <label class="Validform_label" name="bgExtChar2s">备注二: </label>
                    <input id="bgExtChar2s" value="" name="bgExtChar2s" class="inputxt"/>
                </div>
            </div>
            <!-- 新增默认客户经理职位信息 end -->
        </c:otherwise>
    </c:choose>
    <!-- 自定义表单 end-->
</t:formvalid>
</body>
<script type="text/javascript">
    $(document).ready(function () {
        //加载erpcode远程读取数据
        $("#erpCode").on("blur", function () {
            checkErpCode($('#erpCode').val());
        });
        //编辑时默认加载当前省下属市
        var province = $('#cb_province').combobox("getValue");
        if (province != null && province != '') {
            $('#cb_city').combobox('reload', "tmBusinessAreaController.do?getAreaForCombobox&name=" + encodeURI(encodeURI(province)));
        }
        //编辑时默认加载当前市下属区
        var city = $('#cb_city').combobox("getValue");
        if (city != null && city != '') {
            $('#cb_area').combobox('reload', "tmBusinessAreaController.do?getAreaForCombobox&name=" + encodeURI(encodeURI(city)));
        }
        //省onchange事件 加载市下拉列表
        $('#cb_province').combobox({
            onSelect: function (record) {
                $("#province").val(record.value);
                var url = "tmBusinessAreaController.do?getAreaForCombobox&name=" + encodeURI(encodeURI(record.text));
                $("#cb_city").combobox("clear");
                $("#cb_area").combobox("clear");
                $("#cb_city").combobox('reload', url);
                $("#city").val("");
                $("#area").val("");
            }
        });
        //市onchange事件 加载区下拉列表
        $('#cb_city').combobox({
            onSelect: function (record) {
                $("#city").val(record.value);
                var url = "tmBusinessAreaController.do?getAreaForCombobox&name=" + encodeURI(encodeURI(record.text));
                $("#cb_area").combobox("clear");
                $("#cb_area").combobox('reload', url);
                $("#area").val("");
            }
        });
        if ('${optype}' != '2') {
            $("label[name='orgName']").eq($(".formDiv").length - 1).find("img").remove();
            $("label[name='orgName']").eq($(".formDiv").length - 1).prepend("<img src='resources/easyui/themes/icons/add.png' class='formDivAdd' onclick='addPosition()' style='padding: 4px;cursor: pointer;width:16px;height: 16px;' /><img src='resources/easyui/themes/icons/remove.png' class='formDivRemove' onclick='removePosition(this)' style='padding: 4px;cursor: pointer;width:16px;height: 16px;' />");
        }

    });

    //执行远程请求
    function checkErpCode(value) {
        if (value == null || value == "") {
            return;
        }
        $.ajax({
            url: "tmCustomerController.do?getErpCodeInfo",
            type: 'post',
            data: {"erpCode": value},
            cache: false,
            success: function (data) {
                if (data.success) {
                    var obj = data.obj;
                    autoLoadData(obj);
                }
            }
        });
    }

    //选择所属部门
    function chooseOrg(_this) {
        var myIndex = $(_this).closest(".formDiv").attr("data-index");
        var url = "tmOrgController.do?goOrgSelectMain";
        createwindowExt('组织', url, 700, 550, {
            ok: function () {
                iframe = this.iframe.contentWindow;
                var data = iframe.$("#orgList").datagrid("getSelected");
                $("[data-index='" + myIndex + "']").find("input[name='businessGroupOrgId']").val(data.id);
                $("[data-index='" + myIndex + "']").find("input[name='orgName']").val(data.orgName);
            }
        });
    }

    //选择对接人职位
    function choose(_this) {
        var myIndex = $(_this).closest(".formDiv").attr("data-index");
        var targetUrl = 'tmPositionController.do?goTmPositionQuerySelectMain';
        safeShowDialog({
            content: 'url:' + targetUrl,
            title: '职位选择',
            lock: true,
            width: 600,
            height: 450,
            button: [{
                name: '确定',
                callback: function () {
                    //回调事件
                    iframe = this.iframe.contentWindow;
                    var obj = new Object();
                    var positionName = iframe.gettmPositionListSelections('positionName');
                    if (positionName == null || positionName == '') {
                        $.messager.alert('提示', '未选择任何职位信息');
                        return;
                    }
                    var flag = false;
                    $("input[name='positionName']").each(function (i, o) {
                        var pname = $(o).val();
                        if (pname == positionName) {
                            $.messager.alert('提示', '职位' + positionName + '已存在');
                            flag = true;
                        }
                    });
                    if (flag) {
                        return;
                    }
                    obj.positionName = positionName;
                    var fullName = iframe.gettmPositionListSelections('fullName');
                    obj.fullName = fullName;
                    var mobilephone = iframe.gettmPositionListSelections('mobilephone');
                    obj.mobilephone = mobilephone;
                    var id = iframe.gettmPositionListSelections('id');
                    obj.positionIds = id;
                    callback(obj, myIndex);
                },
                focus: true
            }, {
                name: '关闭',
                callback: function () {
                }
            }]
        });
    }

    //回调事件
    function callback(obj, myIndex) {
        $("[data-index='" + myIndex + "']").find("input[name='positionName']").val(obj.positionName);
        $("[data-index='" + myIndex + "']").find("input[name='positionIds']").val(obj.positionIds);
        $("[data-index='" + myIndex + "']").find("input[name='fullName']").val(obj.fullName);
        $("[data-index='" + myIndex + "']").find("input[name='mobilephone']").val(obj.mobilephone);
    }

    var numAll = $('.formDiv').length;

    //html追加
    function addPosition() {
        numAll++;
        $(".formDiv").eq(0).clone().insertAfter($(".formDiv").eq($(".formDiv").length - 1));
        var numCurr = $(".formDiv").length;

        //清空新添加的表单值
        $("label[name='orgName']").eq(numCurr - 1).html("所属部门" + numAll + ":");
        $("input[name='orgName']").eq(numCurr - 1).val("");
        $("input[name='businessGroupOrgId']").eq(numCurr - 1).val("");
        $("label[name='positionName']").eq(numCurr - 1).html("对接人职位" + numAll + ":");
        $("input[name='positionName']").eq(numCurr - 1).val("");
        $("input[name='positionIds']").eq(numCurr - 1).val("");
        $("label[name='fullName']").eq(numCurr - 1).html("对接人姓名" + numAll + ":");
        $("input[name='fullName']").eq(numCurr - 1).val("");
        $("label[name='mobilephone']").eq(numCurr - 1).html("对接人电话" + numAll + ":");
        $("input[name='mobilephone']").eq(numCurr - 1).val("");
        $("label[name='channelName']").eq(numCurr - 1).html("渠道" + numAll + ":");
        $("textarea[name='channelName']").eq(numCurr - 1).val("");
        $("input[name='channelCode']").eq(numCurr - 1).val("");
        $("label[name='productName']").eq(numCurr - 1).html("产品" + numAll + ":");
        $("textarea[name='productName']").eq(numCurr - 1).val("");
        $("input[name='productCode']").eq(numCurr - 1).val("");
        $("label[name='businessAreaName']").eq(numCurr - 1).html("区域" + numAll + ":");
        $("textarea[name='businessAreaName']").eq(numCurr - 1).val("");
        $("input[name='businessAreaCode']").eq(numCurr - 1).val("");
        $("label[name='bgExtChar1s']").eq(numCurr - 1).html("备注一" + numAll + ":");
        $("input[name='bgExtChar1s']").eq(numCurr - 1).val("");
        $("label[name='bgExtChar2s']").eq(numCurr - 1).html("备注二" + numAll + ":");
        $("input[name='bgExtChar2s']").eq(numCurr - 1).val("");

        //序号、图标 处理
        $(".formDiv").eq(numCurr - 1).attr("data-index", numAll - 1);
        $("input[name='relationIndex']").eq(numCurr - 1).val(numAll);
        $("input[name='custPostId']").eq(numCurr - 1).val("");
        // $("label[name='orgName'] .formDivAdd").remove();
        if ('${optype}' != '2') {
            $("label[name='orgName']").eq(numCurr - 1).find("img").remove();
            $("label[name='orgName']").eq(numCurr - 1).prepend("<img src='resources/easyui/themes/icons/add.png' class='formDivAdd' onclick='addPosition()' style='padding: 4px;cursor: pointer;width:16px;height: 16px;' /><img src='resources/easyui/themes/icons/remove.png' class='formDivRemove' onclick='removePosition(this)' style='padding: 4px;cursor: pointer;width:16px;height: 16px;' />");
        }
    }

    //选择客户经理职位弹出框
    function chooseChannel(_this) {
        var myIndex = $(_this).closest(".formDiv").attr("data-index");
        var targetUrl = 'tmDictDataController.do?goDictDataGridByTypeMain&dictTypeCode=channel';
        safeShowDialog({
            content: 'url:' + targetUrl,
            title: '渠道选择',
            lock: true,
            width: 600,
            height: 450,
            button: [{
                name: '确定',
                callback: function () {
                    //回调事件
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#channeldictList').datagrid('getSelections');
                    if ((rowsData == '' || rowsData == null)) {
                        $.messager.alert('提示', "请选择数据");
                        return false;
                    }
                    var dictCodes = "";
                    var dictNames = "";
                    for (var i = 0; i < rowsData.length; i++) {
                        dictCodes += rowsData[i].dictCode + ";";
                        dictNames += rowsData[i].dictValue + ";";
                    }
                    $("[data-index='" + myIndex + "']").find("textarea[name='channelName']").val(dictNames.substring(0, dictNames.length - 1));
                    $("[data-index='" + myIndex + "']").find("input[name='channelCode']").val(dictCodes.substring(0, dictCodes.length - 1));
                },
                focus: true
            }, {
                name: '关闭',
                callback: function () {
                }
            }]
        });
    }

    //选择客户经理职位弹出框
    function chooseProduct(_this) {
        var myIndex = $(_this).closest(".formDiv").attr("data-index");
        var targetUrl = 'tmProductController.do?goTmProductSelectMain';
        safeShowDialog({
            content: 'url:' + targetUrl,
            title: '产品选择',
            lock: true,
            width: 600,
            height: 450,
            button: [{
                name: '确定',
                callback: function () {
                    //回调事件
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#proList').datagrid('getSelections');
                    if ((rowsData == '' || rowsData == null)) {
                        $.messager.alert('提示', "请选择数据");
                        return false;
                    }
                    var productCodes = "";
                    var productNames = "";
                    for (var i = 0; i < rowsData.length; i++) {
                        productCodes += rowsData[i].productCode + ";";
                        productNames += rowsData[i].text + ";";
                    }
                    $("[data-index='" + myIndex + "']").find("textarea[name='productName']").val(productNames.substring(0, productNames.length - 1));
                    $("[data-index='" + myIndex + "']").find("input[name='productCode']").val(productCodes.substring(0, productCodes.length - 1));
                },
                focus: true
            }, {
                name: '关闭',
                callback: function () {
                }
            }]
        });
    }

    //选择客户经理职位弹出框
    function chooseBusinessArea(_this) {
        var myIndex = $(_this).closest(".formDiv").attr("data-index");
        var targetUrl = 'tmBusinessAreaController.do?goTmBusinessAreaSelectMain';
        safeShowDialog({
            content: 'url:' + targetUrl,
            title: '业务区域选择',
            lock: true,
            width: 600,
            height: 450,
            button: [{
                name: '确定',
                callback: function () {
                    //回调事件
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#businessAreaList').datagrid('getSelections');
                    if ((rowsData == '' || rowsData == null)) {
                        $.messager.alert('提示', "请选择数据");
                        return false;
                    }
                    var businessAreaCodes = "";
                    var businessAreaNames = "";
                    for (var i = 0; i < rowsData.length; i++) {
                        businessAreaCodes += rowsData[i].businessAreaCode + ";";
                        businessAreaNames += rowsData[i].text + ";";
                    }
                    $("[data-index='" + myIndex + "']").find("textarea[name='businessAreaName']").val(businessAreaNames.substring(0, businessAreaNames.length - 1));
                    $("[data-index='" + myIndex + "']").find("input[name='businessAreaCode']").val(businessAreaCodes.substring(0, businessAreaCodes.length - 1));
                },
                focus: true
            }, {
                name: '关闭',
                callback: function () {
                }
            }]
        });
    }

    //删除单行数据
    function removePosition(_this) {
        $(_this).closest(".formDiv").remove();
    }
</script>
<c:if test="${not empty includeJSP}">
    <jsp:include page="${includeJSP}" flush="true"></jsp:include>
</c:if>
</html>
