<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,autocomplete"></t:base>
<div id="tmMaintainPositionMain" class="easyui-layout" fit="true">
    <div data-options="region:'west',border:false,split:true" style="width:450px">
        <div class="easyui-layout" fit="true">

            <div data-options="region:'north',border:false,split:true" style="height:300px">
                <t:datagrid name="noAnyActRolePositionList" title="未关联任何角色的职位" fit="true" fitColumns="true"
                            singleSelect="false" actionUrl="tmPositionController.do?findNoAnyActRolePositionList" idField="id" queryMode="group">
                    <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
                    <t:dgCol title="登录账号" field="userName" query="true"></t:dgCol>
                    <t:dgCol title="用户名" field="fullName" query="true"></t:dgCol>
                    <t:dgCol title="职位编码" field="positionCode" query="true"></t:dgCol>
                    <t:dgCol title="职位名称" field="positionName" query="true"></t:dgCol>
                    <t:dgCol title="所属组织" field="orgName" query="true"></t:dgCol>
                    <t:dgCol title="上级职位" field="parentName" query="true"></t:dgCol>
                    <t:dgCol title="上级组织" field="parentOrgName" query="true"></t:dgCol>
                    <t:dgCol title="职位级别" dictionary="position_level" field="positionLevel" query="true"></t:dgCol>
                    <t:dgToolBar title="添加关联"  icon="icon-add" url="tmPositionController.do?addPositionActRoleRelation&roleId=${roleId}" funname="addPositionRoleRelation"></t:dgToolBar>
                </t:datagrid>
            </div>

            <div data-options="region:'center',split:true,border:false">
                <t:datagrid name="noThisActRolePositionList" title="未关联该角色的职位" fit="true" fitColumns="true"
                            singleSelect="false" actionUrl="tmPositionController.do?findNoThisActRolePositionList&roleIds=${roleId}" idField="id" queryMode="group">
                    <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
                    <t:dgCol title="登录账号" field="userName" query="true"></t:dgCol>
                    <t:dgCol title="用户名" field="fullName" query="true"></t:dgCol>
                    <t:dgCol title="职位编码" field="positionCode" query="true"></t:dgCol>
                    <t:dgCol title="职位名称" field="positionName" query="true"></t:dgCol>
                    <t:dgCol title="所属组织" field="orgName" query="true"></t:dgCol>
                    <t:dgCol title="上级职位" field="parentName" query="true"></t:dgCol>
                    <t:dgCol title="上级组织" field="parentOrgName" query="true"></t:dgCol>
                    <t:dgCol title="职位级别" dictionary="position_level" field="positionLevel" query="true"></t:dgCol>
                    <t:dgToolBar title="添加关联"  icon="icon-add" url="tmPositionController.do?addPositionActRoleRelation&roleId=${roleId}" funname="addPositionRoleRelation"></t:dgToolBar>
                </t:datagrid>
            </div>

        </div>
    </div>

    <div data-options="region:'center',split:true,border:false">
        <t:datagrid name="thisActRolePositionList" title="已关联该角色的职位" fit="true" fitColumns="true"
                    singleSelect="false" actionUrl="tmPositionController.do?findThisActRolePositionList&roleIds=${roleId}" idField="id" queryMode="group">
            <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="登录账号" field="userName" query="true"></t:dgCol>
            <t:dgCol title="用户名" field="fullName" query="true"></t:dgCol>
            <t:dgCol title="职位编码" field="positionCode" query="true"></t:dgCol>
            <t:dgCol title="职位名称" field="positionName" query="true"></t:dgCol>
            <t:dgCol title="所属组织" field="orgName" query="true"></t:dgCol>
            <t:dgCol title="上级职位" field="parentName" query="true"></t:dgCol>
            <t:dgCol title="上级组织" field="parentOrgName" query="true"></t:dgCol>
            <t:dgCol title="职位级别" dictionary="position_level" field="positionLevel" query="true"></t:dgCol>
            <t:dgToolBar title="解除关联"  icon="icon-remove" url="tmPositionController.do?deletePositionActRoleRelation" funname="deletePositionRoleRelation"></t:dgToolBar>
            <t:dgToolBar title="替换关联"  icon="icon-edit" url="taActivitiRoleController.do?goNoSelfActRoleMain&selfActRoleId=${roleId}" funname="updatePositionRoleRelation"></t:dgToolBar>
        </t:datagrid>
    </div>

</div>
<script type="text/javascript">
    function addPositionRoleRelation(title, url, gname, width, height, params) {
        var rows = $("#" + gname).datagrid("getSelections");
        if(rows == null || rows == ""){
            tip("请至少选择一条数据");
            return false;
        }

        var ids = [];
        for ( var i = 0; i < rows.length; i++) {
            ids.push(rows[i].id);
        }

        $.ajax({
            url : url,
            type : 'post',
            data : {positionIds : ids.join(',')},
            cache : false,
            success : function(data) {
                var d = data;
                var msg = d.msg;
                if (d.success) {
                    tip(msg,'info');
                    reloadDataGrid();
                }else{
                    tip(msg,'error');
                    return;
                }
            },
            error:function(){
                tip("客户端请求错误",'error');
                return false;
            }
        });
    }

    function deletePositionRoleRelation(title, url, gname, width, height, params) {
        var rows = $("#" + gname).datagrid("getSelections");
        if(rows == null || rows == ""){
            tip("请至少选择一条数据");
            return false;
        }

        var ids = [];
        for ( var i = 0; i < rows.length; i++) {
            ids.push(rows[i].id);
        }

        getSafeJq().dialog.confirm("你确定移除该数据吗?", function(r) {
            if (r) {
                $.ajax({
                    url : url,
                    type : 'post',
                    data : {relationIds : ids.join(',')},
                    cache : false,
                    success : function(data) {
                        var d = data;
                        var msg = d.msg;
                        if (d.success) {
                            tip(msg,'info');
                            reloadDataGrid();
                        }else{
                            tip(msg,'error');
                            return;
                        }
                    },
                    error:function(){
                        tip("客户端请求错误",'error');
                        return false;
                    }
                });
            }
        });
    }

    function updatePositionRoleRelation(title, url, gname, width, height, params) {
        var rows = $("#" + gname).datagrid("getSelections");
        if(rows == null || rows == ""){
            tip("请至少选择一条数据");
            return false;
        }

        var ids = [];
        for ( var i = 0; i < rows.length; i++) {
            ids.push(rows[i].id);
        }

        var relationIds = ids.join(',');

        url += "&relationIds=" + relationIds;

        $.dialog({
            title : title,
            content : "url:" + url,
            lock : true,
            width : "500",
            height : "400",
            zIndex : 10000,
            parent : windowapi,
            ok : function() {
                iframe = this.iframe.contentWindow;
                var relationIds = iframe.$("#relationIds").val();
                var row = iframe.$("#noSelfActRoleList").datagrid("getSelected");

                if(row == null || row == "") {
                    iframe.tip("请选择一条数据");
                    return false;
                }

                var roleId = row.id;

                $.ajax({
                    url : "tmPositionController.do?updatePositionActRoleRelation",
                    type : 'post',
                    data : {relationIds:relationIds,roleId:roleId},
                    cache : false,
                    success : function(data) {
                        var d = data;
                        var msg = d.msg;
                        if (d.success) {
                            $("#thisActRolePositionList").datagrid("reload");
                        }else{
                            tip(msg,'error');
                            return;
                        }
                    },
                    error:function(){
                        tip("客户端请求错误",'error');
                        return false;
                    }
                });
            },
            cancelVal : '关闭',
            cancel : true
        });

    }

    function reloadDataGrid() {
        $("#noAnyActRolePositionList").datagrid("reload");
        $("#noThisActRolePositionList").datagrid("reload");
        $("#thisActRolePositionList").datagrid("reload");
    }
</script>