<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<t:datagrid actionUrl="tmProductInfoController.do?findProductInfoMainGrid" name="productInfoList" queryMode="group">
    <t:dgCol field="id" title="主键" sortable="false" hidden="true"></t:dgCol>
    <t:dgCol field="productInfoCode" title="产品编码" sortable="true" query="true"></t:dgCol>
    <t:dgCol field="productInfoName" title="产品名称" sortable="true"  query="true" ></t:dgCol>
    <t:dgCol field="costPrice" title="成本价" sortable="true"  ></t:dgCol>
    <t:dgCol field="aiCode" title="AI编码" sortable="true"  query="true" ></t:dgCol>
    <t:dgCol field="productInfoType" title="产品类型" sortable="true" dictionary = "product_info_type"></t:dgCol>
    <t:dgCol field="saleCompany" title="销售公司" sortable="true" dictionary = "company_code"></t:dgCol>
    <t:dgCol field="barCode" title="条形码" sortable="true" ></t:dgCol>
    <t:dgCol field="productName" title="产品层级" sortable="true" ></t:dgCol>
    <t:dgCol field="basicUnit" title="基本单位"  sortable="true" dictionary = "basic_unit"></t:dgCol>
    <t:dgCol field="saleUnit" title="销售单位"  sortable="true" dictionary = "sale_unit"></t:dgCol>
    <t:dgCol field="specification" title="规格"  sortable="true" dictionary = "specification" ></t:dgCol>
    <t:dgCol field="shelfStatus" title="上架状态"  sortable="true" dictionary = "shelf_status"></t:dgCol>
    <t:dgCol field="deleteStatus" title="删除标记"  sortable="true" dictionary = "is_no"></t:dgCol>
    <t:dgCol title="操作" field="opt"></t:dgCol>
    <t:dgFunOpt funname="uploadPic(id)" title="产品图片"></t:dgFunOpt>
    <t:dgToolBar title="新增" operationCode="add" url="tmProductInfoController.do?goSaveOrUpdateForm" icon="icon-add" funname="add" width="380" height="400"></t:dgToolBar>
    <t:dgToolBar title="编辑" operationCode="edit" url="tmProductInfoController.do?goSaveOrUpdateForm" icon="icon-edit" funname="update" width="380" height="400"></t:dgToolBar>
    <t:dgToolBar title="查看" operationCode="look" url="tmProductInfoController.do?goSaveOrUpdateForm" icon="icon-edit" funname="detail"></t:dgToolBar>
    <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn" onclick="importDataByXml({impName:'tmProductInfo', gridName:'productInfoList'})" ></t:dgToolBar>
    <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="tmProductInfoController.do?delProductInfo" funname="deleteALLSelect3"></t:dgToolBar>
</t:datagrid>
<script>

    function uploadPic(id){
        createwindow("图片上传",'tmProductInfoController.do?goUploadProductPic&id='+id,440,400,{});
    }

    //删除
    function deleteALLSelect3(title, url){
        var rowsData = $('#productInfoList').datagrid('getSelections');
        var rowData = $('#productInfoList').datagrid('getSelected');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择产品');
            return;
        }
        if (rowsData.length > 1) {
            tip('请选择一条记录再编辑');
            return;
        }
        var ids = [];
        var rows = $('#productInfoList').datagrid('getSelections');
        if(rows.length > 0){
            $.dialog.confirm('是否删除选中数据？',function(r){
                if(r){
                    for(var i = 0; i < rows.length; i++){
                        ids.push(rows[i].id);
                    }
                    $.ajax({
                        url:url,
                        type:'post',
                        data:{
                            ids:ids.join(',')
                        },
                        cache:false,
                        success:function(data){
                            var d = data;
                            var msg = d.msg;
                            if(d.success){
                                tip(msg);
                                for(var i = 0;i<rows.length ;i++){
                                    var index = $('#productInfoList').datagrid('getRowIndex',rows[i]);
                                    $("#productInfoList").datagrid('deleteRow',index);
                                }
                                ids='';
                            }else{
                                tip(msg);
                                return;
                            }
                        }
                    });
                }
            });
        }else{
            tip("请选择要删除的数据！");
        }
    }
</script>