<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="com.biz.eisp.login.utils.LoginParamUtils" %>
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>EISP营销中台</title>
    <link rel="shortcut icon" href="resources/fc/images/icon/favicon.png">
    <style>
        body {
            padding: 0;
            margin: 0;
            width: 100%;
            height: 100%;
            font-family: Helvetica,Tahoma,Arial,"Hiragino Sans GB","Hiragino Sans GB W3","Microsoft YaHei",STXihei,STHeiti,Heiti,SimSun,sans-serif;
        }

        .login-page {
            height: 100vh;
            width: 100%;
            box-sizing: border-box;
            background: #fff;
        }

        .login-header {
            height: 15vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .login-header img {
            width: auto;
            height: 10vh;
        }

        .login-content {
            height: 70vh;
            background: url("resources/easyui/themes/default/images/login-bg.png") no-repeat;
            background-size: 100% 100%;
            position: relative;
        }

        .login-content .login-form {
            position: absolute;
            top: 50%;
            right: 10vw;
            transform: translateY(-50%);
            width: 50vh;
            height: 50vh;
            background: #FFFFFF;
            border-radius: 4px;
            padding: 5vh;
            box-sizing: border-box;
        }

        .login-content .login-form .login-title {
            text-align: center;
            font-family: PingFangSC-Medium;
            font-size: 18px;
            color: #333333;
        }

        .login-content .login-form .login-input {
            width: 100%;
            position: relative;
            margin-top: 5vh;
        }

        .login-content .login-form .login-input input {
            background-color: #ffffff !important;
            outline: none;
            font-size: 16px;
            width: 100%;
            height: 44px;
            line-height: 44px;
            border: 1px solid #D8D8D8;
            border-radius: 4px;
            box-sizing: border-box;
            padding: 5px 5px 5px 30px;
        }

        .login-submit {
            margin-top: 5vh;
        }

        .login-submit .login-btn {
            border: none;
            outline: none;
            width: 100%;
            height: 46px;
            background: #1473D3;
            border-radius: 4px;
            font-size: 16px;
            color: #FFFFFF;
            transition: all .3s;
        }

        .login-submit .login-btn:hover {
            opacity: 0.8;
        }

        .login-footer {
            height: 15vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: flex-end;
        }

        .login-footer .copyright {
            font-family: PingFangSC-Medium;
            font-size: 14px;
            color: #333333;
            margin-bottom: 3vh;
        }

        .label-account {
            width: 20px;
            height: 20px;
            display: inline-block;
            position: absolute;
            left: 5px;
            top: 12px;
            background: url("/resources/easyui/themes/default/images/login_account.png") no-repeat center center;
        }

        .label-password {
            width: 20px;
            height: 20px;
            display: inline-block;
            position: absolute;
            left: 5px;
            top: 13px;
            background: url("/resources/easyui/themes/default/images/login_password.png") no-repeat center center;
        }

        .tip-message {
            position: fixed;
            top: 20px;
            right: -200px;
            padding: 16px 24px;
            overflow: hidden;
            line-height: 1.5;
            background: #fff;
            border-radius: 4px;
            -webkit-box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            transition: all .5s;
        }
        .tip-message.show-message{
            right: 20px;
        }
    </style>
</head>
<body>
<div class="login-page">
    <div class="login-header">
        <img src="resources/easyui/themes/default/images/login-logo.png" alt="">
    </div>
    <div class="login-content">
        <div class="login-form">
            <form action="loginController.do?login" validateUrl="loginController.do?validateUser" name="formLogin"
                  id="formLogin" method="post">
                <div class="login-title">用户登录</div>
                <div class="login-input">
                    <span class="label-account"></span>
                    <input type="text" name="userName" id="userName" placeholder="用户名">
                </div>
                <div class="login-input">
                    <span class="label-password"></span>
                    <input onpaste="return false" name="password" id="password" type="password" placeholder="密码">
                </div>
            </form>
            <div class="login-submit">
                <button class="login-btn" id="but_login">登录</button>
            </div>
        </div>
    </div>
    <div class="login-footer">
        <div class="copyright">2007-2019 © 版权所有:成都博智维讯信息技术股份有限公司[证券码：870739]</div>
    </div>
    <div id="tipMessage" class="tip-message">
        用户名错误
    </div>
</div>

<script type="text/javascript" src="resources/util/constant.js"></script>
<script type="text/javascript" src="resources/jquery/jquery.tools.js"></script>
<script type="text/javascript" src="resources/jquery/jquery.cookie.js"></script>
<script type="text/javascript" src="resources/login/js/login.js"></script>
<script type="text/javascript" src="resources/lhgDialog/lhgdialog.min.js"></script>
<script type="text/javascript" src="resources/md5/aes.js"></script>
<script type="text/javascript" src="resources/md5/mode-ecb-min.js"></script>
<script>
    $(function () {
        $("#password").bind("contextmenu", function (e) {
            return false;
        });
        if (window != top){
            top.location.href =location.href;
        }
    });
    var key = CryptoJS.enc.Utf8.parse("<%=LoginParamUtils.KEY%>");//Latin1 w8m31+Yy/Nw6thPsMpO5fg==
    function Encrypt(word) {
        var srcs = CryptoJS.enc.Utf8.parse(word);
        var encrypted = CryptoJS.AES.encrypt(srcs, key, {mode: CryptoJS.mode.ECB, padding: CryptoJS.pad.Pkcs7});
        return encrypted.toString();
    }
</script>
</body>
</html>