/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.StreamUtils;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taProcessController"})
public class TaProcessController
extends BaseController {
    @Autowired
    private TaProcessService taProcessService;

    @RequestMapping(params={"goTaProcessMain"})
    public ModelAndView goTaProcessMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessMain");
    }

    @RequestMapping(params={"goTaProcessForm"})
    public ModelAndView goTaProcessForm(HttpServletRequest request) {
        String processid = OConvertUtils.getString(request.getParameter("id"), "0");
        request.setAttribute("processid", (Object)processid);
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessForm");
    }

    @RequestMapping(params={"processTabs"})
    public ModelAndView processTabs(String id) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessTabs");
        view.addObject("taProcessId", (Object)id);
        return view;
    }

    @RequestMapping(params={"goTaProcessSelect"})
    public ModelAndView goTaProcessSelect() {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessSelect");
        return view;
    }

    @RequestMapping(params={"goTaProcessPropertiesForm"})
    public ModelAndView goTaProcessPropertiesForm(HttpServletRequest request) {
        String id = OConvertUtils.getString(request.getParameter("id"));
        String checkbox = OConvertUtils.getString(request.getParameter("checkbox"));
        String processId = OConvertUtils.getString(request.getParameter("processId"));
        String processDefinitionId = OConvertUtils.getString(request.getParameter("processDefinitionId"));
        TaProcessEntity taProcessEntity = this.taProcessService.findUniqueByProperty(TaProcessEntity.class, "id", processDefinitionId);
        if (taProcessEntity != null) {
            request.setAttribute("processDefinitionId", (Object)taProcessEntity.getId());
            processId = taProcessEntity.getProcessKey();
            request.setAttribute("listenerClass", (Object)taProcessEntity.getListenerClass());
            request.setAttribute("tableName", (Object)taProcessEntity.getTableName());
            request.setAttribute("redirectUrl", (Object)taProcessEntity.getRedirectUrl());
        }
        request.setAttribute("checkbox", (Object)checkbox);
        request.setAttribute("id", (Object)id);
        request.setAttribute("processId", (Object)processId);
        request.setAttribute("key", (Object)processId);
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessPropertiesForm");
    }

    @RequestMapping(params={"findProcessList"})
    @ResponseBody
    public DataGrid findProcessList(TaProcessVo taProcessVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TaProcessVo> list = this.taProcessService.findTaProcessList(taProcessVo, page);
        return new DataGrid(list, page);
    }

    @RequestMapping(params={"saveTaProcess"})
    @ResponseBody
    public AjaxJson saveTaProcess(TaProcessVo taProcessVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        taProcessVo.setId(request.getParameter("processDefinitionId"));
        taProcessVo.setProcessState(WorkFlowGlobals.PROCESS_DEPLOY_NO);
        this.taProcessService.saveTaProcess(taProcessVo, page);
        return new AjaxJson();
    }

    @RequestMapping(params={"deleteTaProcess"})
    @ResponseBody
    public AjaxJson deleteTaProcess(TaProcessVo taProcessVo, HttpServletRequest request, HttpServletResponse response) {
        this.taProcessService.deleteTaProcess(taProcessVo, this.page);
        return new AjaxJson();
    }

    @RequestMapping(params={"getProcessXml"})
    @ResponseBody
    public void getProcessXml(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/xml;charset=UTF-8");
        String processId = OConvertUtils.getString(request.getParameter("processId"));
        TaProcessEntity tProcess = this.taProcessService.get(TaProcessEntity.class, (Serializable)((Object)processId));
        try {
            String retstr = StreamUtils.InputStreamTOString(StreamUtils.byteTOInputStream(tProcess.getProcessXml()));
            response.getWriter().write(retstr);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

