/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.listener.task;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import java.util.List;
import java.util.Set;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.task.IdentityLink;

public class CurrentAndSubOrgListener
implements TaskListener {
    private TmActRoleService tmActRoleService = (TmActRoleService)ApplicationContextUtils.getContext().getBean("tmActRoleService");

    public void notify(DelegateTask delegateTask) {
        Set identityLinkList = delegateTask.getCandidates();
        for (IdentityLink id : identityLinkList) {
            List<TmPositionVo> voList;
            String actRoleCode = id.getGroupId();
            String orgId = (String)delegateTask.getVariable("submitOrgId");
            if (StringUtil.isEmpty(orgId)) {
                orgId = ResourceUtil.getCurrPosition().getOrgId();
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(voList = this.tmActRoleService.findCurrAndSubOrgPositionList(actRoleCode, orgId))) {
                if (voList.size() == 1) {
                    delegateTask.setAssignee(voList.get(0).getPositionCode());
                    continue;
                }
                for (TmPositionVo vo : voList) {
                    delegateTask.addCandidateUser(vo.getPositionCode());
                }
                continue;
            }
            throw new BusinessException("\u672a\u627e\u5230\u5ba1\u6279\u804c\u4f4d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
    }
}

