/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.entity.TaRejectReadEntity;
import com.biz.eisp.activiti.entity.activiti.ActHiProcinstEntity;
import com.biz.eisp.activiti.entity.activiti.ActReProcdefEntity;
import com.biz.eisp.activiti.entity.activiti.ActRuTaskEntity;
import com.biz.eisp.activiti.runtime.dao.TaTaskDao;
import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.entity.TaCommunicateContentEntity;
import com.biz.eisp.activiti.runtime.entity.TaJumpNodeEntity;
import com.biz.eisp.activiti.runtime.entity.TaKeyIndicatorsConfigEntity;
import com.biz.eisp.activiti.runtime.entity.TaProcessApprovalLogEntity;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.activiti.runtime.service.TaAttachmentService;
import com.biz.eisp.activiti.runtime.service.TaBaseBusinessObjService;
import com.biz.eisp.activiti.runtime.service.TaKeyIndicators;
import com.biz.eisp.activiti.runtime.service.TaRejectRecordService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.transformer.HistoricTaskInstanceToHistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.activiti.runtime.vo.CommentVo;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.OperationVo;
import com.biz.eisp.activiti.runtime.vo.TaAttachmentVo;
import com.biz.eisp.activiti.runtime.vo.TaKeyIndicatorsVo;
import com.biz.eisp.activiti.runtime.vo.TaProcessApprovalLogVo;
import com.biz.eisp.activiti.util.CommentUtil;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.entity.TbAttachmentQueryEntity;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.mdm.actrole.entity.TmActRoleEntity;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmUserPositionEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.UserInfoEntity;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taTaskService")
@Transactional
public class TaTaskServiceImpl
extends BaseServiceImpl
implements TaTaskService {
    @Autowired
    private TaskService taskService;
    @Autowired
    private TmUserService tmUserService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired(required=false)
    private RepositoryService repositoryService;
    @Autowired
    private TaProcessNodeService taProcessNodeService;
    @Autowired
    private TaBaseBusinessObjService taBaseBusinessObjService;
    @Autowired
    private TaTaskDao taTaskDao;
    @Autowired
    private TaRejectRecordService taRejectRecordService;
    @Autowired
    private TaAttachmentService taAttachmentService;
    @Autowired
    private TmActRoleService tmActRoleService;

    @Override
    public List<MyTaskVo> findMyTaskList(MyTaskVo myTaskVo, Page page) {
        List<MyTaskVo> myTaskVoList = this.taTaskDao.findMyTaskList(myTaskVo, page);
        return myTaskVoList;
    }

    @Override
    public String getBusinessObjIdByTask(Task task) {
        String businessKey = "";
        HistoricProcessInstance hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.getProcessInstanceId(task.getId())).singleResult();
        if (hiproins != null) {
            if (hiproins.getSuperProcessInstanceId() != null && hiproins.getBusinessKey() == null) {
                hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(hiproins.getSuperProcessInstanceId()).singleResult();
                businessKey = hiproins.getBusinessKey();
            } else {
                businessKey = hiproins.getBusinessKey();
            }
        }
        return businessKey;
    }

    public String getBusinessObjIdByTaskId(String taskId) {
        String businessKey = "";
        HistoricProcessInstance hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.getProcessInstanceId(taskId)).singleResult();
        if (hiproins != null) {
            if (hiproins.getSuperProcessInstanceId() != null && hiproins.getBusinessKey() == null) {
                hiproins = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(hiproins.getSuperProcessInstanceId()).singleResult();
                businessKey = hiproins.getBusinessKey();
            } else {
                businessKey = hiproins.getBusinessKey();
            }
        }
        return businessKey;
    }

    public ProcessDefinition getProcessDefinition(String processDefinitionId) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
    }

    @Override
    public Task getTask(String taskId) {
        return (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
    }

    public String getBusinessObjIdByTask(String taskId) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        return this.getBusinessObjIdByTask(task);
    }

    public List<String> highLight(String processInstanceId) {
        ArrayList<String> highLihth = new ArrayList<String>();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        for (Execution execution : executions) {
            ExecutionEntity entity = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(execution.getId()).singleResult();
            highLihth.add(entity.getActivityId());
        }
        return highLihth;
    }

    @Override
    public void saveClaim(MyTaskVo myTaskVo) {
        this.taskService.claim(myTaskVo.getTaskId(), ResourceUtil.getSessionUserName().getUserName());
    }

    @Override
    public void saveComplete(MyTaskVo myTaskVo) {
        this.taskService.complete(myTaskVo.getTaskId());
    }

    @Override
    public void saveCompelte(OperationVo operationVo) {
        TaJumpNodeEntity jumpNodeEntity;
        Task task = this.getTask(operationVo.getTaskId());
        if (task == null) {
            throw new BusinessException("\u4efb\u52a1\u5df2\u7ecf\u88ab\u5176\u4ed6\u4eba\u5ba1\u6279!");
        }
        String detailComment = CommentUtil.buildPassComment(task.getName(), ResourceUtil.getCreateName(), operationVo.getComment());
        this.taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
        this.validForceReply(operationVo.getProcessInstanceId());
        TmUserEntity user = ResourceUtil.getClient().getUser();
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(new Date());
        log.setAccount(user.getUserName());
        log.setContent(operationVo.getComment());
        log.setName(user.getFullName());
        log.setProcessInstId(operationVo.getProcessInstanceId());
        try {
            log.setTaskDefKey(this.findTaskById(operationVo.getTaskId()).getTaskDefinitionKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(1);
        this.save(log);
        this.getSession().flush();
        this.taskService.setOwner(operationVo.getTaskId(), ResourceUtil.getCurrPosition().getPositionCode());
        HashMap<String, Object> variable = new HashMap<String, Object>();
        variable.put("approveOpt", WorkFlowGlobals.OPT_PASS);
        if (this.isHuiQianNode(log.getTaskDefKey()) && this.taskService.getVariable(operationVo.getTaskId(), "persons" + log.getTaskDefKey()) == null) {
            this.taskService.setVariable(operationVo.getTaskId(), "persons" + log.getTaskDefKey(), this.taskService.getVariable(operationVo.getTaskId(), "persons"));
        }
        if ((jumpNodeEntity = this.findTaJumpNodeEntity(log.getTaskDefKey(), operationVo.getProcessInstanceId())) != null) {
            this.taskService.setVariable(operationVo.getTaskId(), "backTaskIds", this.taskService.getVariable(operationVo.getTaskId(), "backTaskIds_returnThisNode"));
            this.goProcessTaskNode(operationVo.getTaskId(), jumpNodeEntity.getSrcTaskKey(), variable);
            this.delete(jumpNodeEntity);
        } else {
            this.taskService.complete(operationVo.getTaskId(), variable);
        }
        if (this.isLastTask(operationVo.getProcessInstanceId())) {
            this.taBaseBusinessObjService.updateBaseBusinessObjRuntimeStatusByProcessInstanceId(operationVo.getProcessInstanceId(), WorkFlowGlobals.RUNTIME_STATUS_COMPLETED);
        }
    }

    private void validForceReply(String processInstanceId) {
        String sql = "SELECT cc.* FROM ta_communicate c        LEFT JOIN ta_communicate_content cc ON c.id = cc.ta_communicate_id  WHERE cc.force_reply_flag = 'Y' AND c.process_instance_id = ?";
        List<TaCommunicateContentEntity> entityList = this.findBySql(TaCommunicateContentEntity.class, sql, processInstanceId);
        if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
            String errMsg = entityList.get(0).getCirculationName() + ",\u672a\u7b54\u590d\u6c9f\u901a\u3002";
            throw new BusinessException(errMsg);
        }
    }

    public boolean isHuiQianNode(String taskDefinitionKey) {
        TaProcessNodeEntity nodeEntity = this.taBaseBusinessObjService.findUniqueByProperty(TaProcessNodeEntity.class, "processNodeCode", taskDefinitionKey);
        return nodeEntity.getSign() != null && nodeEntity.getSign() == 1;
    }

    @Override
    public boolean isLastTask(String processInstanceId) {
        List list = this.historyService.createHistoricProcessInstanceQuery().finished().processInstanceId(processInstanceId).list();
        return list != null && list.size() == 1;
    }

    @Override
    public boolean hasRejectNodes(String taskId, String processInstanceId) {
        List backTaskIdlist = (List)this.taskService.getVariable(taskId, "backTaskIds");
        return backTaskIdlist != null && backTaskIdlist.size() != 0;
    }

    private List<Map<String, String>> cloneBackTaskIdlist(List<Map<String, String>> backTaskIdlist) {
        ArrayList<Map<String, String>> cloneBackTaskIdlist = new ArrayList<Map<String, String>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(backTaskIdlist)) {
            for (Map<String, String> map : backTaskIdlist) {
                HashMap newMap = new HashMap();
                BeanUtils.copyProperties(map, newMap);
                cloneBackTaskIdlist.add(newMap);
            }
        }
        return cloneBackTaskIdlist;
    }

    @Override
    public void saveReject(OperationVo operationVo) {
        List backTaskIdlist = (List)this.taskService.getVariable(operationVo.getTaskId(), "backTaskIds");
        Task task = this.getTask(operationVo.getTaskId());
        if (backTaskIdlist == null || backTaskIdlist.size() == 0) {
            throw new BusinessException("\u524d\u9762\u4efb\u52a1\u8282\u70b9\uff0c\u90fd\u6ca1\u6709\u914d\u7f6e\u9a73\u56de\uff0c\u4e0d\u80fd\u8fdb\u884c\u9a73\u56de\u4e0a\u4e00\u7ea7\u64cd\u4f5c");
        }
        String detailComment = CommentUtil.buildRejectPreComment(task.getName(), ResourceUtil.getCreateName(), operationVo.getComment());
        this.taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
        TmUserEntity user = ResourceUtil.getClient().getUser();
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(new Date());
        log.setAccount(user.getUserName());
        log.setContent(operationVo.getComment());
        log.setName(user.getFullName());
        log.setProcessInstId(operationVo.getProcessInstanceId());
        try {
            log.setTaskDefKey(this.findTaskById(operationVo.getTaskId()).getTaskDefinitionKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(2);
        this.save(log);
        if (this.isHuiQianNode(operationVo.getTaskDefKey())) {
            this.taskService.setVariable(operationVo.getTaskId(), "persons", this.taskService.getVariable(operationVo.getTaskId(), "persons" + operationVo.getTaskDefKey()));
        }
        this.taRejectRecordService.saveTaRejectRecord(operationVo.getProcessInstanceId());
        this.taskService.setOwner(operationVo.getTaskId(), ResourceUtil.getCurrPosition().getPositionCode());
        String targetTaskKey = operationVo.getTaskDefKey();
        int count = 0;
        for (int i = 0; i < backTaskIdlist.size(); ++i) {
            Map node = (Map)backTaskIdlist.get(i);
            if (!((String)node.get("id")).equals(targetTaskKey)) continue;
            count = i;
            break;
        }
        ArrayList _backTaskIdlist = new ArrayList();
        for (int index = count; index < backTaskIdlist.size(); ++index) {
            _backTaskIdlist.add(backTaskIdlist.get(index));
        }
        backTaskIdlist.removeAll(_backTaskIdlist);
        if (StringUtils.isNotBlank((CharSequence)targetTaskKey) && StringUtil.isNotBlank((String)operationVo.getReturnThisNode()) && "Y".equals(operationVo.getReturnThisNode())) {
            this.taskService.setVariable(operationVo.getTaskId(), "backTaskIds_returnThisNode", this.taskService.getVariable(operationVo.getTaskId(), "backTaskIds"));
            this.saveTaJumpNodeEntity(log.getTaskDefKey(), targetTaskKey, operationVo.getProcessInstanceId());
        }
        this.taskService.setVariable(operationVo.getTaskId(), "backTaskIds", (Object)backTaskIdlist);
        HashMap<String, Object> variable = new HashMap<String, Object>();
        variable.put("approveOpt", WorkFlowGlobals.OPT_REJECT_PRE);
        this.goProcessTaskNode(operationVo.getTaskId(), targetTaskKey, variable);
    }

    private void saveTaJumpNodeEntity(String srcTaskKey, String targetTaskKey, String processInstanceId) {
        TaJumpNodeEntity entity = new TaJumpNodeEntity();
        entity.setProcessInstanceId(processInstanceId);
        entity.setSrcTaskKey(srcTaskKey);
        entity.setTargetTaskKey(targetTaskKey);
        this.save(entity);
    }

    private TaJumpNodeEntity findTaJumpNodeEntity(String targetTaskKey, String processInstanceId) {
        String hql = "from TaJumpNodeEntity e where e.targetTaskKey = ? AND e.processInstanceId = ?";
        List list = this.findByHql(hql, targetTaskKey, processInstanceId);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            return (TaJumpNodeEntity)list.get(0);
        }
        return null;
    }

    @Override
    public void saveRejectToApply(OperationVo operationVo) {
        Task task = this.getTask(operationVo.getTaskId());
        String detailComment = CommentUtil.buildRejectApplyComment(task.getName(), ResourceUtil.getCreateName(), operationVo.getComment());
        this.taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
        TmUserEntity user = ResourceUtil.getClient().getUser();
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(new Date());
        log.setAccount(user.getUserName());
        log.setContent(operationVo.getComment());
        log.setName(user.getFullName());
        log.setProcessInstId(operationVo.getProcessInstanceId());
        try {
            log.setTaskDefKey(this.findTaskById(operationVo.getTaskId()).getTaskDefinitionKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(2);
        this.save(log);
        this.taskService.setOwner(operationVo.getTaskId(), ResourceUtil.getCurrPosition().getPositionCode());
        this.taRejectRecordService.saveTaRejectRecord(operationVo.getProcessInstanceId());
        String USER_SELECT_TASK_NODE = "end";
        HashMap<String, Object> variable = new HashMap<String, Object>();
        variable.put("aborts", "abort_");
        this.goProcessTaskNode(operationVo.getTaskId(), USER_SELECT_TASK_NODE, variable);
        this.taBaseBusinessObjService.updateBaseBusinessObjRuntimeStatusByProcessInstanceId(operationVo.getProcessInstanceId(), WorkFlowGlobals.RUNTIME_STATUS_REJECT);
    }

    @Override
    public void saveRejectToApply(OperationVo operationVo, String positionId) {
        Task task = this.getTask(operationVo.getTaskId());
        UserInfoEntity userInfoEntity = this.tmUserService.findUserInfoEntityByPosId(positionId);
        String createName = StringUtil.isNotEmpty(userInfoEntity) ? userInfoEntity.getRealName() + "(" + userInfoEntity.getPosName() + ")" : "";
        String detailComment = CommentUtil.buildRejectApplyComment(task.getName(), createName, operationVo.getComment());
        this.taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(new Date());
        log.setAccount(userInfoEntity.getUserName());
        log.setContent(operationVo.getComment());
        log.setName(userInfoEntity.getRealName());
        log.setProcessInstId(operationVo.getProcessInstanceId());
        try {
            log.setTaskDefKey(this.findTaskById(operationVo.getTaskId()).getTaskDefinitionKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(2);
        this.save(log);
        this.taskService.setOwner(operationVo.getTaskId(), userInfoEntity.getPosCode());
        this.taRejectRecordService.saveTaRejectRecord(operationVo.getProcessInstanceId(), positionId);
        String USER_SELECT_TASK_NODE = "end";
        HashMap<String, Object> variable = new HashMap<String, Object>();
        variable.put("aborts", "abort_");
        this.goProcessTaskNode(operationVo.getTaskId(), USER_SELECT_TASK_NODE, variable);
        this.taBaseBusinessObjService.updateBaseBusinessObjRuntimeStatusByProcessInstanceId(operationVo.getProcessInstanceId(), WorkFlowGlobals.RUNTIME_STATUS_REJECT);
    }

    @Override
    public void saveRead(OperationVo operationVo) {
        TaRejectReadEntity entity = new TaRejectReadEntity();
        entity.setProcessInstanceId(operationVo.getProcessInstanceId());
        this.save(entity);
    }

    @Override
    public List<HistoryTaskVo> findMyHistoryTaskList(HistoryTaskVo historyTaskVo, Page page) {
        List<HistoryTaskVo> historyTaskVoList = this.taTaskDao.findMyHistoryTaskList(historyTaskVo, page);
        this.calSpendTimes(historyTaskVoList);
        return historyTaskVoList;
    }

    private void calSpendTimes(List<HistoryTaskVo> historyTaskVoList) {
        if (historyTaskVoList != null) {
            for (HistoryTaskVo vo : historyTaskVoList) {
                vo.setSpendTimes(DateUtils.calSpendTimes(vo.getStartTime(), vo.getEndTime()));
            }
        }
    }

    @Override
    public String getProcessInstanceId(String taskId) {
        Task task = this.getTask(taskId);
        if (task == null) {
            List hiTaskList = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).list();
            if (hiTaskList != null && hiTaskList.size() > 0) {
                return ((HistoricTaskInstance)hiTaskList.get(0)).getProcessInstanceId();
            }
            throw new BusinessException("\u4efb\u52a1ID\uff08taskId\uff09:" + taskId + "\u4e0d\u5b58\u5728");
        }
        return task.getProcessInstanceId();
    }

    @Override
    public List<HistoryTaskVo> findProcessInstanceTaskHistoryList(HistoryTaskVo historyTaskVo, Page page) {
        String processInstanceId = historyTaskVo.getProcessInstanceId();
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            throw new BusinessException("\u6d41\u7a0b\u5b9e\u4f8bID\uff08processInstanceId\uff09\u4e3a\u7a7a");
        }
        List historicTaskInstanceList = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId).list();
        List voList = Lists.transform((List)historicTaskInstanceList, (Function)new HistoricTaskInstanceToHistoryTaskVo());
        return voList;
    }

    @Override
    public String getTaskBusinessForm(String taskId) {
        BusinessFormVo vo = this.taTaskDao.getBusinessForm(taskId);
        if (vo.getModelandview() == null) {
            return null;
        }
        return vo.getModelandview() + "&businessObjId=" + vo.getBusinessObjId();
    }

    @Override
    public String getProcessInstanceBusinessForm(String processInstanceId) {
        BusinessFormVo vo = this.taTaskDao.getBusinessFormByProcessInstanceId(processInstanceId);
        if (vo.getModelandview() == null) {
            return null;
        }
        return vo.getModelandview() + "&businessObjId=" + vo.getBusinessObjId();
    }

    @Override
    public List<CommentVo> findActHiCommentEntity(String processInstanceId) {
        List<CommentVo> voList = this.taTaskDao.findProcessInstanceCommentList(processInstanceId, null);
        for (CommentVo vo : voList) {
            List<TaAttachmentVo> list = this.taAttachmentService.findAttachmentList(vo.getTaskId());
            vo.setFullMsg(this.getFullMsg(vo.getBlobMsg()));
            vo.setAttachmentList(list);
        }
        return voList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFullMsg(Blob blob) {
        String result = "";
        InputStream in = null;
        BufferedReader br = null;
        try {
            in = blob.getBinaryStream();
            br = new BufferedReader(new InputStreamReader(in));
            String str = "";
            while ((str = br.readLine()) != null) {
                result = result + str;
            }
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
                in.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public List<CommentVo> findActHiCommentByBusinessKey(String businessKey) {
        List<CommentVo> result = this.taTaskDao.findProcessInstanceCommentByBusinessKey(businessKey);
        for (CommentVo vo : result) {
            List<TaAttachmentVo> list = this.taAttachmentService.findAttachmentList(vo.getTaskId());
            vo.setAttachmentList(list);
        }
        return result;
    }

    @Override
    public List<TaAttachmentEntity> findAttachmentList(String taskId) {
        List<TaAttachmentEntity> list = this.findByProperty(TaAttachmentEntity.class, "taskId", taskId);
        return list;
    }

    @Override
    public void reassign(MyTaskVo myTaskVo, String reassignComment, String reassignPositionCode) {
        String taskId = myTaskVo.getTaskId();
        Task task = this.getTask(taskId);
        TmPositionVo positionVo = ResourceUtil.getCurrPosition();
        this.taskService.addComment(taskId, task.getProcessInstanceId(), CommentUtil.buildReassignComment(task.getName(), ResourceUtil.getCreateName(), reassignComment));
        this.taskService.setVariableLocal(taskId, "approveOpt", (Object)"reassign");
        this.taskService.setOwner(taskId, positionVo.getPositionCode());
        this.taskService.setAssignee(taskId, reassignPositionCode);
    }

    @Override
    public void complete(String taskId, Map<String, Object> map) {
        try {
            String businessObjId = this.getBusinessObjIdByTask(taskId);
            String USER_SELECT_TASK_NODE = OConvertUtils.getString(map.get(WorkFlowGlobals.USER_SELECT_TASK_NODE));
            this.goProcessTaskNode(taskId, USER_SELECT_TASK_NODE, map);
            List list = this.historyService.createHistoricProcessInstanceQuery().finished().processInstanceBusinessKey(businessObjId).list();
            if (list != null && list.size() == 1) {
                TaRuntimeStatusEntity r = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "completed");
                TaBaseBusinessObjEntity obj = this.get(TaBaseBusinessObjEntity.class, (Serializable)((Object)businessObjId));
                obj.setTaRuntimeStatusEntity(r);
                this.updateEntity(obj);
            }
        }
        catch (ActivitiException e) {
            if (e.getMessage().indexOf("no processes deployed with key") != -1) {
                e.printStackTrace();
            } else {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void goProcessTaskNode(String taskId, String activityId, Map<String, Object> variables) {
        try {
            List<Task> taskList = this.findTaskListByKey(this.findProcessInstanceByTaskId(taskId).getId(), this.findTaskById(taskId).getTaskDefinitionKey());
            for (Task task : taskList) {
                this.commitProcess(task.getId(), variables, activityId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void commitProcess(String taskId, Map<String, Object> variables, String taskDefinitionKey) throws Exception {
        if (OConvertUtils.isEmpty(taskDefinitionKey)) {
            this.taskService.complete(taskId, variables);
        } else {
            this.turnTransition(taskId, taskDefinitionKey, variables);
        }
    }

    private void turnTransition(String taskId, String taskDefinitionKey, Map<String, Object> variables) throws Exception {
        ActivityImpl currActivity = this.findActivitiImpl(taskId, null);
        List<PvmTransition> oriPvmTransitionList = this.clearTransition(currActivity);
        TransitionImpl newTransition = currActivity.createOutgoingTransition();
        ActivityImpl pointActivity = this.findActivitiImpl(taskId, taskDefinitionKey);
        newTransition.setDestination(pointActivity);
        this.taskService.complete(taskId, variables);
        pointActivity.getIncomingTransitions().remove(newTransition);
        this.restoreTransition(currActivity, oriPvmTransitionList);
    }

    private List<PvmTransition> clearTransition(ActivityImpl activityImpl) {
        ArrayList<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        for (PvmTransition pvmTransition : pvmTransitionList) {
            oriPvmTransitionList.add(pvmTransition);
        }
        pvmTransitionList.clear();
        return oriPvmTransitionList;
    }

    private void restoreTransition(ActivityImpl activityImpl, List<PvmTransition> oriPvmTransitionList) {
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        pvmTransitionList.clear();
        for (PvmTransition pvmTransition : oriPvmTransitionList) {
            pvmTransitionList.add(pvmTransition);
        }
    }

    public ProcessDefinitionEntity findProcessDefinitionEntityByTaskId(String taskId) throws Exception {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(this.findTaskById(taskId).getProcessDefinitionId());
        if (processDefinition == null) {
            throw new Exception("\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230!");
        }
        return processDefinition;
    }

    private ActivityImpl findActivitiImpl(String taskId, String activityId) throws Exception {
        ProcessDefinitionEntity processDefinition = this.findProcessDefinitionEntityByTaskId(taskId);
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            activityId = this.findTaskById(taskId).getTaskDefinitionKey();
        }
        if (activityId.toUpperCase().equals("END")) {
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (!pvmTransitionList.isEmpty()) continue;
                return activityImpl;
            }
        }
        ActivityImpl activityImpl = processDefinition.findActivity(activityId);
        return activityImpl;
    }

    private List<Task> findTaskListByKey(String processInstanceId, String key) {
        return this.taskService.createTaskQuery().processInstanceId(processInstanceId).taskDefinitionKey(key).list();
    }

    public ProcessInstance findProcessInstanceByTaskId(String taskId) throws Exception {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(this.findTaskById(taskId).getProcessInstanceId()).singleResult();
        if (processInstance == null) {
            throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u672a\u627e\u5230!");
        }
        return processInstance;
    }

    private TaskEntity findTaskById(String taskId) throws Exception {
        TaskEntity task = (TaskEntity)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        if (task == null) {
            throw new Exception("\u4efb\u52a1\u5b9e\u4f8b\u672a\u627e\u5230!");
        }
        return task;
    }

    @Override
    public List<MyTaskVo> findMyRejectTaskList(MyTaskVo myTaskVo, Page page) {
        List<MyTaskVo> voList = this.taTaskDao.findMyRejectTaskList(myTaskVo, page);
        return voList;
    }

    @Override
    public void findProcessBasicInfoByProcinstId(MyTaskVo myTaskVo, HttpServletRequest request) {
        MyTaskVo processVo = this.taTaskDao.findProcessBasicInfoByProcinstId(myTaskVo.getProcessInstanceId());
        request.setAttribute("processVo", (Object)processVo);
    }

    @Override
    public void findAttachmentListByProcinstId(String processInstanceId, HttpServletRequest request) {
        ActHiProcinstEntity actHiProcinstEntity = this.findUniqueByProperty(ActHiProcinstEntity.class, "procInstId", processInstanceId);
        List<TbAttachmentQueryEntity> entity = this.findByProperty(TbAttachmentQueryEntity.class, "businessKey", actHiProcinstEntity.getBusinessKey());
        request.setAttribute("attachment", entity);
    }

    @Override
    public void findKeyIndicators(MyTaskVo myTaskVo, HttpServletRequest request) {
        ActHiProcinstEntity actHiProcinstEntity = this.findUniqueByProperty(ActHiProcinstEntity.class, "procInstId", myTaskVo.getProcessInstanceId());
        ActReProcdefEntity actReProcdefEntity = this.get(ActReProcdefEntity.class, (Serializable)((Object)actHiProcinstEntity.getProcDefId()));
        String processKey = actReProcdefEntity.getKey();
        String businessKey = actHiProcinstEntity.getBusinessKey();
        TaKeyIndicatorsConfigEntity tki = this.findUniqueByProperty(TaKeyIndicatorsConfigEntity.class, "processKey", processKey);
        if (tki == null) {
            request.setAttribute("noKey", (Object)true);
        } else {
            String[] title;
            request.setAttribute("noKey", (Object)false);
            ArrayList<String> head = new ArrayList<String>();
            for (String t : title = tki.getTitle().split(",")) {
                head.add(t);
            }
            request.setAttribute("head", head);
            TaKeyIndicators service = (TaKeyIndicators)ApplicationContextUtils.getContext().getBean(tki.getServiceName());
            List<Map<String, Object>> data = service.findKeyIndicators(businessKey);
            ArrayList returnList = new ArrayList();
            String[] field = tki.getField().split(",");
            for (Map<String, Object> map : data) {
                ArrayList<TaKeyIndicatorsVo> middleList = new ArrayList<TaKeyIndicatorsVo>();
                for (String key : field) {
                    TaKeyIndicatorsVo value = new TaKeyIndicatorsVo();
                    value.setValue(String.valueOf(map.get(key)));
                    middleList.add(value);
                }
                returnList.add(middleList);
            }
            request.setAttribute("returnList", returnList);
        }
    }

    @Override
    public void findRejectNode(String taskId, String processInstanceId, HttpServletRequest request) {
        List backTaskIdlist = (List)this.taskService.getVariable(taskId, "backTaskIds");
        request.setAttribute("processNode", (Object)backTaskIdlist);
    }

    @Override
    public void findApprovalLogs(MyTaskVo myTaskVo, HttpServletRequest request) {
        String sql;
        List<ActRuTaskEntity> result;
        List<TaProcessApprovalLogVo> yes = this.taTaskDao.findLog(myTaskVo.getProcessInstanceId());
        TaProcessApprovalLogVo sign = yes.get(yes.size() - 1);
        if (StringUtil.isNotEmpty((String)sign.getTaskDefKey()) && CollectionUtil.listNotEmptyNotSizeZero(result = this.findBySql(ActRuTaskEntity.class, sql = " select assignee_ assignee from act_ru_task task where task.proc_inst_id_ = ? and task_def_key_ = ?", myTaskVo.getProcessInstanceId(), sign.getTaskDefKey()))) {
            for (ActRuTaskEntity _rt : result) {
                TaProcessApprovalLogVo vo = new TaProcessApprovalLogVo();
                TmPositionEntity position = this.findUniqueByProperty(TmPositionEntity.class, "positionCode", _rt.getAssignee());
                vo.setRoleName(position.getPositionName());
                List<TmUserPositionEntity> up = this.findByProperty(TmUserPositionEntity.class, "tmPosition.id", position.getId());
                if (CollectionUtil.listNotEmptyNotSizeZero(up)) {
                    TmUserEntity user = up.get(0).getTmUser();
                    try {
                        vo.setAccount(user.getUserName());
                        vo.setName(user.getFullName());
                    }
                    catch (Exception e) {
                        vo.setAccount("<span style=\"color:red;\">\u672a\u627e\u5230\u7528\u6237\u8d26\u53f7</span>");
                        vo.setName("<span style=\"color:red;\">\u672a\u627e\u5230\u7528\u6237\u59d3\u540d</span>");
                    }
                } else {
                    vo.setAccount("<span style=\"color:red;\">\u672a\u627e\u5230\u7528\u6237\u8d26\u53f7</span>");
                    vo.setName("<span style=\"color:red;\">\u672a\u627e\u5230\u7528\u6237\u59d3\u540d</span>");
                }
                vo.setType("\u4f1a\u7b7e");
                yes.add(vo);
            }
        }
        String nodeStr = this.handleNode(myTaskVo.getProcessInstanceId(), sign.getTaskDefKey());
        List<TaProcessNodeEntity> no = this.taTaskDao.findLogForNoApproval(myTaskVo.getProcessInstanceId(), nodeStr);
        int count = 0;
        for (TaProcessNodeEntity assemble : no) {
            if (assemble.getSign() != null && assemble.getSign() == 1) {
                TaProcessApprovalLogVo vo;
                List persons = (List)this.runtimeService.getVariable(myTaskVo.getProcessInstanceId(), "persons");
                if (persons == null || CollectionUtil.listEmpty(persons)) {
                    vo = new TaProcessApprovalLogVo();
                    vo.setRoleName("\u672a\u627e\u5230\u4f1a\u7b7e\u4eba\u5458");
                    vo.setType("\u4f1a\u7b7e");
                    yes.add(vo);
                } else if (count == 0) {
                    for (String person : persons) {
                        TaProcessApprovalLogVo vo2 = new TaProcessApprovalLogVo();
                        TmPositionEntity position = this.findUniqueByProperty(TmPositionEntity.class, "positionCode", person);
                        vo2.setRoleName(position.getPositionName());
                        List<TmUserPositionEntity> up = this.findByProperty(TmUserPositionEntity.class, "tmPosition.id", position.getId());
                        if (CollectionUtil.listNotEmptyNotSizeZero(up)) {
                            TmUserEntity user = up.get(0).getTmUser();
                            try {
                                vo2.setAccount(user.getUserName());
                                vo2.setName(user.getFullName());
                            }
                            catch (Exception e) {
                                vo2.setAccount("<span style=\"color:red;\">\u672a\u627e\u5230\u7528\u6237\u8d26\u53f7</span>");
                                vo2.setName("<span style=\"color:red;\">\u672a\u627e\u5230\u7528\u6237\u59d3\u540d</span>");
                            }
                        } else {
                            vo2.setAccount("<span style=\"color:red;\">\u672a\u627e\u5230\u7528\u6237\u8d26\u53f7</span>");
                            vo2.setName("<span style=\"color:red;\">\u672a\u627e\u5230\u7528\u6237\u59d3\u540d</span>");
                        }
                        vo2.setType("\u4f1a\u7b7e");
                        yes.add(vo2);
                    }
                } else {
                    vo = new TaProcessApprovalLogVo();
                    TmPositionEntity position = this.findUniqueByProperty(TmPositionEntity.class, "positionCode", persons.get(0));
                    vo.setRoleName(position.getPositionName());
                    vo.setType("\u5f85\u5ba1\u6279");
                    yes.add(vo);
                }
            } else {
                TaProcessApprovalLogVo vo = new TaProcessApprovalLogVo();
                if (assemble.getRoleCode() != null) {
                    TmActRoleEntity role = this.findUniqueByProperty(TmActRoleEntity.class, "roleCode", assemble.getRoleCode());
                    vo.setRoleName(role.getRoleName());
                    if (count == 0) {
                        String submitPositionId;
                        HistoricVariableInstance vInst1;
                        List<Object> voList = new ArrayList();
                        HistoricVariableInstance vInst = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("submitOrgId").processInstanceId(myTaskVo.getProcessInstanceId()).singleResult();
                        String orgId = null;
                        if (vInst != null) {
                            orgId = (String)vInst.getValue();
                        }
                        if (StringUtil.isEmpty(orgId)) {
                            orgId = ResourceUtil.getCurrPosition().getOrgId();
                        }
                        if (assemble.getFilter() == 1) {
                            voList = this.tmActRoleService.findCurrOrgPositionList(assemble.getRoleCode(), orgId);
                        } else if (assemble.getFilter() == 0) {
                            voList = this.tmActRoleService.findCurrAndSubOrgPositionList(assemble.getRoleCode(), orgId);
                        } else if (assemble.getFilter() == 2) {
                            TmOrgEntity org = this.tmActRoleService.get(TmOrgEntity.class, (Serializable)((Object)orgId));
                            voList = this.tmActRoleService.findResponsibleArea(assemble.getRoleCode(), org.getOrgCode());
                        } else if (assemble.getFilter() == 3) {
                            vInst1 = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("submitPositionId").processInstanceId(myTaskVo.getProcessInstanceId()).singleResult();
                            submitPositionId = null;
                            if (StringUtil.isNotEmpty(vInst1)) {
                                submitPositionId = (String)vInst1.getValue();
                                TmPositionEntity tp = this.get(TmPositionEntity.class, (Serializable)((Object)submitPositionId));
                                String parent = tp.getTmPosition().getId();
                                voList = this.tmActRoleService.findParentPositionList(assemble.getRoleCode(), parent);
                            }
                        } else if (assemble.getFilter() == 4) {
                            vInst1 = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("submitPositionId").processInstanceId(myTaskVo.getProcessInstanceId()).singleResult();
                            submitPositionId = null;
                            if (StringUtil.isNotEmpty(vInst1)) {
                                submitPositionId = (String)vInst1.getValue();
                            }
                            voList = this.tmActRoleService.findParentsPositionList(assemble.getRoleCode(), submitPositionId);
                        } else if (assemble.getFilter() == 5) {
                            vInst1 = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("inOrgCode").processInstanceId(myTaskVo.getProcessInstanceId()).singleResult();
                            String inOrgCode = null;
                            if (StringUtil.isNotEmpty(vInst1)) {
                                inOrgCode = (String)vInst1.getValue();
                            }
                            TmOrgEntity orgEntity = this.tmActRoleService.findUniqueByProperty(TmOrgEntity.class, "orgCode", inOrgCode);
                            voList = this.tmActRoleService.findCurrAndSubOrgPositionList(assemble.getRoleCode(), orgEntity.getId());
                        } else if (assemble.getFilter() == 6) {
                            vInst1 = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("outOrgCode").processInstanceId(myTaskVo.getProcessInstanceId()).singleResult();
                            String outOrgCode = null;
                            if (StringUtil.isNotEmpty(vInst1)) {
                                outOrgCode = (String)vInst1.getValue();
                            }
                            TmOrgEntity orgEntity = this.tmActRoleService.findUniqueByProperty(TmOrgEntity.class, "orgCode", outOrgCode);
                            voList = this.tmActRoleService.findCurrAndSubOrgPositionList(assemble.getRoleCode(), orgEntity.getId());
                        } else if (assemble.getFilter() == 7) {
                            voList = this.tmActRoleService.findPositionList(assemble.getRoleCode());
                        } else if (assemble.getFilter() == 8) {
                            voList = new ArrayList();
                        }
                        if (voList.size() > 0) {
                            StringBuffer account = new StringBuffer();
                            StringBuffer name = new StringBuffer();
                            for (int i = 0; i < voList.size(); ++i) {
                                String hql = " from TmUserPositionEntity b where  b.tmPosition.id = ?";
                                TmPositionVo rPosition = (TmPositionVo)voList.get(i);
                                List userList = this.findByHql(hql, rPosition.getId());
                                if (!CollectionUtil.listNotEmptyNotSizeZero(userList)) continue;
                                TmUserEntity user = ((TmUserPositionEntity)userList.get(0)).getTmUser();
                                if (i == voList.size() - 1) {
                                    account.append(user.getUserName());
                                    name.append(user.getFullName());
                                    continue;
                                }
                                account.append(user.getUserName() + " ");
                                name.append(user.getFullName() + " ");
                            }
                            vo.setAccount(account.toString());
                            vo.setName(name.toString());
                        }
                    }
                } else {
                    TmPositionEntity position = this.findUniqueByProperty(TmPositionEntity.class, "positionCode", assemble.getPositionCode());
                    vo.setRoleName(position.getPositionName());
                    if (count == 0) {
                        List<TmUserPositionEntity> up = this.findByProperty(TmUserPositionEntity.class, "tmPosition.id", position.getId());
                        if (CollectionUtil.listNotEmptyNotSizeZero(up)) {
                            TmUserEntity user = up.get(0).getTmUser();
                            try {
                                vo.setAccount(user.getUserName());
                                vo.setName(user.getFullName());
                            }
                            catch (Exception e) {
                                vo.setAccount("<span style=\"color:red;\">\u672a\u627e\u5230\u7528\u6237\u8d26\u53f7</span>");
                                vo.setName("<span style=\"color:red;\">\u672a\u627e\u5230\u7528\u6237\u59d3\u540d</span>");
                            }
                        } else {
                            vo.setAccount("<span style=\"color:red;\">\u672a\u627e\u5230\u7528\u6237\u8d26\u53f7</span>");
                            vo.setName("<span style=\"color:red;\">\u672a\u627e\u5230\u7528\u6237\u59d3\u540d</span>");
                        }
                    }
                }
                vo.setType("\u5f85\u5ba1\u6279");
                yes.add(vo);
            }
            ++count;
        }
        request.setAttribute("log", yes);
    }

    @Override
    public BusinessFormVo getBusinessFormByProcessInstanceId(String processInstanceId) {
        return this.taTaskDao.getBusinessFormByProcessInstanceId(processInstanceId);
    }

    private String handleNode(String processInstanceId, String taskKey) {
        String sql = "select task_def_key_  task_def_key from  act_ru_task where proc_inst_id_ = ?";
        List<ActRuTaskEntity> tasks = this.findBySql(ActRuTaskEntity.class, sql, processInstanceId);
        if (CollectionUtil.listEmpty(tasks)) {
            return "''";
        }
        String allNode = " select node.* from ta_process_node node                                     join ta_process p on p.id = node.process_id                                 join ta_process_busiobj_config conf on conf.process_id = p.id               join ta_base_business_obj obj on obj.process_busiobj_config_id = conf.id    join act_hi_procinst inst on inst.business_key_ = obj.id                    where inst.proc_inst_id_ = :processInstanceId order by sort asc            ";
        List<TaProcessNodeEntity> nodes = this.findBySql(TaProcessNodeEntity.class, allNode, processInstanceId);
        int count = 0;
        String nowTaskKey = tasks.get(0).getTaskDefKey();
        for (int i = 0; i < nodes.size(); ++i) {
            if (!nowTaskKey.equals(nodes.get(i).getProcessNodeCode())) continue;
            String signSql = " select assignee_ assignee from act_ru_task task where task.proc_inst_id_ = ? and task_def_key_ = ?";
            List<ActRuTaskEntity> result = this.findBySql(ActRuTaskEntity.class, signSql, processInstanceId, taskKey);
            if (CollectionUtil.listNotEmptyNotSizeZero(result)) {
                count = i + 1;
                break;
            }
            count = i;
            break;
        }
        StringBuffer sb = new StringBuffer();
        for (int n = count; n < nodes.size(); ++n) {
            sb.append("'" + nodes.get(n).getProcessNodeCode() + "',");
        }
        if (sb.length() == 0) {
            return "''";
        }
        return sb.substring(0, sb.length() - 1).toString();
    }
}

