/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.transformer;

import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Date;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.time.DateFormatUtils;

public class TaskToMyTaskVo
implements Function<Task, MyTaskVo> {
    private RepositoryService repositoryService;
    private TaTaskService taTaskService;

    public TaskToMyTaskVo(RepositoryService repositoryService, TaTaskService taTaskService, HistoryService historyService) {
        this.repositoryService = repositoryService;
        this.taTaskService = taTaskService;
    }

    public MyTaskVo apply(Task task) {
        if (task == null) {
            return null;
        }
        MyTaskVo myTaskVo = new MyTaskVo();
        myTaskVo.setAssignee(task.getAssignee());
        myTaskVo.setPreNodetime(DateFormatUtils.format((Date)task.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (task.getDueDate() != null) {
            myTaskVo.setDueDate(DateFormatUtils.format((Date)task.getDueDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        myTaskVo.setProcessDefinitionId(task.getProcessDefinitionId());
        myTaskVo.setProcessInstanceId(task.getProcessInstanceId());
        myTaskVo.setTaskDefinitionKey(task.getTaskDefinitionKey());
        myTaskVo.setTaskId(task.getId());
        myTaskVo.setTaskName(task.getName());
        myTaskVo.setId(task.getId());
        ProcessDefinition processDefinition = this.getProcessDefinition(task.getProcessDefinitionId());
        myTaskVo.setProcessDefinitionName(processDefinition.getName());
        myTaskVo.setProcessDefinitionKey(processDefinition.getKey());
        String businessObjId = this.taTaskService.getBusinessObjIdByTask(task);
        TaBaseBusinessObjEntity baseBusinessObjEntity = this.taTaskService.get(TaBaseBusinessObjEntity.class, (Serializable)((Object)businessObjId));
        TmPositionEntity tmPositionEntity = baseBusinessObjEntity.getTmPositionEntity();
        myTaskVo.setCreateUserName(tmPositionEntity.getPositionName());
        myTaskVo.setCreateTime(DateFormatUtils.format((Date)baseBusinessObjEntity.getCreatetime(), (String)"yyyy-MM-dd HH:mm:ss"));
        myTaskVo.setProcessTitle(baseBusinessObjEntity.getProcessTitle());
        myTaskVo.setAssignee(task.getAssignee());
        myTaskVo.setRumTimeStatusDesc(baseBusinessObjEntity.getTaRuntimeStatusEntity().getDescription());
        return myTaskVo;
    }

    private ProcessDefinition getProcessDefinition(String processDefinitionId) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
    }
}

