/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.JsonDateValueProcessor;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.util.DBTypeUtil;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.service.TmOrgService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.role.vo.TmRoleVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.web.pojo.Client;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;

public class ResourceUtil {
    public static HashMap<String, Client> clientMap = new HashMap();

    public static String getRequestPath(HttpServletRequest request) {
        String requestPath = request.getRequestURI() + "?" + request.getQueryString();
        if (requestPath.indexOf("&") > -1) {
            requestPath = requestPath.substring(0, requestPath.indexOf("&"));
        }
        requestPath = requestPath.substring(request.getContextPath().length() + 1);
        return requestPath;
    }

    public static String getParameter(String field) {
        HttpServletRequest request = ContextHolderUtils.getRequest();
        return request.getParameter(field);
    }

    public static final TmUserEntity getSessionUserName() {
        Client client = ResourceUtil.getClient();
        if (client != null) {
            return client.getUser();
        }
        return null;
    }

    public static final TmCustomerEntity getSessionCustomer() {
        Client client = ResourceUtil.getClient();
        if (client != null) {
            return client.getCustomerEntity();
        }
        return null;
    }

    public static final TmPositionVo getCurrPosition() {
        Client client = ResourceUtil.getClient();
        if (client != null) {
            return client.getPosition();
        }
        return null;
    }

    public static final TmOrgEntity getCurrOrg() {
        Client client = ResourceUtil.getClient();
        if (client != null) {
            return client.getOrg();
        }
        return null;
    }

    public static final TmOrgEntity getCurrOrgByType(String orgType) {
        Client client = ResourceUtil.getClient();
        if (client != null) {
            if (client.getOrg() == null) {
                return new TmOrgEntity();
            }
            String currOrgId = client.getOrg().getId();
            TmOrgService tmOrgService = (TmOrgService)ApplicationContextUtils.getContext().getBean("tmOrgService");
            String sql = "select t.id from tm_org t where t.org_type = ?  start with t.id = ? connect by id = prior parent_id";
            List<Map<String, Object>> mapList = tmOrgService.findForMapList(sql, orgType, currOrgId);
            if (CollectionUtil.listNotEmptyNotSizeZero(mapList)) {
                return tmOrgService.get(TmOrgEntity.class, (Serializable)((Object)((String)mapList.get(0).get("id"))));
            }
        }
        return new TmOrgEntity();
    }

    public static final TmCustomerOrgEntity getCurrCustomerOrg() {
        Client client = ResourceUtil.getClient();
        if (client != null) {
            return client.getCustomerOrg();
        }
        return null;
    }

    public static TmUserVo getSessionTmUserVo() {
        TmUserService tmUserService = (TmUserService)ApplicationContextUtils.getContext().getBean("tmUserService");
        TmUserEntity tmUserEntity = ResourceUtil.getSessionUserName();
        TmUserVo tmUserVo = new TmUserVo();
        tmUserVo.setUserName(tmUserEntity.getUserName());
        return tmUserService.getTmUser(tmUserVo);
    }

    public static List<TmUserVo> getSessionTmUserList() {
        TmUserService tmUserService = (TmUserService)ApplicationContextUtils.getContext().getBean("tmUserService");
        TmUserEntity tmUserEntity = ResourceUtil.getSessionUserName();
        TmUserVo tmUserVo = new TmUserVo();
        tmUserVo.setUserName(tmUserEntity.getUserName());
        return tmUserService.getTmUserList(tmUserVo);
    }

    public static final String getTmRoleString() {
        if (StringUtil.isNotEmpty(ResourceUtil.getCurrPosition())) {
            BaseService baseService = (BaseService)ApplicationContextUtils.getContext().getBean("baseService");
            String positionId = ResourceUtil.getCurrPosition().getId();
            StringBuffer roleBuffer = new StringBuffer();
            String sql = "SELECT TR.ROLE_NAME AS roleName,TR.ROLE_CODE AS roleCode,TR.ID AS id FROM TM_ROLE TR JOIN TM_R_POSITION_ROLE TRPR ON TR.ID=TRPR.ROLE_ID  WHERE TRPR.POSITION_ID = ?";
            List<TmRoleVo> tmRoleVos = baseService.findBySql(TmRoleVo.class, sql, positionId);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmRoleVos)) {
                for (TmRoleVo tmRoleVo : tmRoleVos) {
                    if (roleBuffer.length() > 0) {
                        roleBuffer.append(",");
                    }
                    roleBuffer.append(tmRoleVo.getRoleCode());
                }
            }
            return roleBuffer.toString();
        }
        return null;
    }

    public static final String getCreateName() {
        Client client = ResourceUtil.getClient();
        if (client != null) {
            TmUserEntity user = client.getUser();
            TmPositionVo position = client.getPosition();
            if (user == null || position == null) {
                return null;
            }
            return user.getFullName() + "(" + position.getPositionName() + ")";
        }
        return null;
    }

    public static final String getJdbcUrl() {
        return DBTypeUtil.getDBType().toLowerCase();
    }

    public static final String getSysConfigProperty(String propertyName) {
        String value = null;
        ResourceBundle rb = ResourceBundle.getBundle("sysconfig");
        if (rb.containsKey(propertyName)) {
            value = rb.getString(propertyName);
        }
        return value;
    }

    public static final String getDbConfigProperty(String propertyName) {
        String value = null;
        ResourceBundle rb = ResourceBundle.getBundle("dbconfig");
        if (rb.containsKey(propertyName)) {
            value = rb.getString(propertyName);
        }
        return value;
    }

    public static Client getClient() {
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(session.getId());
        Client client = new Client();
        try {
            if (ob != null && (client = clientMap.get(session.getId())) == null) {
                JSONObject jsonObject = JSONObject.fromObject((Object)ob);
                client = (Client)JSONObject.toBean((JSONObject)jsonObject, Client.class);
                clientMap.put(session.getId(), client);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return client;
    }

    public static void setClient(Client client) {
        try {
            HttpSession session = ContextHolderUtils.getSession();
            JsonConfig jConfig = new JsonConfig();
            jConfig.registerJsonValueProcessor(Date.class, (JsonValueProcessor)new JsonDateValueProcessor());
            jConfig.setExcludes(new String[]{"functions"});
            JSONObject jsonObject = JSONObject.fromObject((Object)client, (JsonConfig)jConfig);
            session.setAttribute(ContextHolderUtils.getSession().getId(), (Object)jsonObject.toString());
            clientMap.put(session.getId(), client);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addString(String key, String value) {
        HttpSession session = ContextHolderUtils.getSession();
        session.setAttribute(key + session.getId(), (Object)value);
    }

    public static String getString(String key) {
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(key + session.getId());
        return ob != null ? ob.toString() : "";
    }

    public static Client getClientForLogin() {
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(session.getId());
        Client client = new Client();
        try {
            if (ob != null) {
                JSONObject jsonObject = JSONObject.fromObject((Object)ob);
                client = (Client)JSONObject.toBean((JSONObject)jsonObject, Client.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return client;
    }
}

