/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.core.redis.cache.impl;

import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

@Service(value="redisCacheService")
public class RedisCacheServiceImpl
implements IRedisCacheService {
    @Autowired
    private ShardedJedisPool shardedJedisPool;
    private Gson gson = new Gson();

    @Override
    public void set(String key, Object value, int expire) throws Exception {
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            jedis.set(key, this.gson.toJson(value));
            if (expire > 0) {
                jedis.expire(key, expire);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
    }

    @Override
    public <T> T get(String key, Class<T> cls) throws Exception {
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            String jsonValue = jedis.get(key);
            Object object = this.gson.fromJson(jsonValue, cls);
            return (T)object;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
    }

    @Override
    public <T> List<T> getList(String key, Class<T> t) throws Exception {
        ShardedJedis jedis = null;
        Gson gson = new Gson();
        ArrayList list = new ArrayList();
        List<Object> rList = new ArrayList();
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            String jsonValue = jedis.get(key);
            rList = (List)gson.fromJson(jsonValue, new TypeToken<List<T>>(){}.getType());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                rList.add(gson.fromJson((String)list.get(i), t));
            }
        }
        return rList;
    }

    @Override
    public Long scard(String key) throws Exception {
        Long count = 0L;
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            count = jedis.scard(key);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
        return count;
    }

    @Override
    public Long sadd(String key, Object ... members) throws Exception {
        Long rows = 0L;
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            String[] item = new String[members.length];
            int i = 0;
            for (Object obj : members) {
                item[i] = this.gson.toJson(obj);
                ++i;
            }
            rows = jedis.sadd(key, item);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
        return rows;
    }

    @Override
    public Long srem(String key, Object ... members) throws Exception {
        Long rows = 0L;
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            String[] item = new String[members.length];
            int i = 0;
            for (Object obj : members) {
                item[i] = this.gson.toJson(obj);
                ++i;
            }
            rows = jedis.srem(key, item);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
        return rows;
    }

    @Override
    public <T> Set<T> smembers(String key, Class<T> t) throws Exception {
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            Set sItem = jedis.smembers(key);
            HashSet<Object> result = new HashSet<Object>();
            Iterator rt = sItem.iterator();
            while (rt.hasNext()) {
                result.add(this.gson.fromJson((String)rt.next(), t));
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
    }

    @Override
    public Long sremove(String key) throws Exception {
        Long result = 0L;
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            result = jedis.del(key);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
        return result;
    }

    @Override
    public void setMap(String key, String mapKey, Object value) throws Exception {
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            String jsonValue = this.gson.toJson(value);
            jedis.hset(key, mapKey, jsonValue);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
    }

    @Override
    public <T> T getMapValue(String key, String mapKey, Class<T> t) throws Exception {
        Gson gson = new Gson();
        List list = null;
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            list = jedis.hmget(key, new String[]{mapKey});
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        String value = (String)list.get(0);
        if (value != null) {
            return (T)gson.fromJson(value, t);
        }
        return null;
    }

    @Override
    public <T> T getMapValueForMap(String key, String mapKey, Class<T> t) throws Exception {
        Gson gson = new Gson();
        List list = null;
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            list = jedis.hmget(key, new String[]{mapKey});
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        String value = (String)list.get(0);
        if (value != null) {
            Type type = new TypeToken<Map<String, T>>(){}.getType();
            return (T)gson.fromJson(value, type);
        }
        return null;
    }

    @Override
    public <T> List<T> getMapValues(String key, Class<T> t) throws Exception {
        ShardedJedis jedis = null;
        Gson gson = new Gson();
        List list = new ArrayList();
        ArrayList<Object> rList = new ArrayList<Object>();
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            list = jedis.hvals(key);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                rList.add(gson.fromJson((String)list.get(i), t));
            }
        }
        return rList;
    }

    @Override
    public Long removeMap(String key, String valueKey) throws Exception {
        Long result = 0L;
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            result = jedis.hdel(key, new String[]{valueKey});
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
        return result;
    }

    @Override
    public Map<String, String> getMaps(String key) throws Exception {
        ShardedJedis jedis = null;
        HashMap<String, String> rList = new HashMap();
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            rList = jedis.hgetAll(key);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
        return rList;
    }

    @Override
    public Long remove(String name) throws Exception {
        Long result = 0L;
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            result = jedis.del(name);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
        return result;
    }

    @Override
    public boolean exists(String key) throws Exception {
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            boolean bl = jedis.exists(key);
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
    }

    @Override
    public Long expire(String key, int seconds) throws Exception {
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            Long l = jedis.expire(key, seconds);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
    }

    @Override
    public long setnx(String key, Object value) throws Exception {
        ShardedJedis jedis = null;
        long rlt = 0L;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            rlt = jedis.setnx(key, this.gson.toJson(value));
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
        return rlt;
    }

    @Override
    public String getSet(String key, String value) throws Exception {
        ShardedJedis jedis = null;
        String rlt = null;
        try {
            jedis = (ShardedJedis)this.shardedJedisPool.getResource();
            rlt = jedis.getSet(key, value);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.shardedJedisPool.returnResourceObject((Object)jedis);
        }
        return rlt;
    }
}

