/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.login.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.IpUtil;
import com.biz.eisp.base.common.util.Md5EncryptionAndDecryption;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.login.service.LoginService;
import com.biz.eisp.login.service.LoginrRelatedService;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.position.service.PositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.web.pojo.Client;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="loginService")
@Transactional
public class LoginServiceImpl
extends BaseServiceImpl
implements LoginService {
    @Autowired
    private PositionService positionService;
    @Autowired(required=false)
    private LoginrRelatedService loginrRelatedService;

    @Override
    public AjaxJson validateUser(TmUserEntity tmUserEntity, String flag, String isEncryption, HttpServletRequest request) {
        String hql = "from TmUserEntity where userName = ? ";
        if (this.loginrRelatedService != null) {
            this.loginrRelatedService.beforeLoginIn(tmUserEntity, request);
        }
        AjaxJson j = new AjaxJson();
        List list = super.findByHql(hql, tmUserEntity.getUserName());
        if (list.size() > 0) {
            TmPositionVo tmPositionVo;
            TmUserEntity userEntity = (TmUserEntity)list.get(0);
            if (Globals.User_Forbidden == userEntity.getEnableStatus() && !Globals.Admin_Name.equalsIgnoreCase(userEntity.getUserName())) {
                j.setSuccess(false);
                j.setMsg("\u7528\u6237\u8d26\u53f7\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return j;
            }
            String pwd = tmUserEntity.getPassword();
            if (Globals.N.equalsIgnoreCase(isEncryption)) {
                pwd = Md5EncryptionAndDecryption.encryPwd(tmUserEntity.getPassword());
            }
            if (!pwd.equals(userEntity.getPassword())) {
                String configLoginErrTimes = ResourceUtil.getSysConfigProperty("loginErrTimes");
                if (StringUtil.isNotBlank((String)configLoginErrTimes)) {
                    short configLoginErrTimesShort = Short.parseShort(configLoginErrTimes);
                    Short loginErrTimes = userEntity.getLoginErrTimes() == null ? (short)0 : userEntity.getLoginErrTimes();
                    if (loginErrTimes >= configLoginErrTimesShort) {
                        String sql = "update tm_user set enable_status=?,update_date=sysdate where id=?";
                        this.executeSql(sql, Globals.User_Forbidden, userEntity.getId());
                    } else {
                        Object sql = loginErrTimes;
                        Short s = loginErrTimes = Short.valueOf((short)(loginErrTimes + 1));
                        sql = "update tm_user set login_err_times=?,update_date=sysdate where id=?";
                        this.executeSql((String)sql, loginErrTimes, userEntity.getId());
                    }
                    if (loginErrTimes == configLoginErrTimesShort) {
                        j.setMsg("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef\uff01\u7528\u6237\uff1a" + userEntity.getUserName() + "\u88ab\u9501\u5b9a\uff01");
                    } else {
                        j.setMsg("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef\uff01\u60a8\u8fd8\u6709" + (configLoginErrTimesShort - loginErrTimes) + "\u6b21\u673a\u4f1a\u5c1d\u8bd5");
                    }
                } else {
                    j.setMsg("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef\uff01");
                }
                j.setSuccess(false);
                return j;
            }
            String sql = "update tm_user set login_err_times=?,update_date=sysdate where id=?";
            this.executeSql(sql, Globals.User_Normal, userEntity.getId());
            List<TmPositionVo> positions = this.positionService.getPositinByUserId(userEntity, Globals.Main_Position_Type);
            if (positions.size() == 0 && userEntity.getUserType() == Globals.ENTERPRISE_USER) {
                j.setSuccess(false);
                j.setMsg("\u7528\u6237\u672a\u5206\u914d\u4e3b\u804c\u4f4d,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return j;
            }
            if (userEntity.getUserType() == Globals.ENTERPRISE_USER && Globals.ONE.equals((tmPositionVo = positions.get(0)).getEnableStatus())) {
                j.setSuccess(false);
                j.setMsg("\u7528\u6237\u6240\u5c5e\u4e3b\u804c\u4f4d\u88ab\u505c\u7528,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return j;
            }
            if (Globals.Y.equalsIgnoreCase(flag)) {
                TmPositionVo positionVo = new TmPositionVo();
                if (CollectionUtil.listNotEmptyNotSizeZero(positions)) {
                    positionVo = positions.get(0);
                }
                this.saveLoginInfo(userEntity, positionVo, request);
            }
            if (this.loginrRelatedService != null) {
                this.loginrRelatedService.afterLoginIn(userEntity, request);
            }
        } else {
            j.setSuccess(false);
            j.setMsg("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef\uff01");
            return j;
        }
        return j;
    }

    @Override
    public void saveLoginInfo(TmUserEntity tmUserEntity, TmPositionVo tmPositionVo, HttpServletRequest request) {
        HttpSession session = ContextHolderUtils.getSession();
        Client client = new Client();
        client.setIp(IpUtil.getIpAddr(request));
        client.setLogindatetime(new Date());
        client.setUser(this.getUser(tmUserEntity));
        client.setPosition(tmPositionVo);
        if (Globals.ENTERPRISE_USER == tmUserEntity.getUserType()) {
            TmCustomerOrgEntity customerOrg;
            if (StringUtil.isNotEmpty((String)tmPositionVo.getOrgId())) {
                TmOrgEntity orgEntity = this.get(TmOrgEntity.class, (Serializable)((Object)tmPositionVo.getOrgId()));
                client.setOrg(this.getTmOrgEntity(orgEntity));
            }
            if ((customerOrg = this.findUniqueByProperty(TmCustomerOrgEntity.class, "positionId", tmPositionVo.getId())) != null) {
                client.setCustomerOrg(this.getTmCustomerOrgEntity(customerOrg));
            }
        }
        ResourceUtil.setClient(client);
    }

    private TmCustomerOrgEntity getTmCustomerOrgEntity(TmCustomerOrgEntity org) {
        TmCustomerOrgEntity result = new TmCustomerOrgEntity();
        result.setId(org.getId());
        result.setHeadString(org.getHeadString());
        result.setEnableStatus(org.getEnableStatus());
        result.setCreateDate(org.getCreateDate());
        result.setCreateName(org.getCreateName());
        result.setUpdateDate(org.getUpdateDate());
        result.setUpdateName(org.getUpdateName());
        result.setExtChar1(org.getExtChar1());
        result.setExtChar2(org.getExtChar2());
        result.setExtChar3(org.getExtChar3());
        result.setExtChar4(org.getExtChar4());
        result.setExtChar5(org.getExtChar5());
        result.setExtNumber1(org.getExtNumber1());
        result.setExtNumber2(org.getExtNumber2());
        result.setExtNumber3(org.getExtNumber3());
        result.setIsLeaf(org.getIsLeaf());
        result.setCustOrgCode(org.getCustOrgCode());
        result.setCustomerOrgName(org.getCustomerOrgName());
        result.setCustOrgDesc(org.getCustOrgDesc());
        result.setCustOrgType(org.getCustOrgType());
        result.setCustOrgLevel(org.getCustOrgLevel());
        result.setPositionId(org.getPositionId());
        return result;
    }

    private TmOrgEntity getTmOrgEntity(TmOrgEntity org) {
        TmOrgEntity result = new TmOrgEntity();
        result.setId(org.getId());
        result.setOrgName(org.getOrgName());
        result.setOrgDesc(org.getOrgDesc());
        result.setOrgCode(org.getOrgCode());
        result.setOrgType(org.getOrgType());
        result.setHeadString(org.getHeadString());
        result.setSubCode(org.getSubCode());
        result.setEnableStatus(org.getEnableStatus());
        result.setCreateDate(org.getCreateDate());
        result.setCreateName(org.getCreateName());
        result.setUpdateDate(org.getUpdateDate());
        result.setUpdateName(org.getUpdateName());
        result.setStatus(org.getStatus());
        result.setExtChar1(org.getExtChar1());
        result.setExtChar2(org.getExtChar2());
        result.setExtChar3(org.getExtChar3());
        result.setExtChar4(org.getExtChar4());
        result.setExtChar5(org.getExtChar5());
        result.setExtNumber1(org.getExtNumber1());
        result.setExtNumber2(org.getExtNumber2());
        result.setExtNumber3(org.getExtNumber3());
        result.setExtDate1(org.getExtDate1());
        result.setExtDate2(org.getExtDate2());
        result.setIsLeaf(org.getIsLeaf());
        return result;
    }

    private TmUserEntity getUser(TmUserEntity tmUserEntity) {
        TmUserEntity rt = new TmUserEntity();
        rt.setId(tmUserEntity.getId());
        rt.setUserName(tmUserEntity.getUserName());
        rt.setFullName(tmUserEntity.getFullName());
        rt.setExtChar7(tmUserEntity.getExtChar7());
        rt.setSex(tmUserEntity.getSex());
        rt.setMobilePhone(tmUserEntity.getMobilePhone());
        rt.setEmail(tmUserEntity.getEmail());
        rt.setPassword(tmUserEntity.getPassword());
        rt.setEnableStatus(tmUserEntity.getEnableStatus());
        rt.setHeadString(tmUserEntity.getHeadString());
        rt.setHasFirstTime(tmUserEntity.getHasFirstTime());
        rt.setCreateDate(tmUserEntity.getCreateDate());
        rt.setCreateName(tmUserEntity.getCreateName());
        rt.setUpdateDate(tmUserEntity.getUpdateDate());
        rt.setUpdateName(tmUserEntity.getUpdateName());
        rt.setUserType(tmUserEntity.getUserType());
        rt.setBeginDate(tmUserEntity.getBeginDate());
        rt.setEndDate(tmUserEntity.getEndDate());
        rt.setLoginErrTimes(tmUserEntity.getLoginErrTimes());
        rt.setExtChar1(tmUserEntity.getExtChar1());
        rt.setExtChar2(tmUserEntity.getExtChar2());
        rt.setExtChar3(tmUserEntity.getExtChar3());
        rt.setExtChar4(tmUserEntity.getExtChar4());
        rt.setExtChar5(tmUserEntity.getExtChar5());
        rt.setExtChar6(tmUserEntity.getExtChar6());
        rt.setExtChar7(tmUserEntity.getExtChar7());
        rt.setExtChar8(tmUserEntity.getExtChar8());
        rt.setExtChar9(tmUserEntity.getExtChar9());
        rt.setExtChar10(tmUserEntity.getExtChar10());
        rt.setExtNumber1(tmUserEntity.getExtNumber1());
        rt.setExtNumber2(tmUserEntity.getExtNumber2());
        rt.setExtNumber3(tmUserEntity.getExtNumber3());
        rt.setExtDate1(tmUserEntity.getExtDate1());
        rt.setExtDate2(tmUserEntity.getExtDate2());
        return rt;
    }
}

