/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.customer.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.dao.TmCustomerDao;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.entity.TmRCustPosBgDetailEntity;
import com.biz.eisp.mdm.customer.service.TmCustomerExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerSearchExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerService;
import com.biz.eisp.mdm.customer.service.TmRCustPosBgDetailService;
import com.biz.eisp.mdm.customer.transformer.TmCustomerVoToTmCustomerEntity;
import com.biz.eisp.mdm.customer.util.CustomerLogMsgUtil;
import com.biz.eisp.mdm.customer.vo.QueryTmCustomerVo;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmCustomerService")
@Transactional
public class TmCustomerServiceImpl
extends BaseServiceImpl
implements TmCustomerService {
    @Autowired
    private TmCustomerDao tmCustomerDao;
    @Autowired
    private TmRCustPosBgDetailService tmRCustPosBgDetailService;
    @Autowired(required=false)
    private TmCustomerSearchExtendService tmCustomerSearchExtendService;
    @Autowired(required=false)
    private TmCustomerExtendService tmCustomerExtendService;

    @Override
    public List<TmCustomerVo> findTmCustomerList(TmCustomerVo customerVo, Page page) {
        String sql = "";
        if (this.tmCustomerSearchExtendService != null) {
            sql = this.tmCustomerSearchExtendService.buildSearchSql(customerVo);
            if (StringUtil.isEmpty(sql)) {
                sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.Table_CUSTOMER, customerVo);
                sql = this.tmCustomerSearchExtendService.extendSearchSql(customerVo, sql);
            }
        } else {
            sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.Table_CUSTOMER, customerVo);
            sql = this.appendCustomerCondition(sql, customerVo);
        }
        return this.tmCustomerDao.findTmCustomerList(customerVo, page, sql);
    }

    public String appendCustomerCondition(String sql, TmCustomerVo customerVo) {
        String sqlJoin = "select t1.customer_id customerId, to_char(listagg(t1.position_id,',') within GROUP (order by t2.position_code)) positionId,to_char(listagg(t2.position_name,',') within GROUP (order by t2.position_code)) dockPosition,to_char(listagg(t2.position_code,',') within GROUP (order by t2.position_code)) position_code,to_char(listagg(t1.business_group,',') within GROUP (order by t2.position_code)) businessGroup,to_char(listagg(tu.username,',') within GROUP (order by t2.position_code)) username,to_char(listagg(tu.fullname,',') within GROUP (order by t2.position_code)) dockUserName  from TM_R_CUST_POS_BG t1 left join tm_position t2 on t2.id = t1.position_id  left join tm_r_user_position up on up.position_id=t1.position_id  left join tm_user tu on tu.id=up.user_id  group by t1.customer_id";
        String sqlOn = " to_Char(t1.customerId)=to_char(t.id) ";
        String sqlWhere = "";
        sqlWhere = StringUtil.isNotEmpty((String)customerVo.getId()) ? " and (t.id='" + customerVo.getId() + "'" : " and exists(select 1 from TM_CUSTOMER t2 left join  TM_R_CUST_POS_BG t3 on t3.customer_id=t2.id where t2.id=to_char(t1.customerId)";
        if (StringUtil.isNotEmpty((String)customerVo.getDockUserName())) {
            sqlWhere = sqlWhere + " and  (to_char(t1.username) like '%" + customerVo.getDockUserName() + "%' or to_char(t1.dockUserName) like '%" + customerVo.getDockUserName() + "%')";
        }
        if (StringUtil.isNotEmpty((String)customerVo.getDockPosition())) {
            sqlWhere = sqlWhere + "and (to_char(t1.dockPosition) like '%" + customerVo.getDockPosition() + "%' or to_char(t1.position_code) like '%" + customerVo.getDockPosition() + "%')";
        }
        if (StringUtil.isNotEmpty((String)customerVo.getBusinessGroup())) {
            sqlWhere = sqlWhere + " and to_char(t1.businessGroup) like '%" + customerVo.getBusinessGroup() + "%'";
        }
        sqlWhere = sqlWhere + ")";
        if (StringUtil.isEmpty(customerVo.getId()) && StringUtil.isEmpty(customerVo.getDockUserName()) && StringUtil.isEmpty(customerVo.getDockPosition()) && StringUtil.isEmpty(customerVo.getBusinessGroup())) {
            sqlWhere = "";
        }
        String orderSql = " order by t.customerCode asc";
        return DynamicConfigUtil.getInstance().appendCustomCondition(sql, sqlJoin, sqlOn, sqlWhere, orderSql);
    }

    @Override
    public void saveTmCustomer(TmCustomerVo customerVo, Page page) {
        ArrayList<TmBusinessGroupVo> addBusinessGroupVoList = new ArrayList<TmBusinessGroupVo>();
        ArrayList<TmBusinessGroupVo> deleteBusinessGroupVoList = new ArrayList<TmBusinessGroupVo>();
        TmCustomerEntity tmCustomerEntity = null;
        String customerId = "";
        if (StringUtil.isNotEmpty(this.tmCustomerExtendService)) {
            try {
                this.tmCustomerExtendService.validate(customerVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmCustomerEntity = this.tmCustomerExtendService.saveBefore(customerVo, page);
        }
        if (StringUtil.isEmpty(tmCustomerEntity)) {
            tmCustomerEntity = new TmCustomerVoToTmCustomerEntity(this, this.tmRCustPosBgDetailService, addBusinessGroupVoList, deleteBusinessGroupVoList).apply(customerVo);
            customerId = tmCustomerEntity.getId();
        }
        if (StringUtil.isNotEmpty(this.tmCustomerExtendService)) {
            tmCustomerEntity = this.tmCustomerExtendService.saveBefore(tmCustomerEntity, customerVo, page);
        }
        this.saveOrUpdate(tmCustomerEntity);
        if (tmCustomerEntity.getCooperative().equals("end")) {
            this.disableCustomerUser(tmCustomerEntity.getId());
        }
        this.executeSql("DELETE FROM TM_R_CUST_POS_BG WHERE CUSTOMER_ID IS NULL", new Object[0]);
        this.getSession().flush();
        this.saveBusinessGroupInfo(tmCustomerEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
        if (StringUtil.isNotEmpty(this.tmCustomerExtendService)) {
            tmCustomerEntity = this.tmCustomerExtendService.savePost(tmCustomerEntity, customerVo, page);
        }
    }

    private void saveBusinessGroupInfo(TmCustomerEntity tmCustomerEntity, List<TmBusinessGroupVo> addBusinessGroupVoList, List<TmBusinessGroupVo> deleteBusinessGroupVoList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteBusinessGroupVoList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (TmBusinessGroupVo vo : deleteBusinessGroupVoList) {
                map.put(vo.getBusinessGroup(), vo.getBusinessGroup());
            }
            String deleteSql = "delete from tm_r_cust_pos_bg_detail where business_group = ?";
            Set keyset = map.keySet();
            for (String key : keyset) {
                this.executeSql(deleteSql, key);
            }
        }
        this.getSession().flush();
        if (CollectionUtil.listNotEmptyNotSizeZero(addBusinessGroupVoList)) {
            for (TmBusinessGroupVo vo : addBusinessGroupVoList) {
                if (vo.getTypeCode() == "orgCode" || vo.getTypeCode() == "positionCode") continue;
                TmRCustPosBgDetailEntity entity = new TmRCustPosBgDetailEntity();
                entity.setBusinessGroup(vo.getBusinessGroup());
                entity.setDetailCode(vo.getDetailCode());
                entity.setDetailName(vo.getDetailName());
                entity.setTypeCode(vo.getTypeCode());
                entity.setTypeName(vo.getTypeName());
                this.save(entity);
            }
        }
        this.getSession().flush();
        this.saveBusinessGroupLog(tmCustomerEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
    }

    private void saveBusinessGroupLog(TmCustomerEntity tmCustomerEntity, List<TmBusinessGroupVo> newBusinessGroupVoList, List<TmBusinessGroupVo> oldBusinessGroupVoList) {
        Map<String, List<TmBusinessGroupVo>> oldMap = this.buildMapByBusinessGroup(oldBusinessGroupVoList);
        Map<String, List<TmBusinessGroupVo>> newMap = this.buildMapByBusinessGroup(newBusinessGroupVoList);
        Set<String> oldKeySet = oldMap.keySet();
        String updateMsg = "";
        String deleteMsg = "";
        String addMsg = "";
        for (String oldKey : oldKeySet) {
            if (newMap.containsKey(oldKey)) {
                updateMsg = updateMsg + CustomerLogMsgUtil.buildUpdateMsg(newMap.get(oldKey), oldMap.get(oldKey)) + "<hr>";
                newMap.remove(oldKey);
                continue;
            }
            deleteMsg = deleteMsg + CustomerLogMsgUtil.buildDeleteMsg(oldMap.get(oldKey)) + "<hr>";
        }
        if (StringUtils.isNotBlank((CharSequence)(addMsg = addMsg + this.buildAddMsg(tmCustomerEntity, newMap)))) {
            this.addLog(OperationType.INSERT, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmCustomerEntity.getId(), addMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)deleteMsg)) {
            this.addLog(OperationType.DELETE, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmCustomerEntity.getId(), deleteMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)updateMsg)) {
            this.addLog(OperationType.UPDATE, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmCustomerEntity.getId(), updateMsg);
        }
    }

    private Map<String, List<TmBusinessGroupVo>> buildMapByBusinessGroup(List<TmBusinessGroupVo> voList) {
        HashMap<String, List<TmBusinessGroupVo>> map = new HashMap<String, List<TmBusinessGroupVo>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(voList)) {
            for (TmBusinessGroupVo oldBusinessGroupVo : voList) {
                if (map.containsKey(oldBusinessGroupVo.getBusinessGroup())) {
                    ((List)map.get(oldBusinessGroupVo.getBusinessGroup())).add(oldBusinessGroupVo);
                    continue;
                }
                ArrayList<TmBusinessGroupVo> list = new ArrayList<TmBusinessGroupVo>();
                list.add(oldBusinessGroupVo);
                map.put(oldBusinessGroupVo.getBusinessGroup(), list);
            }
        }
        return map;
    }

    private String buildAddMsg(TmCustomerEntity tmCustomerEntity, Map<String, List<TmBusinessGroupVo>> newMap) {
        Set<String> keySet = newMap.keySet();
        String msg = "";
        for (String key : keySet) {
            msg = msg + CustomerLogMsgUtil.buildAddMsg(newMap.get(key));
            msg = msg + "<hr>";
        }
        return msg;
    }

    private void disableCustomerUser(String customerId) {
        String sql = "UPDATE tm_user SET enable_status = 1 WHERE ID in (SELECT user_id FROM tm_r_user_customer WHERE customer_id = ?)";
        this.executeSql(sql, customerId);
    }

    @Override
    public void deleteTmCustomer(String ids) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] customerIds;
            for (String customerId : customerIds = ids.split(",")) {
                TmCustomerEntity tmCustomerEntity = this.get(TmCustomerEntity.class, (Serializable)((Object)customerId));
                if (tmCustomerEntity == null || !StringUtil.isNotEmpty((String)tmCustomerEntity.getId())) continue;
                this.delete(tmCustomerEntity);
            }
        }
    }

    @Override
    public TmCustomerVo getTmCustomerVoById(TmCustomerVo customerVo, Page page) {
        List<TmCustomerVo> list = this.findTmCustomerList(customerVo, null);
        return list.size() > 0 ? list.get(0) : new TmCustomerVo();
    }

    @Override
    public List<TmCustomerVo> findTmCustomerByPosList(TmCustomerVo customerVo, Page page) {
        return this.tmCustomerDao.findTmCustomerByPosList(customerVo, page);
    }

    @Override
    public List<TmCustomerVo> findTmCustTomerByAllPossible(QueryTmCustomerVo queryTmCustomerVo, Page page) {
        return this.tmCustomerDao.findTmCustTomerByAllPossible(queryTmCustomerVo, page);
    }

    @Override
    public List<TmCustomerVo> findTpmCustomerList(TmCustomerVo customerVo, Page page) {
        return this.tmCustomerDao.findTpmCustomerList(customerVo, page);
    }

    @Override
    public List<TmLogVo> findCustomerLogList(TmLogVo tmLogVo, Page page) {
        return this.tmCustomerDao.findCustomerLogList(tmLogVo, page);
    }

    @Override
    public List<TmCustomerVo> findTmCustTomerByOrgAndCustType(QueryTmCustomerVo queryTmCustomerVo, Page page) {
        return this.tmCustomerDao.findTmCustTomerByOrgAndCustType(queryTmCustomerVo, page);
    }

    @Override
    public List<ComboBox> findCustomerComboBoxByPosId(String positionId) {
        String sql = "SELECT DISTINCT TC.ID AS ID,TC.CUSTOMER_NAME AS TEXT,TC.CUSTOMER_CODE AS VALUE FROM TM_CUSTOMER TC JOIN TM_R_CUST_POS_BG TRCP ON TC.ID = TRCP.CUSTOMER_ID WHERE TRCP.POSITION_ID=?";
        return this.findBySql(ComboBox.class, sql, positionId);
    }

    @Override
    public List<TmCustomerVo> findCustomer(String settlementCode, String customerType, String contractCode, String orgId) {
        return this.tmCustomerDao.findCustomer(settlementCode, customerType, contractCode, orgId);
    }

    @Override
    public TmCustomerVo findSapCustomer(String code) {
        List<TmCustomerVo> customerVoList = this.tmCustomerDao.findSapCustomer(code);
        return customerVoList != null && customerVoList.size() > 0 ? customerVoList.get(0) : new TmCustomerVo();
    }
}

