/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.user.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.Md5EncryptionAndDecryption;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.dao.TmUserDao;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmUserPositionEntity;
import com.biz.eisp.mdm.user.service.TmUserExtendService;
import com.biz.eisp.mdm.user.service.TmUserSearchExtendService;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.transformer.TmUserEntityToTmUserVo;
import com.biz.eisp.mdm.user.transformer.TmUserVoToTmUserEntity;
import com.biz.eisp.mdm.user.vo.QueryTmuserVo;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.user.vo.UserInfoEntity;
import com.biz.eisp.mdm.web.pojo.Client;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmUserService")
@Transactional
public class TmUserServiceImpl
extends BaseServiceImpl
implements TmUserService {
    @Autowired
    private TmUserDao tmUserDao;
    @Autowired
    private TmPositionService tmPositionService;
    @Autowired(required=false)
    private TmUserExtendService tmUserExtendService;
    @Autowired(required=false)
    private TmUserSearchExtendService tmUserSearchExtendService;

    @Override
    public List<TmUserVo> findTmUserList(TmUserVo tmUserVo, Page page) {
        String sql = "";
        if (this.tmUserSearchExtendService != null) {
            sql = this.tmUserSearchExtendService.buildSearchSql(tmUserVo);
            if (StringUtil.isEmpty(sql)) {
                sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_USER, tmUserVo);
                sql = this.tmUserSearchExtendService.extendSearchSql(tmUserVo, sql);
            }
        } else {
            sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_USER, tmUserVo);
            sql = this.appendUserCondition(sql, tmUserVo);
        }
        List<TmUserVo> volist = this.tmUserDao.findTmUserList(tmUserVo, page, sql);
        TmPositionVo tmPositionVo = null;
        if (!CollectionUtils.isEmpty(volist)) {
            StringBuffer posNames = null;
            StringBuffer isMains = null;
            StringBuffer posIds = null;
            for (TmUserVo tmUserVo2 : volist) {
                posNames = new StringBuffer();
                isMains = new StringBuffer();
                posIds = new StringBuffer();
                tmPositionVo = new TmPositionVo();
                tmPositionVo.setUserId(tmUserVo2.getId());
                List<TmPositionVo> list = this.tmPositionService.findTmPositionList(tmPositionVo, null);
                tmUserVo2.setPositionJson(JSONArray.toJSONString(list));
                for (TmPositionVo tmPositionVo2 : list) {
                    if (posNames.length() > 0) {
                        posNames.append(",");
                        isMains.append(",");
                        posIds.append(",");
                    }
                    posNames.append(tmPositionVo2.getPositionName());
                    isMains.append(tmPositionVo2.getIsMain());
                    posIds.append(tmPositionVo2.getId());
                }
                tmUserVo2.setPositionName(posNames.toString());
                tmUserVo2.setIsMain(isMains.toString());
                tmUserVo2.setPositionId(posIds.toString());
            }
        }
        return volist;
    }

    public String appendUserCondition(String sql, TmUserVo userVo) {
        String joinSql = "SELECT rup.user_id,   listagg(rup.position_id,',') within GROUP (order by  tr.org_name) positionId,   listagg( p.position_name,',') within GROUP (order by  tr.org_name) positionName,   listagg( p.position_level,',') within GROUP (order by  tr.org_name) positionLevel,   listagg(tr.org_name,',') within GROUP (order by  tr.org_name) orgName,   listagg(tr.id,',') within GROUP (order by  tr.org_name) orgId,   listagg( prp.position_name,',') within GROUP (order by tr.org_name) parentPositionName,  listagg( prp.id,',') within GROUP (order by tr.org_name) parentPositionId,  listagg( pu.fullname,',') within GROUP (order by tr.org_name) parentUserName,  listagg( pu.id,',') within GROUP (order by tr.org_name) parentUserId FROM tm_r_user_position rup   LEFT JOIN tm_position p  ON p.id = rup.position_id  LEFT JOIN tm_org tr  ON p.org_id = tr.id  LEFT JOIN tm_position prp  ON prp.id = p.parent_id  LEFT JOIN tm_r_user_position ptup  ON (ptup.position_id=prp.id  AND ptup.is_main    = 0)   LEFT JOIN tm_user pu  ON pu.id  =ptup.user_id where 1=1  group by rup.user_id";
        String sqlWhere = "";
        if (StringUtil.isNotEmpty((String)userVo.getId())) {
            sqlWhere = sqlWhere + " and t.id='" + userVo.getId() + "'";
        }
        if (StringUtil.isNotEmpty((String)userVo.getOrgId())) {
            sqlWhere = sqlWhere + " and t1.orgId like '%" + userVo.getOrgId() + "%'";
        }
        if (StringUtil.isNotEmpty((String)userVo.getOrgName())) {
            sqlWhere = sqlWhere + " and t1.orgId like '%" + userVo.getOrgName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)userVo.getPositionName())) {
            sqlWhere = sqlWhere + " and t1.positionName like '%" + userVo.getPositionName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)userVo.getParentPositionName())) {
            sqlWhere = sqlWhere + " and t1.parentPositionName like '%" + userVo.getParentPositionName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)userVo.getParentUserName())) {
            sqlWhere = sqlWhere + " and t1.parentUserName like '%" + userVo.getParentUserName() + "%'";
        }
        if (userVo.getEnableStatus() != null) {
            sqlWhere = sqlWhere + " and t.enableStatus = " + userVo.getEnableStatus();
        }
        if (userVo.getUserType() != null) {
            sqlWhere = sqlWhere + " and t.userType = 0";
        }
        String orderSql = " order by t.userName asc";
        String sqlOn = " t1.user_id = t.id";
        return DynamicConfigUtil.getInstance().appendCustomCondition(sql, joinSql, sqlOn, sqlWhere, orderSql);
    }

    @Override
    public TmUserVo getTmUserVo(String id) {
        TmUserVo vo = null;
        if (StringUtils.isBlank((CharSequence)id)) {
            return vo;
        }
        TmUserEntity tmUserEntity = this.get(TmUserEntity.class, (Serializable)((Object)id));
        if (tmUserEntity == null) {
            throw new BusinessException("\u627e\u4e0d\u5230\u804c\u4f4dEntity\u5b9e\u4f53:" + id);
        }
        vo = new TmUserEntityToTmUserVo(this).apply(tmUserEntity);
        return vo;
    }

    @Override
    public void saveTmUser(TmUserVo tmUserVo, Page page) {
        TmUserEntity tmUserEntity = null;
        String userId = "";
        if (StringUtil.isNotEmpty(this.tmUserExtendService)) {
            try {
                this.tmUserExtendService.validate(tmUserVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u6570\u636e\u6821\u9a8c\u5931\u8d25:" + e.getMessage());
            }
            tmUserEntity = this.tmUserExtendService.saveBefore(tmUserVo, page);
        }
        if (tmUserEntity == null) {
            TmUserVoToTmUserEntity tmUserVoToTmUserEntity = new TmUserVoToTmUserEntity(this);
            tmUserEntity = tmUserVoToTmUserEntity.apply(tmUserVo);
            userId = tmUserEntity.getId();
        }
        if (StringUtil.isNotEmpty(this.tmUserExtendService)) {
            tmUserEntity = this.tmUserExtendService.saveBefore(tmUserEntity, tmUserVo, page);
        }
        this.saveOrUpdate(tmUserEntity);
        if (StringUtil.isNotEmpty(this.tmUserExtendService)) {
            tmUserEntity = this.tmUserExtendService.savePost(tmUserEntity, tmUserVo, page);
        }
        String hql = "FROM TmUserPositionEntity where tmUser.id is null";
        List list = this.findByHql(hql, new Object[0]);
        for (TmUserPositionEntity userPosition : list) {
            String userPostId = userPosition.getId();
            super.addLogAndRemoveInvalidInfo(userPostId, userPosition, userId, null);
        }
        this.executeSql("DELETE FROM TM_R_USER_POSITION WHERE USER_ID IS NULL", new Object[0]);
    }

    @Override
    public void deleteTmUser(String ids, Page page) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] userIds;
            for (String userId : userIds = ids.split(",")) {
                TmUserEntity userEntity = this.get(TmUserEntity.class, (Serializable)((Object)userId));
                if (userEntity == null || !StringUtil.isNotEmpty((String)userEntity.getId())) continue;
                this.delete(userEntity);
            }
        }
    }

    @Override
    public ValidForm valideTmUser(TmUserVo tmUserVo, String param) {
        ValidForm validForm = new ValidForm();
        String hql = "";
        if (StringUtil.isNotEmpty((String)tmUserVo.getId())) {
            hql = "from TmUserEntity where userName=? and id<>? and enableStatus=?";
            List list = this.findByHql(hql, param, tmUserVo.getId(), Short.parseShort(Globals.ZERO.toString()));
            if (!CollectionUtils.isEmpty(list)) {
                validForm.setInfo("\u767b\u5f55\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728");
                validForm.setStatus("n");
            }
        } else {
            hql = "from TmUserEntity where userName=? and enableStatus=?";
            List list = this.findByHql(hql, param, Short.parseShort(Globals.ZERO.toString()));
            if (!CollectionUtils.isEmpty(list)) {
                validForm.setInfo("\u767b\u5f55\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728");
                validForm.setStatus("n");
            }
        }
        return validForm;
    }

    @Override
    public AjaxJson startOrStopTmuser(TmUserVo tmUserVo) {
        AjaxJson j = new AjaxJson();
        TmUserEntity tmUserEntity = this.get(TmUserEntity.class, (Serializable)((Object)tmUserVo.getId()));
        if (StringUtil.isNotEmpty(tmUserEntity)) {
            if (tmUserEntity.getEnableStatus().toString().equals(tmUserVo.getEnableStatus().toString())) {
                j.setSuccess(false);
                String fg = Globals.ZERO.intValue() == tmUserVo.getEnableStatus().intValue() ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                tmUserEntity.setEnableStatus(Short.parseShort(tmUserVo.getEnableStatus().toString()));
                tmUserEntity.setLoginErrTimes(Globals.User_Normal);
                this.updateEntity(tmUserEntity);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }

    @Override
    public TmUserVo getTmUser(TmUserVo tmUserVo) {
        return this.tmUserDao.getTmUser(tmUserVo);
    }

    @Override
    public AjaxJson changeTmuserPassword(TmUserVo tmUserVo) {
        TmUserEntity userEntity;
        AjaxJson json = new AjaxJson();
        if (StringUtil.isEmpty(tmUserVo.getPassword()) || StringUtil.isEmpty(tmUserVo.getNewpassword())) {
            json.setSuccess(false);
            json.setMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            return json;
        }
        String password = Md5EncryptionAndDecryption.encryPwd(tmUserVo.getPassword());
        if (!password.equals((userEntity = ResourceUtil.getSessionUserName()).getPassword())) {
            json.setSuccess(false);
            json.setMsg("\u539f\u5bc6\u7801\u4e0d\u4e00\u81f4,\u8bf7\u91cd\u65b0\u8f93\u5165\u539f\u5bc6\u7801");
            return json;
        }
        String sql = "update tm_user set password = ? , update_date = ? , update_name = ? where id=?";
        int flag = this.executeSql(sql, Md5EncryptionAndDecryption.encryPwd(tmUserVo.getNewpassword()), new Date(), ResourceUtil.getSessionUserName().getUserName(), userEntity.getId());
        if (flag > 0) {
            Client client = ResourceUtil.getClient();
            userEntity.setPassword(Md5EncryptionAndDecryption.encryPwd(tmUserVo.getNewpassword()));
            client.setUser(userEntity);
            ResourceUtil.setClient(client);
        }
        return json;
    }

    @Override
    public AjaxJson changeFirstTmPassword(TmUserVo tmUserVo) {
        TmUserEntity userEntity;
        AjaxJson json = new AjaxJson();
        if (StringUtil.isEmpty(tmUserVo.getPassword()) || StringUtil.isEmpty(tmUserVo.getNewpassword())) {
            json.setSuccess(false);
            json.setMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            return json;
        }
        String password = Md5EncryptionAndDecryption.encryPwd(tmUserVo.getPassword());
        if (!password.equals((userEntity = ResourceUtil.getSessionUserName()).getPassword())) {
            json.setSuccess(false);
            json.setMsg("\u539f\u5bc6\u7801\u4e0d\u4e00\u81f4,\u8bf7\u91cd\u65b0\u8f93\u5165\u539f\u5bc6\u7801");
            return json;
        }
        String sql = "update tm_user set has_first_time=0 , password = ? , update_date = ? , update_name = ? where id=?";
        int flag = this.executeSql(sql, Md5EncryptionAndDecryption.encryPwd(tmUserVo.getNewpassword()), new Date(), tmUserVo.getUserName(), userEntity.getId());
        if (flag > 0) {
            Client client = ResourceUtil.getClient();
            userEntity.setPassword(Md5EncryptionAndDecryption.encryPwd(tmUserVo.getNewpassword()));
            client.setUser(userEntity);
            ResourceUtil.setClient(client);
        }
        return json;
    }

    @Override
    public List<TmUserVo> findTmUserByAllPossible(QueryTmuserVo queryTmuserVo, Page page) {
        return this.tmUserDao.findTmUserByAllPossible(queryTmuserVo, page);
    }

    @Override
    public List<TmUserVo> findTmCustUserByAllPossible(QueryTmuserVo queryTmuserVo, Page page) {
        return this.tmUserDao.findTmCustUserByAllPossible(queryTmuserVo, page);
    }

    @Override
    public List<TmUserVo> getTmUserBySearch(TmUserVo tmUserVo, Page page) {
        QueryTmuserVo queryTmuserVo = new QueryTmuserVo();
        if (StringUtil.isNotEmpty((String)tmUserVo.getSearchParam())) {
            queryTmuserVo.setFullName(tmUserVo.getSearchParam());
        }
        return this.tmUserDao.findTmUserByAllPossible(queryTmuserVo, page);
    }

    @Override
    public List<TmUserVo> getTmUserList(TmUserVo tmUserVo) {
        return this.tmUserDao.getTmUserList(tmUserVo);
    }

    @Override
    public UserInfoEntity findUserInfoEntityByPosId(String posId) {
        String nowDate = DateUtils.dateNow2Str();
        return this.tmUserDao.findUserInfoEntityByPosId(posId, nowDate);
    }
}

