SELECT 
  r.id,
  r.process_instance_id AS processInstanceId,
  r.position_code AS positionCode,
  r.position_name AS positionName,
  r.read_status AS readStatus,
  r.process_definition_name AS processDefinitionName,
  r.reject_user_name||'（'||r.reject_position_name||'）' AS createUserName,
  r.process_title AS processTitle,
  r.create_time AS createTime,
  r.pre_node_time AS preNodeTime,
  r.business_obj_id AS businessObjId
FROM ta_reject_record r
WHERE 1=1
	AND r.read_status = 0
<#if vo.assignee ?exists && vo.assignee ?length gt 0>
	AND r.position_code = '${vo.assignee}'
</#if>
<#if vo.preNodeTime ?exists && vo.preNodeTime ?length gt 0>
	AND substr(r.pre_node_time, 0, 10) = '${vo.preNodeTime}'
</#if>
ORDER BY r.create_time DESC 