/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processcheck.batchck;

import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckDetail;
import com.biz.eisp.activiti.designer.processcheck.service.TaProcessCheckService;
import com.biz.eisp.activiti.designer.processcheck.vo.TaProcessCkRecordVo;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeProEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.util.DateUtils;
import com.biz.eisp.activiti.util.EhcacheUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;

public class BatchCheckBean {
    private String userName;
    private String batchId;
    private TaProcessCkRecordVo record;
    private String proInsId;
    private List<TaProcessCheckDetail> ckDetails;
    private Map<String, Integer> isCkKey = new HashMap<String, Integer>();
    private TaProcessCheckService taProcessCheckService;
    private TmUserService tmUserService;
    private TmPositionService tmPositionService;
    private IdentityService identityService;
    private RuntimeService runtimeService;
    private RepositoryService repositoryService;
    private TaskService taskService;
    private TaProcessNodeService taProcessNodeService;

    public BatchCheckBean(String userName, String batchId) {
        this.userName = userName;
        this.batchId = batchId;
        this.record = (TaProcessCkRecordVo)EhcacheUtil.getItem("PRO_CK_" + batchId);
        this.setCkDetails();
        this.setServices();
    }

    public void setServices() {
        this.taProcessCheckService = (TaProcessCheckService)ApplicationContextUtils.getContext().getBean("taProcessCheckService");
        this.tmUserService = (TmUserService)ApplicationContextUtils.getContext().getBean("tmUserService");
        this.tmPositionService = (TmPositionService)ApplicationContextUtils.getContext().getBean("tmPositionService");
        this.identityService = (IdentityService)ApplicationContextUtils.getContext().getBean("identityService");
        this.runtimeService = (RuntimeService)ApplicationContextUtils.getContext().getBean("runtimeService");
        this.taskService = (TaskService)ApplicationContextUtils.getContext().getBean("taskService");
        this.taProcessNodeService = (TaProcessNodeService)ApplicationContextUtils.getContext().getBean("taProcessNodeService");
        this.repositoryService = (RepositoryService)ApplicationContextUtils.getContext().getBean("repositoryService");
    }

    public void checkStart() {
        boolean isSucc = true;
        try {
            TaProcessCheckDetail detail = this.passStarPro();
            this.forCheck(detail);
        }
        catch (Exception e) {
            isSucc = false;
        }
        finally {
            this.saveStopedNode(isSucc);
        }
    }

    public void saveStopedNode(boolean isSucc) {
        for (TaProcessCheckDetail detail : this.ckDetails) {
            Integer ckResult = this.isCkKey.get(detail.getNodeKey());
            if (ckResult == null) {
                detail.setCheckTime(DateUtils.getFormatDateStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
                detail.setState("3");
                String remark = "<p><span style=\"color: blue;\">\u8282\u70b9\u68c0\u6d4b\u4e2d\u65ad";
                remark = isSucc ? remark + "\uff0c\u539f\u56e0\uff1a\u672a\u81ea\u52a8\u627e\u5230\u8be5\u8282\u70b9\u4efb\u52a1\uff0c\u53ef\u80fd\u8be5\u8282\u70b9\u4e3a\u6761\u4ef6\u53c2\u6570\u7684\u5206\u652f\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u5206\u652f\u53c2\u6570\u518d\u68c0\u6d4b\uff01" : remark + "\uff0c\u539f\u56e0\uff1a\u4e2d\u9014\u8282\u70b9\u68c0\u6d4b\u5931\u8d25\uff0c\u88ab\u8feb\u4e2d\u65ad\uff01";
                remark = remark + "</span></p><p>-----------------------------------------</p>";
                detail.setCheckResult(remark);
                int done = (Integer)EhcacheUtil.getItem("PRO_CK_PG_STOP_" + this.batchId) + 1;
                EhcacheUtil.putItem("PRO_CK_PG_STOP_" + this.batchId, done);
                this.isCkKey.put(detail.getNodeKey(), 3);
                continue;
            }
            if (ckResult == 1) {
                int done = (Integer)EhcacheUtil.getItem("PRO_CK_PG_SUCC_" + this.batchId) + 1;
                EhcacheUtil.putItem("PRO_CK_PG_SUCC_" + this.batchId, done);
                continue;
            }
            int done = (Integer)EhcacheUtil.getItem("PRO_CK_PG_FAIL_" + this.batchId) + 1;
            EhcacheUtil.putItem("PRO_CK_PG_FAIL_" + this.batchId, done);
        }
    }

    public void forCheck(TaProcessCheckDetail detail) throws Exception {
        List nextTasks = this.taskService.createTaskQuery().processInstanceId(detail.getProcessInsId()).list();
        if (nextTasks.size() > 0) {
            String nextNode = ((Task)nextTasks.get(0)).getTaskDefinitionKey();
            detail.setNextNode(nextNode);
            TaProcessCheckDetail newDetail = this.passProNode(nextNode);
            this.forCheck(newDetail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaProcessCheckDetail passProNode(String nodeKey) throws Exception {
        TaProcessCheckDetail detail = this.getDetail(nodeKey);
        detail.setCheckTime(DateUtils.getFormatDateStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
        StringBuffer ckDetail = new StringBuffer();
        String oldCkResult = "";
        if (StringUtils.isNotEmpty((CharSequence)detail.getCheckResult())) {
            oldCkResult = detail.getCheckResult();
        }
        try {
            TaProcessEntity process = this.taProcessCheckService.get(TaProcessEntity.class, (Serializable)((Object)this.record.getProcessId()));
            if (process == null) {
                throw new Exception("\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f53");
            }
            List tasks = this.taskService.createTaskQuery().processInstanceId(this.proInsId).taskDefinitionKey(detail.getNodeKey()).list();
            int taskSize = tasks.size();
            ckDetail.append("<p>\u68c0\u6d4b\u51fa\u8be5\u8282\u70b9\u4ea7\u751f\u4e86" + taskSize + "\u4e2a\u4efb\u52a1</p>");
            int index = 1;
            for (Task task : tasks) {
                ckDetail.append("<p>\u5f00\u59cb\u5904\u7406\u7b2c" + index + "\u4e2a\u4efb\u52a1...</p>");
                ckDetail = this.completeTask(task, ckDetail);
                ckDetail.append("<p>\u5904\u7406\u7b2c" + index + "\u4e2a\u4efb\u52a1\u7ed3\u675f...</p>");
                ++index;
            }
            detail.setState("1");
            detail.setProcessInsId(this.proInsId);
            detail.setCheckResult(oldCkResult + ckDetail.toString() + "<p>\u8282\u70b9\u901a\u8fc7\u68c0\u6d4b\u6210\u529f!</p>");
        }
        catch (Exception e) {
            ckDetail.append("<p><span style=\"color:red\">\u8282\u70b9\u901a\u8fc7\u68c0\u6d4b\u5931\u8d25!</span></p>");
            String msg = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)msg)) {
                msg = "\u672a\u77e5\u9519\u8bef\uff0c\u65e5\u5fd7\u672a\u88ab\u6355\u83b7\u3002";
            }
            ckDetail.append("<p><span style=\"color:red\">\u9519\u8bef\u65e5\u5fd7\uff1a" + msg + "</span></p>");
            detail.setState("2");
            detail.setCheckResult(oldCkResult + ckDetail.toString());
        }
        finally {
            detail.setCheckResult(detail.getCheckResult() + "<p>-----------------------------------------</p>");
            this.isCkKey.put(detail.getNodeKey(), Integer.parseInt(detail.getState()));
            return detail;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringBuffer completeTask(Task task, StringBuffer ckDetail) throws Exception {
        boolean toComplete = true;
        String processKey = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult()).getKey();
        TaProcessNodeProEntity node = this.taProcessNodeService.getTaProcessNodeByVersionKey(task.getProcessDefinitionId(), processKey);
        if (node == null) {
            throw new RuntimeException("\u8282\u70b9\u8868\u4e2d\u672a\u627e\u5230\u8be5\u8282\u70b9\uff01");
        }
        Map variables = this.runtimeService.getVariables(task.getExecutionId());
        String proStartPosiCode = (String)variables.get("proStartPosiCode");
        TmPositionVo vo = this.getPositionVoInfo(proStartPosiCode);
        TmPositionVo currVo = null;
        if (task.getTaskDefinitionKey().equals("DEFAULT_START")) {
            ckDetail.append("<p>\u4efb\u52a1\u5904\u7406\u4eba\uff1a[" + vo.getUserName() + "]" + vo.getFullName()).append("\u3001\u804c\u4f4d[" + vo.getPositionCode() + "]" + vo.getPositionName() + "</p>");
        } else if (StringUtils.isEmpty((CharSequence)task.getAssignee())) {
            List identityLinkList = this.taskService.getIdentityLinksForTask(task.getId());
            if (!CollectionUtil.listNotEmptyNotSizeZero(identityLinkList)) throw new RuntimeException("\u8282\u70b9\u4efb\u52a1\u7684[assignee]\u5ba1\u6279\u4eba\u5b57\u6bb5\u4e3a\u7a7a\uff01");
            for (IdentityLink identityLink : identityLinkList) {
                if (!StringUtils.isNotBlank((CharSequence)identityLink.getUserId())) continue;
                currVo = this.getPositionVoInfo(identityLink.getUserId());
                if (currVo == null) {
                    throw new RuntimeException("\u6839\u636e\u4efb\u52a1\u6267\u884c\u804c\u4f4d[" + task.getAssignee() + "]\u67e5\u8be2\u804c\u4f4d\u6570\u636e\u4e3a\u7a7a\uff01");
                }
                ckDetail.append("<p>\u4efb\u52a1\u5904\u7406\u4eba\uff1a[" + currVo.getUserName() + "]" + currVo.getFullName()).append("\u3001\u804c\u4f4d[" + currVo.getPositionCode() + "]" + currVo.getPositionName() + "</p>");
            }
        } else {
            currVo = this.getPositionVoInfo(task.getAssignee());
            if (currVo == null) {
                throw new RuntimeException("\u6839\u636e\u4efb\u52a1\u6267\u884c\u804c\u4f4d[" + task.getAssignee() + "]\u67e5\u8be2\u804c\u4f4d\u6570\u636e\u4e3a\u7a7a\uff01");
            }
            ckDetail.append("<p>\u4efb\u52a1\u5904\u7406\u4eba\uff1a[" + currVo.getUserName() + "]" + currVo.getFullName()).append("\u3001\u804c\u4f4d[" + currVo.getPositionCode() + "]" + currVo.getPositionName() + "</p>");
        }
        if (!toComplete) return ckDetail;
        this.taskService.complete(task.getId());
        return ckDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaProcessCheckDetail passStarPro() throws Exception {
        TaProcessCheckDetail detail = this.getDetail("TO_START");
        String bussId = UUID.randomUUID().toString().replace("-", "");
        detail.setRecordId(this.batchId);
        detail.setCheckTime(DateUtils.getFormatDateStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
        TaProcessEntity process = this.taProcessCheckService.get(TaProcessEntity.class, (Serializable)((Object)this.record.getProcessId()));
        if (process == null) {
            throw new Exception("\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f53");
        }
        String authenticatedUser = this.userName;
        StringBuffer ckDetail = new StringBuffer();
        try {
            HashMap<String, Object> variables = this.taProcessCheckService.getCkParams(this.record.getCkParams());
            variables.put("proStartUserName", authenticatedUser);
            variables.put("FROM_TYPE", "PROCESS_PASS_CHECK");
            ckDetail.append("<p>\u53d1\u8d77\u4eba\u8d26\u53f7[" + authenticatedUser + "]\u53bb\u6267\u884c\u6d41\u7a0b\u53d1\u8d77\uff1b</p>");
            TmUserVo user = this.getUserVo(authenticatedUser);
            if (user == null) {
                ckDetail.append("<p><span style=\"color:red\">\u6839\u636e\u53d1\u8d77\u4eba\u8d26\u53f7[" + authenticatedUser + "]\u672a\u627e\u5230\u5bf9\u5e94\u7528\u6237;</span></p>");
                throw new Exception("");
            }
            TmPositionVo vo = this.getPositionVoById(user.getPositionId());
            if (vo == null) {
                ckDetail.append("<p><span style=\"color:red\">\u672a\u627e\u5230\u53d1\u8d77\u4eba\u5bf9\u5e94\u804c\u4f4d;</span></p>");
                throw new Exception("");
            }
            ckDetail.append("<p>\u53d1\u8d77\u4eba\u4fe1\u606f\uff1a[" + authenticatedUser + "]" + user.getFullName()).append("\uff0c\u804c\u4f4d[" + vo.getPositionCode() + "]" + vo.getPositionName() + "\uff1b</p>");
            variables.put("proStartPosiCode", vo.getPositionCode());
            this.identityService.setAuthenticatedUserId(authenticatedUser);
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(process.getProcessKey(), bussId, variables);
            ckDetail.append("<p>\u6210\u529f\u53d1\u8d77\u4e86\u6d41\u7a0b\uff0c\u53d1\u8d77\u68c0\u6d4b\u6210\u529f!</p>");
            detail.setState("1");
            detail.setProcessInsId(processInstance.getProcessInstanceId());
            this.proInsId = processInstance.getProcessInstanceId();
            detail.setCheckResult(ckDetail.toString());
        }
        catch (Exception e) {
            ckDetail.append("<p><span style=\"color:red\">\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25!</span></p>");
            String msg = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)msg)) {
                msg = "\u672a\u77e5\u9519\u8bef\uff0c\u65e5\u5fd7\u672a\u88ab\u6355\u83b7\u3002";
            } else if (msg.length() > 500) {
                msg = msg.substring(0, 500) + "...";
            }
            ckDetail.append("<p><span style=\"color:red\">\u9519\u8bef\u65e5\u5fd7\uff1a" + msg + "</span></p>");
            detail.setState("2");
            detail.setCheckResult(ckDetail.toString());
        }
        finally {
            detail.setCheckResult(detail.getCheckResult() + "<p>-----------------------------------------</p>");
            this.isCkKey.put("TO_START", Integer.parseInt(detail.getState()));
            return detail;
        }
    }

    public TaProcessCheckDetail getDetail(String nodeCode) {
        for (TaProcessCheckDetail detail : this.ckDetails) {
            if (!nodeCode.equals(detail.getNodeKey())) continue;
            return detail;
        }
        return null;
    }

    public List<TaProcessCheckDetail> getCkDetails() {
        return this.ckDetails;
    }

    public void setCkDetails() {
        ArrayList<TaProcessCheckDetail> details = new ArrayList<TaProcessCheckDetail>();
        for (TaProcessCheckDetail detail : this.record.getCkPassDetails()) {
            if (!this.userName.equals(detail.getUserName())) continue;
            details.add(detail);
        }
        this.ckDetails = details;
    }

    private TmPositionVo getPositionVoInfo(String positionCode) {
        if (StringUtils.isBlank((CharSequence)positionCode)) {
            throw new RuntimeException("\u672a\u4f20\u9012\u804c\u4f4d\u7f16\u7801\u4fe1\u606f");
        }
        TmPositionVo paramVo = new TmPositionVo();
        paramVo.setPositionCode(positionCode);
        List<TmPositionVo> list = this.tmPositionService.findPositionByConditions(paramVo, null);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            return list.get(0);
        }
        return null;
    }

    private TmPositionVo getPositionVoById(String id) {
        TmPositionEntity positionEntity = this.tmPositionService.get(TmPositionEntity.class, (Serializable)((Object)id));
        if (positionEntity == null) {
            return null;
        }
        return this.getPositionVoInfo(positionEntity.getPositionCode());
    }

    private TmUserVo getUserVo(String userName) {
        TmUserVo paramVo = new TmUserVo();
        paramVo.setUserName(userName);
        TmUserVo userVo = this.tmUserService.getTmUser(paramVo);
        return userVo;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }
}

