/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processcheck.batchck;

import com.biz.eisp.activiti.designer.processcheck.batchck.BatchCheckBean;
import com.biz.eisp.activiti.designer.processcheck.batchck.BatchCheckProThread;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BatchCheckProDeal {
    private static final Logger logger = Logger.getLogger(BatchCheckProDeal.class);
    public static final int SINGLE = 20;
    private int batchIndex = 0;
    private List<String> users;
    private String batchId;

    public BatchCheckProDeal(List<String> users, String batchId) {
        this.users = users;
        this.batchId = batchId;
    }

    public synchronized List<String> getUsers() {
        int startNum = this.batchIndex * 20;
        int endNum = startNum + 20;
        if (startNum >= this.users.size()) {
            return null;
        }
        endNum = endNum > this.users.size() ? this.users.size() : endNum;
        ++this.batchIndex;
        return this.users.subList(startNum, endNum);
    }

    public void execute() throws Exception {
        if (this.users == null || this.users.isEmpty()) {
            return;
        }
        int size = this.users.size() % 20 == 0 ? this.users.size() / 20 : this.users.size() / 20 + 1;
        int prcNum = Runtime.getRuntime().availableProcessors();
        size = size > prcNum ? prcNum : size;
        logger.info((Object)("\u6279\u91cf\u68c0\u6d4b\u6d41\u7a0b\u6784\u5efa\u7684\u7ebf\u7a0b\u6570\uff1a" + size));
        for (int i = 0; i < size; ++i) {
            new BatchCheckProThread(this).start();
        }
    }

    public void batchChecks(List<String> users) {
        for (int i = 0; i < users.size(); ++i) {
            String user = users.get(i);
            if (!StringUtils.isNotBlank((String)user)) continue;
            try {
                new BatchCheckBean(user, this.batchId).checkStart();
                logger.info((Object)("\u7528\u6237[" + user + "]\u5b8c\u6210\u68c0\u6d4b!"));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)("\u7528\u6237[" + user + "]\u6267\u884c\u68c0\u6d4b\u5f02\u5e38\uff1a" + e.getMessage()));
            }
        }
    }
}

