/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.designer.processconf.entity.TaActRoleEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaRoleService;
import com.biz.eisp.activiti.designer.processconf.vo.TaActRoleVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.activiti.runtime.service.TaDeploymentService;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.actrole.entity.TmActRoleEntity;
import com.biz.eisp.mdm.actrole.transformer.TmActRoleEntityToTmActRoleVo;
import com.biz.eisp.mdm.actrole.vo.TmActRoleVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.web.pojo.Client;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.RepositoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taActivitiRoleController"})
public class TaActivitiRoleController
extends BaseController {
    @Autowired
    private TaRoleService taRoleService;
    @Autowired(required=false)
    private RepositoryService repositoryService;
    @Autowired
    private TaDeploymentService taDeploymentService;

    @RequestMapping(params={"goTaActivitiRoleMain"})
    public ModelAndView goTaActivitiRoleMain() {
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taActivitiRoleMain");
    }

    @RequestMapping(params={"goTaActivitiRoleForm"})
    public ModelAndView goTaActivitiRoleForm(HttpServletRequest request) {
        String id = OConvertUtils.getString(request.getParameter("id"));
        if (StringUtil.isNotEmpty((String)id)) {
            TaActRoleEntity roleEntity = this.taRoleService.get(TaActRoleEntity.class, (Serializable)((Object)id));
            request.setAttribute("role", (Object)roleEntity);
        } else {
            TaActRoleEntity roleEntity = new TaActRoleEntity();
            roleEntity.setRoleCode("BPM_");
            request.setAttribute("role", (Object)roleEntity);
        }
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taActivitiRoleForm");
    }

    @RequestMapping(params={"findActRoleList"})
    @ResponseBody
    public DataGrid findActRoleList(TaActRoleVo taActRoleVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TaActRoleVo> roles = this.taRoleService.findActRoleList(taActRoleVo, page);
        return new DataGrid(roles, page);
    }

    @RequestMapping(params={"findTaActivitiRoleList"})
    @ResponseBody
    public void findTpUserList(TaActRoleVo taActRoleVo, HttpServletRequest request, HttpServletResponse response) {
        String posId = ResourceUtil.getString("position");
        Client client = ResourceUtil.getClient();
        TmUserEntity tmUserEntity = client.getUser();
        EuPage page = new EuPage(request);
        if (StringUtil.isNotEmpty(tmUserEntity) && Globals.Admin_Name.equalsIgnoreCase(tmUserEntity.getUserName())) {
            taActRoleVo.setPosId(null);
        } else {
            taActRoleVo.setPosId(posId);
        }
        List<TaActRoleEntity> roles = this.taRoleService.getRoleListByCurrentPosId(taActRoleVo, page);
        this.datagridReturn(response, roles, page);
    }

    @RequestMapping(params={"saveOrUpdateTaActivitiRole"})
    @ResponseBody
    public AjaxJson saveOrUpdateTpUser(HttpServletRequest request, TaActRoleVo taActRoleVo) {
        AjaxJson j = new AjaxJson();
        try {
            EuPage page = new EuPage(request);
            this.taRoleService.createTmRole(taActRoleVo, page);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"deleteTaActivitiRoleById"})
    @ResponseBody
    public AjaxJson deleteTpUserById(String id) {
        AjaxJson j = new AjaxJson();
        try {
            if (this.taRoleService.deleteTmRole(id)) {
                j.setMsg("\u5220\u9664\u89d2\u8272\u6210\u529f");
            } else {
                j.setSuccess(false);
                j.setMsg("\u8d85\u7ea7\u7ba1\u7406\u5458\u89d2\u8272\u4e0d\u80fd\u88ab\u5220\u9664");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"validFormRoleForm"})
    @ResponseBody
    public ValidForm validFormRoleForm(HttpServletRequest request, TaActRoleEntity tmRoleEntity) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        String flag = OConvertUtils.getString(request.getParameter("flag"));
        if (StringUtil.isNotEmpty((String)flag) && flag.equalsIgnoreCase("roleName")) {
            tmRoleEntity.setRoleName(param);
        }
        if (StringUtil.isNotEmpty((String)flag) && flag.equalsIgnoreCase("roleCode")) {
            tmRoleEntity.setRoleCode(param);
        }
        return this.taRoleService.validateTmRoleForm(tmRoleEntity);
    }

    @RequestMapping(params={"goTmPositionByRoleMain"})
    public ModelAndView goTmPositionByRoleMain(String roleCode, HttpServletRequest request) {
        if (StringUtil.isNotEmpty((String)roleCode)) {
            request.setAttribute("roleCode", (Object)roleCode);
        }
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taActivitiRolePositionMain");
    }

    @RequestMapping(params={"findPositionByActRoleCode"})
    @ResponseBody
    public DataGrid findPositionByActRoleCode(TmPositionVo tmPositionVo, String roleCode, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List<TmPositionVo> result = this.taRoleService.findPositionByRoleCode(tmPositionVo, roleCode, page);
        return new DataGrid(result, page);
    }

    @RequestMapping(params={"goTaProcessDefinitionMain"})
    public ModelAndView goTaProcessDefinitionMain(TmActRoleVo tmRoleVo) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taActivitiProcessDefinitionMain");
        TmActRoleEntity tmRoleEntity = this.taRoleService.get(TmActRoleEntity.class, (Serializable)((Object)tmRoleVo.getId()));
        tmRoleVo = new TmActRoleEntityToTmActRoleVo().apply(tmRoleEntity);
        view.addObject("roleCode", (Object)tmRoleVo.getRoleCode());
        view.addObject("pdId", (Object)tmRoleVo.getId());
        return view;
    }

    @RequestMapping(params={"findTaProcessDefinitionMain"})
    @ResponseBody
    public DataGrid findTaProcessDefinitionMain(TaProcessVo taProcessVo, String roleCode, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TaProcessVo> list = this.taDeploymentService.findTaProcessVoList(taProcessVo, roleCode, page);
        return new DataGrid(list, page);
    }

    @RequestMapping(params={"goShowProcessDefinitionImage"})
    public ModelAndView goShowProcessDefinitionImage(String proId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taActivitiProcessDefinitionImage");
        view.addObject("proId", (Object)proId);
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(params={"findProcessDefinitionImage"})
    public void findProcessDefinitionImage(String proId, HttpServletResponse response) {
        response.setContentType("image/jpeg");
        InputStream is = null;
        OutputStream os = null;
        try {
            is = this.repositoryService.getProcessDiagram(proId);
            os = response.getOutputStream();
            int len = 0;
            byte[] b = new byte[1024];
            while ((len = is.read(b, 0, 1024)) != -1) {
                response.getOutputStream().write(b, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

