/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.core.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.common.service.TbAttachmentExtendsService;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.bean.TreeGridModel;
import com.biz.eisp.base.common.tag.util.oConvertUtils;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TagUtil;
import com.biz.eisp.base.core.dao.BaseDao;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.base.utils.FileUtils;
import com.biz.eisp.base.utils.FreemarkerParseUtils;
import com.biz.eisp.base.utils.PinyinUtil;
import com.biz.eisp.base.utils.UploadFile;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.entity.TmLogEntity;
import com.biz.eisp.log.vo.OperationType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="baseService")
@Transactional
public class BaseServiceImpl
implements BaseService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    @Qualifier(value="jdbcTemplate")
    private JdbcTemplate jdbcTemplate;

    @Override
    public Session getSession() {
        return this.baseDao.getSession();
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public <T> Serializable save(T entity) {
        return this.baseDao.save(entity);
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        this.baseDao.saveOrUpdate(entity);
    }

    @Override
    public <T> void batchSave(List<T> entities) {
        this.baseDao.batchSave(entities);
    }

    @Override
    public <T> void delete(T entity) {
        this.baseDao.delete(entity);
    }

    @Override
    public <T> void deleteEntityById(Class<T> clazz, Serializable id) {
        this.baseDao.deleteEntityById(clazz, id);
    }

    @Override
    public <T> void deleteAllEntity(Collection<T> entities) {
        this.baseDao.deleteAllEntity(entities);
    }

    @Override
    public <T> void updateEntity(T entity) {
        this.baseDao.updateEntity(entity);
    }

    @Override
    public <T> T get(Class<T> clazz, Serializable id) {
        return this.baseDao.get(clazz, id);
    }

    @Override
    public <T> List<T> findByProperty(Class<T> clazz, String propertyName, Object value) {
        return this.baseDao.findByProperty(clazz, propertyName, value);
    }

    @Override
    public <T> List<T> findByPropertyisOrder(Class<T> clazz, String propertyName, Object value, boolean isAsc, String isAscForpropertyName) {
        return this.baseDao.findByPropertyisOrder(clazz, propertyName, value, isAsc, isAscForpropertyName);
    }

    @Override
    public <T> T findUniqueByProperty(Class<T> clazz, String propertyName, Object value) {
        return this.baseDao.findUniqueByProperty(clazz, propertyName, value);
    }

    @Override
    public <T> List<T> loadAll(Class<T> clazz) {
        return this.baseDao.loadAll(clazz);
    }

    @Override
    public Integer executeSql(String sql, Object ... params) {
        return this.baseDao.executeSql(sql, params);
    }

    @Override
    public Long getCountForJdbcParam(String sql, Object ... params) {
        return this.baseDao.getCountForJdbcParam(sql, params);
    }

    @Override
    public List<Map<String, Object>> findForMapList(String sql, Object ... objs) {
        return this.baseDao.findForMapList(sql, objs);
    }

    @Override
    public Map<String, Object> findForMap(String sql, Object ... objs) {
        return this.baseDao.findForMap(sql, objs);
    }

    @Override
    public <T> List<T> findByHql(String hql, Page page, Object ... params) {
        return this.baseDao.findByHql(hql, page, params);
    }

    @Override
    public <T> List<T> findByHql(String hql, Object ... params) {
        return this.baseDao.findByHql(hql, params);
    }

    @Override
    public <T> T getUniqueByHql(Class<T> clazz, String hql, Object ... params) {
        return this.baseDao.getUniqueByHql(clazz, hql, params);
    }

    @Override
    public <T> List<T> findBySql(Class<T> clazz, String sql, Page page, Object ... params) {
        return this.baseDao.findBySql(clazz, sql, page, params);
    }

    @Override
    public <T> List<T> findBySql(Class<T> clazz, String sql, Object ... params) {
        return this.baseDao.findBySql(clazz, sql, params);
    }

    @Override
    public <T> T getUniqueBySql(Class<T> clazz, String sql, Object ... params) {
        return this.baseDao.getUniqueBySql(clazz, sql, params);
    }

    @Override
    public <T> List<T> findByCriteria(Class<T> clazz, boolean isAsc, String isAscForpropertyName, Criterion ... criterions) {
        return this.baseDao.findByCriteria(clazz, isAsc, isAscForpropertyName, criterions);
    }

    @Override
    public <T> List<T> findByCriteria(Class<T> clazz, Criterion ... criterions) {
        return this.baseDao.findByCriteria(clazz, criterions);
    }

    @Override
    public void updateBySql(String sql, Object ... param) {
        this.baseDao.updateBySql(sql, param);
    }

    @Override
    public <T> List<T> findByCriteria(Class<T> clazz, Page page, List<Criterion> criterions) {
        return this.baseDao.findByCriteria(clazz, page, criterions);
    }

    @Override
    public List<TreeGrid> treegrid(List all, TreeGridModel treeGridModel) {
        ArrayList<TreeGrid> treegrid = new ArrayList<TreeGrid>();
        for (Object obj : all) {
            List childList;
            Object icon;
            ReflectHelper reflectHelper = new ReflectHelper(obj);
            TreeGrid tg = new TreeGrid();
            String id = OConvertUtils.getString(reflectHelper.getMethodValue(treeGridModel.getIdField()));
            String src = OConvertUtils.getString(reflectHelper.getMethodValue(treeGridModel.getSrc()));
            String text = OConvertUtils.getString(reflectHelper.getMethodValue(treeGridModel.getTextField()));
            if (StringUtil.isNotEmpty((String)treeGridModel.getCode())) {
                String code = OConvertUtils.getString(reflectHelper.getMethodValue(treeGridModel.getCode()));
                tg.setCode(code);
            }
            if (StringUtil.isNotEmpty((String)treeGridModel.getOrder())) {
                String order = OConvertUtils.getString(reflectHelper.getMethodValue(treeGridModel.getOrder()));
                tg.setOrder(order);
            }
            tg.setId(id);
            tg.setSrc(src);
            tg.setText(text);
            if (treeGridModel.getParentId() != null) {
                Object pid = TagUtil.fieldNametoValues(treeGridModel.getParentId(), obj);
                if (pid != null) {
                    tg.setParentId(pid.toString());
                } else {
                    tg.setParentId("");
                }
            }
            if (treeGridModel.getIcon() != null && (icon = TagUtil.fieldNametoValues(treeGridModel.getIcon(), obj)) != null) {
                tg.setIcon(icon.toString());
            }
            if (treeGridModel.getParentText() != null) {
                Object ptext = TagUtil.fieldNametoValues(treeGridModel.getTextField(), obj);
                if (ptext != null) {
                    tg.setParentText(ptext.toString());
                } else {
                    tg.setParentText("");
                }
            }
            if ((childList = (List)reflectHelper.getMethodValue(treeGridModel.getChildList())) != null && childList.size() > 0) {
                tg.setState("closed");
            }
            if (treeGridModel.getFieldMap() != null) {
                tg.setFieldMap(new HashMap<String, Object>());
                for (Map.Entry<String, Object> entry : treeGridModel.getFieldMap().entrySet()) {
                    Object fieldValue = reflectHelper.getMethodValue(entry.getValue().toString());
                    tg.getFieldMap().put(entry.getKey(), fieldValue);
                }
            }
            treegrid.add(tg);
        }
        return treegrid;
    }

    @Override
    public List<ComboTree> comboTree(List all, ComboTreeModel comboTreeModel, List in, boolean recursive) {
        ArrayList<ComboTree> trees = new ArrayList<ComboTree>();
        for (Object obj : all) {
            trees.add(this.comboTree(obj, comboTreeModel, in, recursive));
        }
        all.clear();
        return trees;
    }

    public ComboTree comboTree(Object obj, ComboTreeModel comboTreeModel, List in, boolean recursive) {
        List curChildList;
        ComboTree tree = new ComboTree();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        ReflectHelper reflectHelper = new ReflectHelper(obj);
        String id = OConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getIdField()));
        tree.setId(id);
        tree.setText(OConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getTextField())));
        if (comboTreeModel.getSrcField() != null) {
            attributes.put("href", OConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getSrcField())));
            tree.setAttributes(attributes);
        }
        if (in != null && in.size() > 0) {
            for (Object inobj : in) {
                ReflectHelper reflectHelper2 = new ReflectHelper(inobj);
                String inId = OConvertUtils.getString(reflectHelper2.getMethodValue(comboTreeModel.getIdField()));
                if (!inId.equals(id)) continue;
                tree.setChecked(true);
            }
        }
        if ((curChildList = (List)reflectHelper.getMethodValue(comboTreeModel.getChildField())) != null && curChildList.size() > 0) {
            tree.setState("closed");
            tree.setChecked(false);
            if (recursive) {
                ArrayList<ComboTree> children = new ArrayList<ComboTree>();
                ArrayList nextChildList = new ArrayList(curChildList);
                for (Object childObj : nextChildList) {
                    ComboTree t = this.comboTree(childObj, comboTreeModel, in, recursive);
                    children.add(t);
                }
                tree.setChildren(children);
            }
            curChildList.clear();
        }
        return tree;
    }

    @Override
    public List<ComboBox> comboBoxByDict(String dictTypeCode) {
        String sql = "select dict_code value,dict_value text  from tm_dict_data where dict_type_code=?";
        return this.findBySql(ComboBox.class, sql, dictTypeCode);
    }

    @Override
    public void addLog(OperationType operationType, String businessDesc, String businessId, String logContent) {
        TmLogEntity tmLogEntity = new TmLogEntity();
        tmLogEntity.setContent(logContent);
        tmLogEntity.setOperationType(operationType.toString());
        tmLogEntity.setBusinessId(businessId);
        tmLogEntity.setBusinessDesc(businessDesc);
        tmLogEntity.setPositionName(ResourceUtil.getCurrPosition().getPositionName());
        this.save(tmLogEntity);
    }

    @Override
    public List<ComboTree> findComboTreeByAll(List<?> list, ComboTreeModel comboTreeModel, List<?> in, ComboTreeModel intreeModel) {
        ArrayList<ComboTree> treeJsons = new ArrayList<ComboTree>();
        for (int i = 0; i < list.size(); ++i) {
            ComboTree tsJson2 = new ComboTree();
            ReflectHelper reflectHelper = new ReflectHelper(list.get(i));
            String ids = oConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getIdField()));
            String pids = oConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getChildField()));
            String texts = oConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getTextField()));
            tsJson2.setId(ids);
            tsJson2.setPid(pids);
            tsJson2.setText(texts);
            treeJsons.add(tsJson2);
        }
        this.sortObjects(treeJsons);
        return this.formatTree(treeJsons, in, intreeModel);
    }

    protected void sortObjects(List<ComboTree> treeJsons) {
        Collections.sort(treeJsons, new Comparator<ComboTree>(){

            @Override
            public int compare(ComboTree a, ComboTree b) {
                String one = a.getId();
                String two = b.getId();
                return one.compareTo(two);
            }
        });
    }

    public List<ComboTree> formatTree(List<ComboTree> list, List<?> in, ComboTreeModel intreeModel) {
        ComboTree root = new ComboTree();
        ComboTree node = new ComboTree();
        ArrayList<ComboTree> treelist = new ArrayList<ComboTree>();
        ArrayList<ComboTree> parentnodes = new ArrayList<ComboTree>();
        if (list != null && list.size() > 0) {
            root = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                node = list.get(i);
                if (node.getPid().equals(root.getId())) {
                    parentnodes.add(node);
                    root.getChildren().add(node);
                    continue;
                }
                this.getChildrenNodes(parentnodes, node, in, intreeModel);
                parentnodes.add(node);
            }
        }
        treelist.add(root);
        return treelist;
    }

    private void getChildrenNodes(List<ComboTree> parentnodes, ComboTree node, List<?> in, ComboTreeModel intreeModel) {
        if (in != null && in.size() > 0) {
            for (Object inobj : in) {
                ReflectHelper reflectHelperIn = new ReflectHelper(inobj);
                String inId = oConvertUtils.getString(reflectHelperIn.getMethodValue(intreeModel.getChildField()));
                if (!StringUtil.isNotBlank((String)inId) || !inId.equals(node.getId())) continue;
                node.setChecked(true);
            }
        }
        for (int i = parentnodes.size() - 1; i >= 0; --i) {
            ComboTree pnode = parentnodes.get(i);
            if (!pnode.getId().equals(node.getPid())) continue;
            pnode.setState("closed");
            pnode.getChildren().add(node);
            return;
        }
    }

    @Override
    public Object uploadFile(UploadFile uploadFile) {
        return this.uploadFile(uploadFile, null, null);
    }

    @Override
    public Object uploadFile(UploadFile uploadFile, String extendServiceName, String businessKey) {
        Object object = uploadFile.getObject();
        if (uploadFile.getFileKey() != null) {
            this.updateEntity(object);
        } else {
            try {
                String entityName;
                uploadFile.getMultipartRequest().setCharacterEncoding("UTF-8");
                MultipartHttpServletRequest multipartRequest = uploadFile.getMultipartRequest();
                ReflectHelper reflectHelper = new ReflectHelper(uploadFile.getObject());
                String uploadbasepath = uploadFile.getBasePath();
                if (uploadbasepath == null) {
                    uploadbasepath = ResourceUtil.getSysConfigProperty("uploadpath");
                }
                Map fileMap = multipartRequest.getFileMap();
                String path = uploadbasepath + "/";
                String realPath = ResourceUtil.getSysConfigProperty("basePath");
                File templateFile = new File(realPath);
                realPath = !templateFile.exists() && !templateFile.isDirectory() ? uploadFile.getMultipartRequest().getSession().getServletContext().getRealPath("/") + "/" + path : realPath + "/" + path;
                File file = new File(realPath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (uploadFile.getCusPath() != null) {
                    realPath = realPath + uploadFile.getCusPath() + "/";
                    path = path + uploadFile.getCusPath() + "/";
                    file = new File(realPath);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                } else {
                    realPath = realPath + DateUtils.getDataString(DateUtils.yyyyMMdd) + "/";
                    path = path + DateUtils.getDataString(DateUtils.yyyyMMdd) + "/";
                    file = new File(realPath);
                    if (!file.exists()) {
                        file.mkdir();
                    }
                }
                if ((entityName = uploadFile.getObject().getClass().getSimpleName()).equals("TbTemplate")) {
                    realPath = uploadFile.getMultipartRequest().getSession().getServletContext().getRealPath("/") + ResourceUtil.getSysConfigProperty("templatepath") + "/";
                    path = ResourceUtil.getSysConfigProperty("templatepath") + "/";
                } else if (entityName.equals("TbIcon")) {
                    realPath = uploadFile.getMultipartRequest().getSession().getServletContext().getRealPath("/") + uploadFile.getCusPath() + "/";
                    path = uploadFile.getCusPath() + "/";
                }
                String fileName = "";
                String swfName = "";
                for (Map.Entry entity : fileMap.entrySet()) {
                    MultipartFile mf = (MultipartFile)entity.getValue();
                    fileName = mf.getOriginalFilename();
                    swfName = PinyinUtil.getPinYinHeadChar(OConvertUtils.replaceBlank(FileUtils.getFilePrefix(fileName)));
                    String extend = FileUtils.getExtend(fileName);
                    String myfilename = "";
                    String noextfilename = "";
                    if (uploadFile.isRename()) {
                        noextfilename = DateUtils.getDataString(DateUtils.yyyymmddhhmmss) + StringUtil.random(8);
                        myfilename = noextfilename + "." + extend;
                    } else {
                        myfilename = fileName;
                    }
                    String savePath = realPath + myfilename;
                    String fileprefixName = FileUtils.getFilePrefix(fileName);
                    if (uploadFile.getTitleField() != null) {
                        reflectHelper.setMethodValue(uploadFile.getTitleField(), fileprefixName);
                    }
                    if (uploadFile.getExtend() != null) {
                        reflectHelper.setMethodValue(uploadFile.getExtend(), extend);
                    }
                    if (uploadFile.getByteField() != null) {
                        // empty if block
                    }
                    File savefile = new File(savePath);
                    if (uploadFile.getRealPath() != null) {
                        reflectHelper.setMethodValue(uploadFile.getRealPath(), path + myfilename);
                    }
                    if (uploadFile.getFileName() != null) {
                        if (uploadFile.isRename()) {
                            reflectHelper.setMethodValue(uploadFile.getFileName(), noextfilename);
                        } else {
                            reflectHelper.setMethodValue(uploadFile.getFileName(), fileName);
                        }
                    }
                    this.saveOrUpdate(object);
                    if (StringUtils.hasText((String)extendServiceName)) {
                        TbAttachmentExtendsService tbAttachmentExtendsService = (TbAttachmentExtendsService)ApplicationContextUtils.getContext().getBean(extendServiceName, TbAttachmentExtendsService.class);
                        tbAttachmentExtendsService.savePostProcessor(businessKey);
                    }
                    if ("txt".equals(extend)) {
                        this.copyToDisk(mf, savePath);
                    } else {
                        FileCopyUtils.copy((byte[])mf.getBytes(), (File)savefile);
                    }
                    if (uploadFile.getSwfpath() == null) continue;
                    reflectHelper.setMethodValue(uploadFile.getSwfpath(), path + FileUtils.getFilePrefix(myfilename) + ".swf");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BusinessException("\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25");
            }
        }
        return object;
    }

    private void copyToDisk(MultipartFile mf, String savePath) {
        try {
            byte[] allbytes = mf.getBytes();
            String head1 = this.toHexString(allbytes[0]);
            String head2 = this.toHexString(allbytes[1]);
            if ("ef".equals(head1) && "bb".equals(head2)) {
                String contents = new String(mf.getBytes(), "UTF-8");
                if (StringUtil.isNotBlank((String)contents)) {
                    FileOutputStream out = new FileOutputStream(savePath);
                    ((OutputStream)out).write(contents.getBytes());
                    ((OutputStream)out).close();
                }
            } else {
                String contents = new String(mf.getBytes(), "GBK");
                FileOutputStream out = new FileOutputStream(savePath);
                ((OutputStream)out).write(contents.getBytes());
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            try {
                String contents = new String(mf.getBytes(), "UTF-8");
                if (StringUtil.isNotBlank((String)contents)) {
                    FileOutputStream out = new FileOutputStream(savePath);
                    ((OutputStream)out).write(contents.getBytes());
                    ((OutputStream)out).close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private String toHexString(int index) {
        String hexString = Integer.toHexString(index);
        hexString = hexString.substring(hexString.length() - 2);
        return hexString;
    }

    @Override
    public String generateTreeSubCode(Integer codeLength, String tableName, String parentId) {
        String newSubCode = "";
        if (!StringUtils.hasText((String)parentId)) {
            String sql = "select max(t.sub_code) subCode from " + tableName + " t where t.parent_id is null";
            Map<String, Object> pCodeMap = this.baseDao.findForMap(sql, new Object[0]);
            if (pCodeMap.get("subCode") != null) {
                String subCode = pCodeMap.get("subCode").toString();
                newSubCode = String.format("%0" + codeLength + "d", Integer.valueOf(subCode) + 1);
            } else {
                newSubCode = String.format("%0" + codeLength + "d", 1);
            }
        } else {
            String sql = "select max(t.sub_code) subCode from " + tableName + " t where t.parent_id = ?";
            Map<String, Object> subCodeMap = this.baseDao.findForMap(sql, parentId);
            if (subCodeMap.get("subCode") != null) {
                String currCode = subCodeMap.get("subCode").toString();
                String pSubCode = currCode.substring(0, currCode.length() - codeLength);
                String subCode = currCode.substring(currCode.length() - codeLength, currCode.length());
                newSubCode = pSubCode + String.format("%0" + codeLength + "d", Integer.valueOf(subCode) + 1);
            } else {
                String parentCodeSql = "select max(t.sub_code) subCode from " + tableName + " t where t.id = ?";
                Map<String, Object> pCodeMap = this.baseDao.findForMap(parentCodeSql, parentId);
                String currCode = pCodeMap.get("subCode").toString();
                newSubCode = currCode + String.format("%0" + codeLength + "d", 1);
            }
        }
        return newSubCode;
    }

    @Override
    public void updateIsLeafColumn(String tableName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", tableName);
        params.put("isLeaf", 1);
        String isLeafSql_1 = new FreemarkerParseUtils().parseTemplate("com/biz/eisp/base/core/service/impl/updateIsLeafColumnSql.ftl", params);
        params.put("isLeaf", 0);
        String isLeafSql_0 = new FreemarkerParseUtils().parseTemplate("com/biz/eisp/base/core/service/impl/updateIsLeafColumnSql.ftl", params);
        this.baseDao.executeSql(isLeafSql_1, new Object[0]);
        this.baseDao.executeSql(isLeafSql_0, new Object[0]);
    }

    @Override
    public void updateAllIsLeafColumn(String tableName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", tableName);
        params.put("isLeaf", 1);
        String isLeafSql_1 = new FreemarkerParseUtils().parseTemplate("com/biz/eisp/base/core/service/impl/updateAllIsLeafColumnSql.ftl", params);
        params.put("isLeaf", 0);
        String isLeafSql_0 = new FreemarkerParseUtils().parseTemplate("com/biz/eisp/base/core/service/impl/updateAllIsLeafColumnSql.ftl", params);
        this.baseDao.executeSql(isLeafSql_1, new Object[0]);
        this.baseDao.executeSql(isLeafSql_0, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServletResponse viewOrDownloadFile(UploadFile uploadFile) {
        uploadFile.getResponse().setContentType("UTF-8");
        uploadFile.getResponse().setCharacterEncoding("UTF-8");
        InputStream bis = null;
        BufferedOutputStream bos = null;
        HttpServletResponse response = uploadFile.getResponse();
        HttpServletRequest request = uploadFile.getRequest();
        String ctxPath = request.getSession().getServletContext().getRealPath("/");
        if (StringUtil.isNotBlank((String)ResourceUtil.getSysConfigProperty("basePath"))) {
            ctxPath = ResourceUtil.getSysConfigProperty("basePath") + "/";
        }
        String downLoadPath = "";
        long fileLength = 0L;
        if (uploadFile.getRealPath() != null && uploadFile.getContent() == null) {
            downLoadPath = ctxPath + uploadFile.getRealPath();
            fileLength = new File(downLoadPath).length();
            try {
                bis = new BufferedInputStream(new FileInputStream(downLoadPath));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            if (uploadFile.getContent() != null) {
                bis = new ByteArrayInputStream(uploadFile.getContent());
            }
            fileLength = uploadFile.getContent().length;
        }
        try {
            int bytesRead;
            if (!uploadFile.isView() && uploadFile.getExtend() != null) {
                if (uploadFile.getExtend().equals("text")) {
                    response.setContentType("text/plain;");
                } else if (uploadFile.getExtend().equals("doc")) {
                    response.setContentType("application/msword;");
                } else if (uploadFile.getExtend().equals("xls")) {
                    response.setContentType("application/ms-excel;");
                } else if (uploadFile.getExtend().equals("pdf")) {
                    response.setContentType("application/pdf;");
                } else if (uploadFile.getExtend().equals("jpg") || uploadFile.getExtend().equals("jpeg")) {
                    response.setContentType("image/jpeg;");
                } else {
                    response.setContentType("application/x-msdownload;");
                }
                response.setHeader("Content-disposition", "attachment; filename=" + new String((uploadFile.getTitleField() + "." + uploadFile.getExtend()).getBytes("GBK"), "ISO8859-1"));
                response.setHeader("Content-Length", String.valueOf(fileLength));
            }
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return response;
    }

    @Override
    public void addLogAndRemoveInvalidInfo(String relationId, Object relationObj, String updateToBusinessId, String logContent, String operationType) {
        if (StringUtil.isEmpty(logContent)) {
            logContent = ((Loggerable)relationObj).updateLogContent(null);
        }
        String businessDesc = ((Loggerable)relationObj).businessDesc();
        TmLogEntity tmLogEntity = new TmLogEntity();
        tmLogEntity.setContent(logContent);
        tmLogEntity.setOperationType(operationType);
        tmLogEntity.setBusinessId(updateToBusinessId);
        tmLogEntity.setBusinessDesc(businessDesc);
        tmLogEntity.setPositionName(ResourceUtil.getSessionTmUserVo().getPositionName());
        this.save(tmLogEntity);
        String hql1 = "from TmLogEntity where businessId=?";
        List logList = this.findByHql(hql1, relationId);
        for (TmLogEntity logEntity : logList) {
            logEntity.setBusinessId(updateToBusinessId);
            this.updateEntity(logEntity);
        }
    }

    @Override
    public void addLogAndRemoveInvalidInfo(String relationId, Object relationObj, String updateToBusinessId, String logContent) {
        this.addLogAndRemoveInvalidInfo(relationId, relationObj, updateToBusinessId, logContent, "DELETE");
    }

    @Override
    public int callableStatementByName(String proc, List<String> list) {
        return this.baseDao.callableStatementByName(proc, list);
    }
}

