/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.listener.task;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.task.IdentityLink;

public class ParentPositionListener
implements TaskListener {
    private static final long serialVersionUID = 1L;
    private TmActRoleService tmActRoleService = (TmActRoleService)ApplicationContextUtils.getContext().getBean("tmActRoleService");

    public void notify(DelegateTask delegateTask) {
        Set identityLinkList = delegateTask.getCandidates();
        for (IdentityLink id : identityLinkList) {
            TmPositionEntity tp;
            TmPositionEntity parentPostion;
            String actRoleCode = id.getGroupId();
            String submitPositionId = (String)delegateTask.getVariable("submitPositionId");
            if (StringUtil.isEmpty(submitPositionId)) {
                submitPositionId = ResourceUtil.getCurrPosition().getId();
            }
            if ((parentPostion = (tp = this.tmActRoleService.get(TmPositionEntity.class, (Serializable)((Object)submitPositionId))).getTmPosition()) == null) {
                throw new BusinessException("\u8bf7\u914d\u7f6e\u4f60\u7684\u4e0a\u7ea7\u804c\u4f4d");
            }
            String parent = parentPostion.getId();
            List<TmPositionVo> voList = this.tmActRoleService.findParentPositionList(actRoleCode, parent);
            if (voList != null) {
                if (voList.size() == 1) {
                    delegateTask.setAssignee(voList.get(0).getPositionCode());
                    continue;
                }
                for (TmPositionVo vo : voList) {
                    delegateTask.addCandidateUser(vo.getPositionCode());
                }
                continue;
            }
            throw new BusinessException("\u672a\u627e\u5230\u5ba1\u6279\u804c\u4f4d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
    }
}

