/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.dict.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;
import com.biz.eisp.mdm.dict.service.TmDictTypeService;
import com.biz.eisp.mdm.dict.vo.DictTreeGrid;
import java.io.Serializable;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmDictTypeService")
@Transactional
public class TmDictTypeServiceImpl
extends BaseServiceImpl
implements TmDictTypeService {
    @Override
    public void deleteDictType(String id) {
        TmDictTypeEntity t = super.get(TmDictTypeEntity.class, (Serializable)((Object)id));
        List<TmDictDataEntity> tdds = super.findByProperty(TmDictDataEntity.class, "tmDictType", t);
        if (tdds != null && tdds.size() > 0) {
            throw new BusinessException("\u8981\u5220\u9664\u7684\u5bf9\u8c61\uff0c\u8fd8\u6709\u5b50\u5bf9\u8c61\u4e0d\u80fd\u5220\u9664");
        }
        super.delete(t);
    }

    @Override
    public TmDictTypeEntity get(String id) {
        return super.get(TmDictTypeEntity.class, (Serializable)((Object)id));
    }

    @Override
    public List<TmDictTypeEntity> list() {
        String hql = "from TmDictTypeEntity";
        return super.findByHql(hql, new Object[0]);
    }

    @Override
    public void saveAndUpdate(DictTreeGrid dictTreegrid) {
        TmDictTypeEntity dictType = null;
        String id = dictTreegrid.getId().split("_")[0];
        if (id == null || "".equals(id)) {
            dictType = dictTreegrid.getDictType();
            dictType.setId(null);
            this.saveOrUpdate(dictType);
        } else {
            TmDictTypeEntity t = this.get(TmDictTypeEntity.class, (Serializable)((Object)id));
            if (t == null) {
                throw new BusinessException("\u4fee\u6539\u7684\u5bf9\u8c61\u5df2\u7ecf\u4e0d\u5b58\u5728");
            }
            dictType = dictTreegrid.getDictType();
            t.setId(dictType.getId());
            t.setDictDesc(dictType.getDictDesc());
            t.setDictTypeName(dictType.getDictTypeName());
            t.setDictTypeCode(dictType.getDictTypeCode());
            this.saveOrUpdate(t);
            String oldTypeCode = t.getDictTypeCode();
            SimpleExpression cr = Restrictions.eq((String)"tmDictType", (Object)this.getDictTypeEntity(oldTypeCode));
            List<TmDictDataEntity> dicts = this.findByCriteria(TmDictDataEntity.class, new Criterion[]{cr});
            for (TmDictDataEntity ty : dicts) {
                ty.setTmDictType(t);
                this.saveOrUpdate(ty);
            }
        }
    }

    private TmDictTypeEntity getDictTypeEntity(String dictTypeCode) {
        SimpleExpression cr1 = Restrictions.eq((String)"dictTypeCode", (Object)dictTypeCode);
        List<TmDictTypeEntity> dictType = this.findByCriteria(TmDictTypeEntity.class, new Criterion[]{cr1});
        if (CollectionUtils.isEmpty(dictType)) {
            throw new BusinessException("\u6570\u636e\u5b57\u5178\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        return dictType.get(0);
    }
}

