/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.system.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ComboxTreeUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.dict.dao.TmDictDao;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import com.biz.eisp.mdm.dict.vo.TmDictTypeVo;
import com.biz.eisp.mdm.org.dao.TmOrgDao;
import com.biz.eisp.mdm.org.util.TmOrgTreeUtil;
import com.biz.eisp.mdm.system.service.InitListenerService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="initListenerService")
@Transactional
public class InitListenerServiceImpl
extends BaseServiceImpl
implements InitListenerService {
    @Autowired
    private TmOrgDao tmOrgDao;
    @Autowired
    private IRedisCacheService redisCacheService;
    @Autowired
    private TmDictDao tmDictDao;

    @Override
    public void initAllTypeGroups() {
        List<TmDictTypeVo> typeGroups = this.tmDictDao.getDictTypeVoList(new TmDictTypeVo());
        DictUtil.versionMap.put(DictUtil.dict_version, this.redisCacheService.incrBy(DictUtil.dict_version, 0L));
        for (TmDictTypeVo dictTypeEntity : typeGroups) {
            DictUtil.allDictType.put(dictTypeEntity.getDictTypeCode(), dictTypeEntity);
            try {
                this.redisCacheService.setMap(DictUtil.dict_json_type, dictTypeEntity.getDictTypeCode(), dictTypeEntity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TmDictTypeVo vo = new TmDictTypeVo();
            vo.setDictTypeCode(dictTypeEntity.getDictTypeCode());
            List<TmDictDataVo> list = this.tmDictDao.getDictDataVoList(vo);
            if (!CollectionUtil.listNotEmptyNotSizeZero(list)) continue;
            DictUtil.allDictData.put(dictTypeEntity.getDictTypeCode(), list);
            try {
                for (int i = 0; i < list.size(); ++i) {
                    this.redisCacheService.setMap(DictUtil.dict_json_data + dictTypeEntity.getDictTypeCode(), list.get(i).getDictCode(), list.get(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void initAllTableColumns() {
        String sql = "select table_Name from tm_mdm_table_config group by table_Name ";
        List<Map<String, Object>> list = this.findForMapList(sql, new Object[0]);
        for (Map<String, Object> map : list) {
            String tableName = (String)map.get("table_Name");
            List<TmMdmTableConfigEntity> tableColumns = this.findByPropertyisOrder(TmMdmTableConfigEntity.class, "tableName", tableName, true, "columnOrder");
            ArrayList<TmMdmTableConfigEntity> tableConfigImp = new ArrayList<TmMdmTableConfigEntity>();
            HashMap<String, TmMdmTableConfigEntity> allFieldEntity = new HashMap<String, TmMdmTableConfigEntity>();
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            HashMap<String, String> clounmMap = new HashMap<String, String>();
            HashMap<String, String> cloumnDictTypeMap = new HashMap<String, String>();
            for (TmMdmTableConfigEntity tableColumn : tableColumns) {
                allFieldEntity.put(tableColumn.getField(), tableColumn);
                if (StringUtil.isNotEmpty((String)tableColumn.getDictType())) {
                    cloumnDictTypeMap.put(tableColumn.getField(), tableColumn.getDictType());
                }
                String columnDesc = StringUtil.isNotEmpty((String)tableColumn.getFieldName()) ? tableColumn.getFieldName() : tableColumn.getColumnDesc();
                clounmMap.put(tableColumn.getField(), columnDesc);
                fieldMap.put(tableColumn.getColumnName(), columnDesc);
                if (StringUtil.isNotEmpty(tableColumn.getImportOut())) {
                    String keyName = tableColumn.getTableName() + tableColumn.getField();
                    if (StringUtil.isNotEmpty((String)tableColumn.getFieldProperty())) {
                        keyName = tableColumn.getTableName() + tableColumn.getFieldProperty();
                    }
                    DynamicConfigUtil.allTableConfigByField.put(keyName.toLowerCase(), tableColumn);
                }
                if (!StringUtil.isNotEmpty(tableColumn.getAddShowMode()) || tableColumn.getAddShowMode() != 1) continue;
                tableConfigImp.add(tableColumn);
            }
            DynamicConfigUtil.allTableConfigEntity.put(tableName, allFieldEntity);
            DynamicConfigUtil.allTableConfigDictColumn.put(tableName, cloumnDictTypeMap);
            DynamicConfigUtil.allTableConfigField.put(tableName, fieldMap);
            DynamicConfigUtil.allTableConfigColumn.put(tableName, clounmMap);
            DynamicConfigUtil.allTableConfig.put(tableName.toLowerCase(), tableColumns);
            DynamicConfigUtil.allTableConfigImpColumn.put(tableName, tableConfigImp);
        }
    }

    @Override
    public void initDepart() {
        List<Object> comboTrees = new ArrayList();
        List<ComboTree> orgVos = this.tmOrgDao.findComboTree();
        try {
            ComboxTreeUtil.currMap.clear();
            for (ComboTree obj : orgVos) {
                this.redisCacheService.setMap(ComboxTreeUtil.comboxTag, obj.getId(), obj);
            }
            comboTrees = TmOrgTreeUtil.buildTree(orgVos);
            ComboxTreeUtil.versionMap.put(ComboxTreeUtil.comboxTag_version, this.redisCacheService.incrBy(ComboxTreeUtil.comboxTag_version, 0L));
            ComboxTreeUtil.currMap.put(ComboxTreeUtil.comboxTag, comboTrees);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void refleshDepart(String orgId, String parentId, String departname, int type) {
        try {
            if (StringUtil.isNotEmpty((String)orgId) && StringUtil.isNotEmpty((String)departname)) {
                ComboTree tp = new ComboTree();
                tp.setId(orgId);
                tp.setText(departname);
                tp.setPid(parentId);
                if (type == 3) {
                    this.redisCacheService.removeMap(ComboxTreeUtil.comboxTag, orgId);
                } else {
                    this.redisCacheService.setMap(ComboxTreeUtil.comboxTag, orgId, tp);
                }
                this.redisCacheService.incrBy(ComboxTreeUtil.comboxTag_version, 1L);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u66f4\u65b0\u7f13\u5b58\u5931\u8d25");
        }
    }
}

