/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.terminal.service;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.generatednum.num.util.TbNumRuleProvider;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGEntity;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.service.TmTermCustPostService;
import com.biz.eisp.mdm.terminal.service.TmTerminalBackExtendService;
import com.biz.eisp.mdm.terminal.vo.TmTermCustRelImportVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TmTermCustRelHandler
extends ImpEventHandler<TmTermCustRelImportVo> {
    private List<TmRTermCustPosBGEntity> importDataList = new ArrayList<TmRTermCustPosBGEntity>();
    private TmTermCustPostService tmTermCustPostService;
    private TmTerminalBackExtendService tmTerminalBackExtendService;
    private TbNumRuleProvider tbNumRuleProvider;
    private int succNum = 0;
    private int errNum = 0;
    private StringBuilder errors = new StringBuilder();
    private List<String> saveIdList;

    public TmTermCustRelHandler() {
        this.tmTermCustPostService = (TmTermCustPostService)ApplicationContextUtils.getContext().getBean(TmTermCustPostService.class);
        this.tbNumRuleProvider = (TbNumRuleProvider)ApplicationContextUtils.getContext().getBean(TbNumRuleProvider.class);
        String[] beanNamesForBackExtendService = ApplicationContextUtils.getContext().getBeanNamesForType(TmTerminalBackExtendService.class);
        if (beanNamesForBackExtendService.length > 0) {
            this.tmTerminalBackExtendService = (TmTerminalBackExtendService)ApplicationContextUtils.getContext().getBean(beanNamesForBackExtendService[0], TmTerminalBackExtendService.class);
        }
        this.saveIdList = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public void endRow(Map<String, Object> row, TmTermCustRelImportVo bean) throws ValidateException {
        String terminalCode = bean.getTerminalCode();
        String customerCode = bean.getCustomerCode();
        TmTerminalEntity terminalEntity = this.tmTermCustPostService.findUniqueByProperty(TmTerminalEntity.class, "terminalCode", terminalCode);
        TmCustomerEntity customerEntity = this.tmTermCustPostService.findUniqueByProperty(TmCustomerEntity.class, "customerCode", customerCode);
        if (terminalEntity == null) {
            this.addErrorMsg("\u7ec8\u7aef\u7f16\u7801\uff1a" + terminalCode + "\u4e0d\u5b58\u5728");
        }
        if (customerEntity == null) {
            this.addErrorMsg("\u5ba2\u6237\u7f16\u7801\uff1a" + customerCode + "\u4e0d\u5b58\u5728");
        }
        if (terminalEntity != null && customerEntity != null) {
            if (this.isExistTmRTermCustPosBGEntity(terminalEntity.getId(), customerEntity.getId())) {
                this.addErrorMsg("\u7ec8\u7aef\uff1a" + terminalCode + "\u5ba2\u6237\u5173\u7cfb\u5df2\u5b58\u5728");
            } else {
                TmRTermCustPosBGEntity entity = new TmRTermCustPosBGEntity();
                entity.setTmCustomer(customerEntity);
                entity.setTmTerminal(terminalEntity);
                this.tbNumRuleProvider.getMaxNum("terminal_business_group");
                this.importDataList.add(entity);
                ++this.succNum;
                this.setSuccNum(this.succNum);
            }
        }
    }

    private boolean isExistTmRTermCustPosBGEntity(String terminalId, String customerId) {
        String hql = "from TmRTermCustPosBGEntity where tmTerminal.id = ? and tmCustomer.id = ?";
        List tmRTermCustPosBGEntities = this.tmTermCustPostService.findByHql(hql, terminalId, customerId);
        return CollectionUtil.listNotEmptyNotSizeZero(tmRTermCustPosBGEntities);
    }

    private void addErrorMsg(String error) throws ValidateException {
        this.errors.append("\u3010\u7b2c" + this.getRowNumber() + "\u884c\u3011:" + error).append("<br/>");
        ++this.errNum;
        if (this.errNum > 200) {
            throw new ValidateException(this.errors.toString());
        }
    }

    @Override
    public void end() {
        if (this.errNum > 0) {
            throw new BusinessException(this.errors.toString());
        }
        this.saveData();
        this.importDataList.clear();
    }

    private void saveData() {
        if (CollectionUtil.listNotEmptyNotSizeZero(this.importDataList)) {
            for (TmRTermCustPosBGEntity entity : this.importDataList) {
                this.tmTermCustPostService.save(entity);
                this.saveIdList.add(entity.getId());
            }
        }
    }

    @Override
    public void impEnd() {
        super.impEnd();
        if (null != this.tmTerminalBackExtendService) {
            this.tmTerminalBackExtendService.afterImportTmTermCustRel(this.saveIdList);
        }
    }
}

