/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.model.activiti;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;

public class DateConverter
implements Converter {
    private static final Logger logger = Logger.getLogger(DateConverter.class);
    private static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DATETIME_PATTERN_NO_SECOND = "yyyy-MM-dd HH:mm";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String MONTH_PATTERN = "yyyy-MM";

    public Object convert(Class type, Object value) {
        Object result = null;
        if (type == Date.class) {
            try {
                result = this.doConvertToDate(value);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else if (type == String.class) {
            result = this.doConvertToString(value);
        }
        return result;
    }

    private Date doConvertToDate(Object value) throws ParseException {
        Date result = null;
        if (value instanceof String) {
            result = DateUtils.parseDate((String)((String)value), (String[])new String[]{DATE_PATTERN, DATETIME_PATTERN, DATETIME_PATTERN_NO_SECOND, MONTH_PATTERN});
            if (result == null && StringUtils.isNotEmpty((CharSequence)((String)value))) {
                try {
                    result = new Date(new Long((String)value));
                }
                catch (Exception e) {
                    logger.error((Object)"Converting from milliseconds to Date fails!");
                    e.printStackTrace();
                }
            }
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            if (array != null && array.length >= 1) {
                value = array[0];
                result = this.doConvertToDate(value);
            }
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            result = (Date)value;
        }
        return result;
    }

    private String doConvertToString(Object value) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATETIME_PATTERN);
        String result = null;
        if (value instanceof Date) {
            result = simpleDateFormat.format(value);
        }
        return result;
    }
}

