/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.transformer;

import com.biz.eisp.activiti.entity.activiti.ActHiTaskinstEntity;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang3.time.DateFormatUtils;

public class ActHiTaskinstEntityToHistoryTaskVo
implements Function<ActHiTaskinstEntity, HistoryTaskVo> {
    private RepositoryService repositoryService;
    private TaTaskService taTaskService;
    private HistoryService historyService;

    public ActHiTaskinstEntityToHistoryTaskVo(RepositoryService repositoryService, HistoryService historyService, TaTaskService taTaskService) {
        this.repositoryService = repositoryService;
        this.historyService = historyService;
        this.taTaskService = taTaskService;
    }

    public HistoryTaskVo apply(ActHiTaskinstEntity entity) {
        if (entity == null) {
            return null;
        }
        HistoryTaskVo vo = new HistoryTaskVo();
        String startTime = entity.getStartTime() == null ? "" : DateFormatUtils.format((Date)entity.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
        String endTime = entity.getEndTime() == null ? "" : DateFormatUtils.format((Date)entity.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
        long totalTimes = entity.getEndTime() == null ? Calendar.getInstance().getTimeInMillis() - entity.getStartTime().getTime() : entity.getEndTime().getTime() - entity.getStartTime().getTime();
        long dayCount = totalTimes / 86400000L;
        long restTimes = totalTimes % 86400000L;
        long hourCount = restTimes / 3600000L;
        long minuteCount = (restTimes %= 3600000L) / 60000L;
        String spendTimes = dayCount + "\u5929" + hourCount + "\u5c0f\u65f6" + minuteCount + "\u5206";
        ProcessDefinition processDefinition = this.getProcessDefinition(entity.getProcDefId());
        String buisnessKey = entity.getProInsl().getBusinessKey();
        TaBaseBusinessObjEntity businessObj = this.taTaskService.get(TaBaseBusinessObjEntity.class, (Serializable)((Object)buisnessKey));
        vo.setAssignee(entity.getAssignee());
        vo.setStartTime(startTime);
        vo.setEndTime(endTime);
        vo.setSpendTimes(spendTimes);
        vo.setTaskName("dd");
        vo.setCreateUserName(businessObj.getTmPositionEntity().getPositionName());
        vo.setProcessInstanceId(entity.getProcInstId());
        vo.setProcessDefinitionId(entity.getProcDefId());
        vo.setProcessDefinitionKey(processDefinition.getKey());
        vo.setProcessDefinitionName(processDefinition.getName());
        vo.setId(entity.getId());
        return vo;
    }

    private ProcessDefinition getProcessDefinition(String processDefinitionId) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
    }
}

