/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.core.redis.util;

import com.biz.eisp.base.core.redis.cache.IRedisCacheService;

public class LockUtils {
    private static final int defaultExpire = 120;
    private IRedisCacheService redisService;

    public LockUtils(IRedisCacheService redisCacheService) {
        this.redisService = redisCacheService;
    }

    public boolean lock(String key) {
        return this.lock2(key, 120);
    }

    public boolean lock2(String key, int expire) {
        try {
            long value = System.currentTimeMillis() + (long)(expire * 1000);
            long status = this.redisService.setnx(key, String.valueOf(value));
            if (status == 1L) {
                return true;
            }
            long oldExpireTime = this.redisService.get(key, Long.class);
            System.out.print(oldExpireTime + "\n");
            System.out.print(System.currentTimeMillis() + "\n");
            System.out.print(System.currentTimeMillis() - oldExpireTime);
            if (oldExpireTime < System.currentTimeMillis()) {
                long currentExpireTime;
                long newExpireTime = System.currentTimeMillis() + (long)(expire * 1000);
                String curr = this.redisService.getSet(key, String.valueOf(newExpireTime));
                long l = currentExpireTime = curr != null ? Long.valueOf(curr.replace("\"", "")) : 0L;
                if (currentExpireTime == oldExpireTime) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void unLock(String key) {
        try {
            this.redisService.remove(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

