SELECT * FROM (
  SELECT
    hpi.id_ AS ID,
    hpi.proc_def_id_ AS processDefinitionId,
    pd.key_ AS processDefinitionKey,
    pd.name_ AS processDefinitionName,
    hpi.proc_inst_id_ AS processInstanceId,
    bo.process_title AS processTitle,
    bo.full_name AS startFullName,
    t.name_ AS activityName,
    t.assignee_ AS activityUser,
    t.id_ AS taskId,
    hpi.start_time_ AS startTime,
    hpi.end_time_ AS endTime,
    CASE WHEN re.suspension_state_ IS NULL THEN 'finished' WHEN re.suspension_state_ = 1 THEN 'false' ELSE 'true' END AS isSuspended
  FROM
    act_hi_procinst hpi
    LEFT JOIN act_re_procdef pd ON pd.id_ = hpi.proc_def_id_
    LEFT JOIN ta_base_business_obj bo ON bo.id = hpi.business_key_
    LEFT JOIN act_ru_task t ON t.proc_inst_id_ = hpi.proc_inst_id_
    LEFT JOIN act_ru_execution re ON re.proc_inst_id_ = hpi.proc_inst_id_ AND re.id_ = t.execution_id_
) t
WHERE 1=1
<#if processInstanceVo.id ?exists && processInstanceVo.id ?length gt 0>
    AND t.id LIKE '%${processInstanceVo.id}%'
</#if>
<#if processInstanceVo.processDefinitionKey ?exists && processInstanceVo.processDefinitionKey ?length gt 0>
  AND t.processDefinitionKey LIKE '%${processInstanceVo.processDefinitionKey}%'
</#if>
<#if processInstanceVo.processDefinitionName ?exists && processInstanceVo.processDefinitionName ?length gt 0>
  AND t.processDefinitionName LIKE '%${processInstanceVo.processDefinitionName}%'
</#if>
<#if processInstanceVo.processTitle ?exists && processInstanceVo.processTitle ?length gt 0>
  AND t.processTitle LIKE '%${processInstanceVo.processTitle}%'
</#if>
<#if processInstanceVo.startFullName ?exists && processInstanceVo.startFullName ?length gt 0>
  AND t.startFullName LIKE '%${processInstanceVo.startFullName}%'
</#if>
<#if processInstanceVo.isSuspended ?exists && processInstanceVo.isSuspended ?length gt 0>
  AND t.isSuspended = '${processInstanceVo.isSuspended}'
</#if>
<#if processInstanceVo.startTime ?exists && processInstanceVo.startTime ?length gt 0>
  AND to_char(t.startTime,'yyyy-MM-dd') >= '${processInstanceVo.startTime}'
</#if>
<#if processInstanceVo.endTime ?exists && processInstanceVo.endTime ?length gt 0>
  AND to_char(t.endTime,'yyyy-MM-dd') <= '${processInstanceVo.endTime}'
</#if>
ORDER BY t.startTime DESC