SELECT * FROM (
    SELECT * FROM (
      SELECT
          hti.id_ AS ID,
          pd.key_ AS processDefinitionKey,
          pd.name_ AS processDefinitionName,
          pi.proc_inst_id_ AS processInstanceId,
          bo.process_title AS processTitle,
          bo.full_name AS createUserName,
          o.org_code,
          o.org_name,
          to_char(hti.start_time_, 'yyyy-mm-dd hh24:mi:ss') AS startTime,
          to_char(hti.end_time_, 'yyyy-mm-dd hh24:mi:ss') AS endTime,
          hti.assignee_ AS assignee,
          hti.name_ AS taskName,
          t.currentTaskName,
          CASE WHEN t.suspension_state_ = 2 THEN 'reject' ELSE rs.code END AS runtimeStatus
      FROM
         act_hi_taskinst hti
         LEFT JOIN act_re_procdef pd ON pd.id_ = hti.proc_def_id_
         LEFT JOIN act_hi_procinst pi ON pi.proc_inst_id_ = hti.proc_inst_id_
         LEFT JOIN ta_base_business_obj bo ON bo.id = pi.business_key_
         LEFT JOIN tm_position tp ON tp.position_code = bo.position_code
         LEFT JOIN tm_org o ON o.id = tp.org_id
         LEFT JOIN ta_runtime_status rs ON rs.id = bo.runtime_status_id
         LEFT JOIN (
             SELECT t.proc_inst_id_, t.suspension_state_,name_ AS currentTaskName FROM act_ru_task  t GROUP BY t.proc_inst_id_, t.suspension_state_,name_
         ) t ON t.proc_inst_id_ = pi.id_
      WHERE
         hti.duration_ > 0
         AND
         hti.owner_ = '${historyTaskVo.assignee}'
      <#if historyTaskVo.processDefinitionKey ?exists && historyTaskVo.processDefinitionKey ?length gt 0>
        AND pd.key_ LIKE '%${historyTaskVo.processDefinitionKey}%'
      </#if>
      <#if historyTaskVo.processDefinitionName ?exists && historyTaskVo.processDefinitionName ?length gt 0>
        AND pd.name_ LIKE '%${historyTaskVo.processDefinitionName}%'
      </#if>
      <#if historyTaskVo.processTitle ?exists && historyTaskVo.processTitle ?length gt 0>
        AND bo.process_title LIKE '%${historyTaskVo.processTitle}%'
      </#if>
    ) t

    UNION ALL

    SELECT * FROM (
      SELECT
      hti.id_||cc.id AS ID,
      pd.key_ AS processDefinitionKey,
      pd.name_ AS processDefinitionName,
      pi.proc_inst_id_ AS processInstanceId,
      bo.process_title AS processTitle,
      bo.full_name AS createUserName,
      o.org_code,
      o.org_name,
      to_char(hti.start_time_, 'yyyy-mm-dd hh24:mi:ss') AS startTime,
      to_char(hti.end_time_, 'yyyy-mm-dd hh24:mi:ss') AS endTime,
      hti.assignee_ AS assignee,
      hti.name_ AS taskName,
      t.currentTaskName,
      CASE WHEN t.suspension_state_ = 2 THEN 'reject' ELSE rs.code END AS runtimeStatus
    FROM ta_communicate_content cc
      LEFT JOIN ta_communicate c ON c.id = cc.TA_COMMUNICATE_ID
      LEFT JOIN (SELECT * FROM (SELECT row_number() OVER (PARTITION BY proc_inst_id_ ORDER BY start_time_ DESC) AS rn , t.*FROM act_hi_taskinst t) WHERE rn = 1) hti ON hti.proc_inst_id_ = c.process_instance_id
      LEFT JOIN act_re_procdef pd ON pd.id_ = hti.proc_def_id_
      LEFT JOIN act_hi_procinst pi ON pi.proc_inst_id_ = hti.proc_inst_id_
      LEFT JOIN ta_base_business_obj bo ON bo.id = pi.business_key_
      LEFT JOIN tm_position tp ON tp.position_code = bo.position_code
      LEFT JOIN tm_org o ON o.id = tp.org_id
      LEFT JOIN ta_runtime_status rs ON rs.id = bo.runtime_status_id
      LEFT JOIN (
        SELECT t.proc_inst_id_, t.suspension_state_,name_ AS currentTaskName FROM act_ru_task  t GROUP BY t.proc_inst_id_, t.suspension_state_,name_
      ) t ON t.proc_inst_id_ = pi.id_
      WHERE
         cc.circulation_code = '${historyTaskVo.assignee}'
      <#if historyTaskVo.processDefinitionKey ?exists && historyTaskVo.processDefinitionKey ?length gt 0>
        AND pd.key_ LIKE '%${historyTaskVo.processDefinitionKey}%'
      </#if>
      <#if historyTaskVo.processDefinitionName ?exists && historyTaskVo.processDefinitionName ?length gt 0>
        AND pd.name_ LIKE '%${historyTaskVo.processDefinitionName}%'
      </#if>
      <#if historyTaskVo.processTitle ?exists && historyTaskVo.processTitle ?length gt 0>
        AND bo.process_title LIKE '%${historyTaskVo.processTitle}%'
      </#if>
    ) t
) t

WHERE 1=1
<#if historyTaskVo.processInstanceId ?exists && historyTaskVo.processInstanceId ?length gt 0>
	AND t.processInstanceId LIKE '%${historyTaskVo.processInstanceId}%'
</#if>
<#if historyTaskVo.createUserName ?exists && historyTaskVo.createUserName ?length gt 0>
	AND t.createUserName LIKE '%${historyTaskVo.createUserName}%'
</#if>
<#if historyTaskVo.currentTaskName ?exists && historyTaskVo.currentTaskName ?length gt 0>
	AND t.currentTaskName LIKE '%${historyTaskVo.currentTaskName}%'
</#if>
<#if historyTaskVo.runtimeStatus ?exists && historyTaskVo.runtimeStatus ?length gt 0>
	AND t.runtimeStatus = '${historyTaskVo.runtimeStatus}'
</#if>
<#if historyTaskVo.startTime ?exists && historyTaskVo.startTime ?length gt 0>
	AND substr(t.startTime, 1, 10) = '${historyTaskVo.startTime}'
</#if>
<#if historyTaskVo.endTime ?exists && historyTaskVo.endTime ?length gt 0>
	AND substr(t.endTime, 1, 10) = '${historyTaskVo.endTime}'
</#if>
<#if historyTaskVo.orgCodes ?exists && historyTaskVo.orgCodes ?length gt 0>
	AND t.org_code IN (${historyTaskVo.orgCodes})
</#if>


ORDER BY t.endTime DESC