SELECT * FROM (
  SELECT
    p.id,
    u.username AS userName,
    u.fullname AS fullName,
    p.position_code AS positionCode,
    p.position_name AS positionName,
    o.org_name AS orgName,
    pp.position_name AS parentName,
    po.org_name AS parentOrgName,
    p.position_level AS positionLevel
  FROM tm_position p
         LEFT JOIN tm_r_user_position up ON up.position_id = p.id AND up.is_main = 0
         LEFT JOIN tm_user u ON u.id = up.user_id
         LEFT JOIN tm_position pp ON pp.id = p.parent_id
         LEFT JOIN tm_org o ON o.id = p.org_id
         LEFT JOIN tm_org po ON po.id = pp.org_id
  WHERE p.enable_status ='009' AND p.id NOT IN (SELECT position_id FROM tm_r_position_role r WHERE r.role_id = '${vo.roleIds}')
) t
WHERE 1=1
<#if vo.userName ?exists&&vo.userName ?length gt 0>
	AND t.userName LIKE '%${vo.userName}%'
</#if>
<#if vo.fullName ?exists&&vo.fullName ?length gt 0>
	AND t.fullName LIKE '%${vo.fullName}%'
</#if>
<#if vo.positionCode ?exists&&vo.positionCode ?length gt 0>
	AND t.positionCode LIKE '%${vo.positionCode}%'
</#if>
<#if vo.positionName ?exists&&vo.positionName ?length gt 0>
	AND t.positionName LIKE '%${vo.positionName}%'
</#if>
<#if vo.orgName ?exists&&vo.orgName ?length gt 0>
	AND t.orgName LIKE '%${vo.orgName}%'
</#if>
<#if vo.parentName ?exists&&vo.parentName ?length gt 0>
	AND t.parentName LIKE '%${vo.parentName}%'
</#if>
<#if vo.parentOrgName ?exists&&vo.parentOrgName ?length gt 0>
	AND t.parentOrgName LIKE '%${vo.parentOrgName}%'
</#if>
<#if vo.positionLevel ?exists&&vo.positionLevel ?length gt 0>
	AND t.positionLevel = '${vo.positionLevel}'
</#if>
ORDER BY positionCode