/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer;

import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ImpConfigurator {
    public static final Log log = LogFactory.getLog((String)"ImpConfigurator");
    public static final String CONF_FILE_PATH = "/import/";
    public static final int DEFAULT_BATCHES = 500;
    private Class entityClass;
    private String[] key;
    private DataField[] keyField;
    private int startRow;
    private Class eventHandler;
    private String templateName;
    private List<DataField> fields = new ArrayList<DataField>();
    private DataField mlKey;
    private DataField mlParentKey;
    private int batches = 500;
    private String tableName = null;
    private boolean deleteByKey = false;
    private boolean ignoreNull = false;
    private Class customDataImporter;
    private String templateNameKey;
    private String templateNameBundle;
    private boolean autoSave = false;

    private ImpConfigurator(String fileName) throws SecurityException, ClassNotFoundException, DocumentException, NoSuchFieldException {
        this.init(fileName);
    }

    private void init(String fileName) throws ClassNotFoundException, DocumentException, SecurityException {
        String path = CONF_FILE_PATH + fileName;
        SAXReader saxReader = new SAXReader();
        saxReader.setValidation(false);
        saxReader.setIncludeExternalDTDDeclarations(false);
        saxReader.setIncludeInternalDTDDeclarations(false);
        saxReader.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new ByteArrayInputStream("".getBytes()));
            }
        });
        Document doc = saxReader.read(ImpConfigurator.class.getResourceAsStream(path));
        Element tabEl = doc.getRootElement();
        this.entityClass = Class.forName(tabEl.attributeValue("class"));
        this.autoSave = Boolean.parseBoolean(tabEl.attributeValue("autoSave"));
        String keyval = tabEl.attributeValue("key");
        if (StringUtils.isNotBlank((String)keyval)) {
            this.key = keyval.split("\\,");
            this.keyField = new DataField[this.key.length];
        }
        int n = this.startRow = StringUtils.isNotBlank((String)tabEl.attributeValue("startRow")) ? Integer.parseInt(tabEl.attributeValue("startRow")) : 0;
        if (StringUtils.isNotBlank((String)tabEl.attributeValue("start-row"))) {
            this.startRow = Integer.parseInt(tabEl.attributeValue("start-row"));
        }
        this.templateName = tabEl.attributeValue("template-name");
        if (StringUtils.isNotBlank((String)tabEl.attributeValue("eventHandler"))) {
            this.eventHandler = Class.forName(tabEl.attributeValue("eventHandler"));
        }
        if (StringUtils.isNotBlank((String)tabEl.attributeValue("customDataImporter"))) {
            this.customDataImporter = Class.forName(tabEl.attributeValue("customDataImporter"));
        }
        this.templateNameKey = tabEl.attributeValue("template-name-key");
        this.templateNameBundle = tabEl.attributeValue("template-name-bundle");
        if (StringUtils.isNotBlank((String)tabEl.attributeValue("event-handler"))) {
            this.eventHandler = Class.forName(tabEl.attributeValue("event-handler"));
        }
        if (StringUtils.isNotBlank((String)tabEl.attributeValue("batches"))) {
            this.batches = Integer.parseInt(tabEl.attributeValue("batches"));
            if (this.batches == 0) {
                this.batches = Integer.MAX_VALUE;
            }
        }
        if (StringUtils.isNotBlank((String)tabEl.attributeValue("delete-by-key"))) {
            this.deleteByKey = Boolean.parseBoolean(tabEl.attributeValue("delete-by-key"));
        }
        if (StringUtils.isNotBlank((String)tabEl.attributeValue("ignore-null"))) {
            this.ignoreNull = Boolean.parseBoolean(tabEl.attributeValue("ignore-null"));
        }
        String mlKeyCode = null;
        List list = tabEl.element("columns").elements();
        Element clos = tabEl.element("columns");
        this.tableName = clos.attributeValue("tableName");
        if (StringUtil.isNotEmpty((String)this.tableName)) {
            List<DataField> tableData = DynamicConfigUtil.getInstance().buildImportDataFieldList(this.tableName.toUpperCase());
            this.fields.addAll(tableData);
        }
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element columnEl = (Element)list.get(i);
                DataField field = new DataField();
                Integer size = this.fields.size() + 1;
                field.setName(size.toString());
                field.setCode(columnEl.attributeValue("code"));
                field.setTitle(columnEl.attributeValue("title"));
                field.setType(columnEl.attributeValue("type"));
                field.setLength(StringUtils.isNotBlank((String)columnEl.attributeValue("length")) ? Integer.parseInt(columnEl.attributeValue("length")) : 0);
                field.setFormat(columnEl.attributeValue("format"));
                field.setRequired(Boolean.parseBoolean(columnEl.attributeValue("required")));
                field.setMask(columnEl.attributeValue("mask"));
                field.setFilter(columnEl.attributeValue("filter"));
                field.setValue(columnEl.attributeValue("value"));
                field.setAllowSkip(Boolean.parseBoolean(columnEl.attributeValue("allow-skip")));
                field.setOnError(columnEl.attributeValue("on-error"));
                field.setAvailable(StringUtils.isBlank((String)columnEl.attributeValue("available")) ? true : Boolean.parseBoolean(columnEl.attributeValue("available")));
                field.setDictCode(columnEl.attributeValue("dictCode"));
                String dictCode = columnEl.attributeValue("dictCode");
                if (StringUtil.isNotEmpty((String)dictCode)) {
                    BaseService baseService = (BaseService)ApplicationContextUtils.getContext().getBean("baseService");
                    List<ComboBox> dictList = baseService.comboBoxByDict(dictCode);
                    String[] dictArray = new String[dictList.size()];
                    for (int v = 0; v < dictList.size(); ++v) {
                        ComboBox c = dictList.get(v);
                        dictArray[v] = c.getText();
                    }
                    field.setList(dictArray);
                }
                this.fields.add(field);
                if (this.key != null) {
                    for (int j = 0; j < this.key.length; ++j) {
                        if (!this.key[j].equals(field.getCode())) continue;
                        this.keyField[j] = field;
                    }
                }
                if (StringUtils.isNotBlank((String)field.getCode())) {
                    String[] c = field.getCode().split("\\.");
                    try {
                        if (!this.entityClass.getDeclaredField(c[0]).getType().equals(this.entityClass)) continue;
                        this.mlParentKey = field;
                        mlKeyCode = c[1];
                    }
                    catch (NoSuchFieldException e) {
                        field.setAvailable(false);
                    }
                    continue;
                }
                field.setAvailable(false);
            }
        }
        for (DataField field : this.fields) {
            if (field.getCode() == null || !field.getCode().equals(mlKeyCode)) continue;
            this.mlKey = field;
            break;
        }
    }

    public static ImpConfigurator getConfigurator(String fileName) throws SecurityException, ClassNotFoundException, DocumentException, NoSuchFieldException {
        return new ImpConfigurator(fileName);
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public List<DataField> getFields() {
        return this.fields;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public String[] getKey() {
        return this.key;
    }

    public DataField[] getKeyField() {
        return this.keyField;
    }

    public DataField getMlKey() {
        return this.mlKey;
    }

    public DataField getMlParentKey() {
        return this.mlParentKey;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public Class getEventHandler() {
        return this.eventHandler;
    }

    public Class getCustomDataImporter() {
        return this.customDataImporter;
    }

    public String getTemplateNameKey() {
        return this.templateNameKey;
    }

    public String getTemplateNameBundle() {
        return this.templateNameBundle;
    }

    public int getBatches() {
        return this.batches;
    }

    public boolean isDeleteByKey() {
        return this.deleteByKey;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }
}

