/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.businessarea.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.businessarea.dao.TmBusinessAreaDao;
import com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaExtendService;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaService;
import com.biz.eisp.mdm.businessarea.transformer.TmBusinessAreaEntityToTmBusinessAreaVo;
import com.biz.eisp.mdm.businessarea.transformer.TmBusinessAreaVoToTmBusinessAreaEntity;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaExcelVo;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmBusinessAreaService")
@Transactional
public class TmBusinessAreaServiceImpl
extends BaseServiceImpl
implements TmBusinessAreaService {
    @Autowired
    private TmBusinessAreaDao tmBusinessAreaDao;
    @Autowired(required=false)
    private TmBusinessAreaExtendService tmBusinessAreaExtendService;

    @Override
    public void saveTmBusinessArea(TmBusinessAreaVo tmBusinessAreaVo, Page page) {
        TmBusinessAreaEntity tmBusinessAreaEntity = null;
        if (StringUtil.isNotEmpty(this.tmBusinessAreaExtendService)) {
            try {
                this.tmBusinessAreaExtendService.validate(tmBusinessAreaVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmBusinessAreaEntity = this.tmBusinessAreaExtendService.saveBefore(tmBusinessAreaVo, page);
        }
        if (StringUtil.isEmpty(tmBusinessAreaEntity)) {
            tmBusinessAreaEntity = new TmBusinessAreaVoToTmBusinessAreaEntity(this).apply(tmBusinessAreaVo);
        }
        if (StringUtil.isNotEmpty(this.tmBusinessAreaExtendService)) {
            tmBusinessAreaEntity = this.tmBusinessAreaExtendService.saveBefore(tmBusinessAreaEntity, tmBusinessAreaVo, page);
        }
        this.saveOrUpdate(tmBusinessAreaEntity);
        if (StringUtil.isNotEmpty(this.tmBusinessAreaExtendService)) {
            tmBusinessAreaEntity = this.tmBusinessAreaExtendService.savePost(tmBusinessAreaEntity, tmBusinessAreaVo, page);
        }
    }

    @Override
    public void deleteTmBusinessArea(String id) {
        TmBusinessAreaEntity tbaEntity = this.get(TmBusinessAreaEntity.class, (Serializable)((Object)id));
        if (tbaEntity.getIsLeaf() != null && tbaEntity.getIsLeaf() == 0) {
            throw new BusinessException("\u5b58\u5728\u5b50\u8282\u70b9\u4e0d\u80fd\u5220\u9664");
        }
        this.delete(tbaEntity);
    }

    @Override
    public void updateBusinessAreaEnableStatus(TmBusinessAreaVo tmBusinessAreaVo) {
        TmBusinessAreaEntity entity = this.get(TmBusinessAreaEntity.class, (Serializable)((Object)tmBusinessAreaVo.getId()));
        entity.setEnableStatus(tmBusinessAreaVo.getEnableStatus());
        this.updateEntity(entity);
    }

    @Override
    public List<ComboBox> findBusinessAreaCombobox(TmBusinessAreaExcelVo tba) {
        String sql = "select distinct  t.name text,t.name value  from tm_business_area t left join  tm_business_area t1 on t1.id=t.PARENT_ID where 1=1";
        ArrayList<ComboBox> comList = new ArrayList<ComboBox>();
        ComboBox comboBox = new ComboBox();
        comboBox.setSelected(false);
        comboBox.setText("\u8bf7\u9009\u62e9");
        comboBox.setValue("");
        comList.add(comboBox);
        if (StringUtil.isNotEmpty(tba.getAreaLevel())) {
            sql = sql + " and t.AREA_LEVEL=?";
            List<ComboBox> comList1 = this.findBySql(ComboBox.class, sql, tba.getAreaLevel());
            comList.addAll(comList1);
        }
        if (StringUtil.isNotEmpty((String)tba.getBusinessAreaName())) {
            sql = sql + " and t1.name=?";
            List<ComboBox> comList2 = this.findBySql(ComboBox.class, sql, tba.getBusinessAreaName());
            comList.addAll(comList2);
        }
        return comList;
    }

    @Override
    public boolean validate(String id, String param, String fieldName) {
        SimpleExpression cr1 = Restrictions.eq((String)fieldName, (Object)param);
        List<Object> tmtbas = new ArrayList();
        if (StringUtil.isNotEmpty((String)id)) {
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)id);
            tmtbas = this.findByCriteria(TmBusinessAreaEntity.class, new Criterion[]{cr1, cr2});
        } else {
            tmtbas = this.findByCriteria(TmBusinessAreaEntity.class, new Criterion[]{cr1});
        }
        return !CollectionUtils.isEmpty(tmtbas);
    }

    @Override
    public List<TmBusinessAreaVo> findBusinessAreaList(TmBusinessAreaVo tmBusinessAreaVo) {
        String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_BUSINESS_AREA, tmBusinessAreaVo);
        sql = sql + " order by t.code ";
        List<TmBusinessAreaVo> voList = this.findBySql(TmBusinessAreaVo.class, sql, new Object[0]);
        if (DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_BUSINESS_AREA, tmBusinessAreaVo)) {
            voList = this.findQueryBusinessAreaList(tmBusinessAreaVo, voList);
        }
        return voList;
    }

    public List<TmBusinessAreaVo> findBusinessAreaListTree(TmBusinessAreaVo tmBusinessAreaVo) {
        String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_BUSINESS_AREA, tmBusinessAreaVo);
        List<TmBusinessAreaVo> voList = this.findBySql(TmBusinessAreaVo.class, sql, new Object[0]);
        String sqlAll = " SELECT id,name text,parent_id FROM tm_business_area  ";
        List<TmBusinessAreaVo> allList = this.findBySql(TmBusinessAreaVo.class, sqlAll, new Object[0]);
        this.crateList(voList, allList);
        return voList;
    }

    private void crateList(List<TmBusinessAreaVo> voList, List<TmBusinessAreaVo> childList) {
        if (CollectionUtils.isEmpty(childList)) {
            return;
        }
        HashMap<String, List<TmBusinessAreaVo>> mapList = new HashMap<String, List<TmBusinessAreaVo>>();
        for (TmBusinessAreaVo temp : childList) {
            String parentId = temp.getParentId();
            if (!StringUtil.isNotBlank((String)parentId)) continue;
            if (mapList.containsKey(parentId)) {
                ((List)mapList.get(parentId)).add(temp);
                continue;
            }
            ArrayList<TmBusinessAreaVo> tempList = new ArrayList<TmBusinessAreaVo>();
            tempList.add(temp);
            mapList.put(parentId, tempList);
        }
        for (TmBusinessAreaVo item : voList) {
            String id = item.getId();
            if (!mapList.containsKey(id)) continue;
            item.setChildren((List)mapList.get(id));
            this.createChildList(mapList, (List)mapList.get(id));
        }
    }

    private void createChildList(Map<String, List<TmBusinessAreaVo>> mapList, List<TmBusinessAreaVo> childList) {
        if (CollectionUtils.isEmpty(childList)) {
            return;
        }
        for (TmBusinessAreaVo item : childList) {
            String id = item.getId();
            if (!mapList.containsKey(id) || !CollectionUtil.listNotEmptyNotSizeZero(mapList.get(id))) continue;
            item.setChildren(mapList.get(id));
            this.createChildList(mapList, mapList.get(id));
        }
    }

    @Override
    public List<TmBusinessAreaVo> findTmBusinessAreaSingleLevelList(TmBusinessAreaVo tmBusinessAreaVo) {
        return this.tmBusinessAreaDao.findTmBusinessAreaSingleLevelList(tmBusinessAreaVo);
    }

    @Override
    public List<TmBusinessAreaVo> findTmBusinessAreaComboTree(TmBusinessAreaVo tmBusinessAreaVo, String selfId) {
        List voList = null;
        if (StringUtils.isNotBlank((CharSequence)selfId)) {
            List<TmBusinessAreaEntity> entityList = this.findByProperty(TmBusinessAreaEntity.class, "id", selfId);
            voList = Lists.transform(entityList, (Function)new TmBusinessAreaEntityToTmBusinessAreaVo());
        } else {
            voList = this.findBusinessAreaListTree(tmBusinessAreaVo);
        }
        return voList;
    }

    private List<TmBusinessAreaVo> findQueryBusinessAreaList(TmBusinessAreaVo tmBusinessAreaVo, List<TmBusinessAreaVo> voList) {
        if (tmBusinessAreaVo.getExportExcel().equals("true")) {
            return voList;
        }
        List allQueryVoList = TreeGridUtil.buildTreeGrid(voList);
        return allQueryVoList;
    }

    @Override
    public void updateTmBusinessAreaIsLeaf() {
        this.tmBusinessAreaDao.updateLeafNode();
        this.tmBusinessAreaDao.updateNotLeafNode();
    }

    @Override
    public TmBusinessAreaVo getTmBusinessAreaVo(String id) {
        TmBusinessAreaEntity entity = this.get(TmBusinessAreaEntity.class, (Serializable)((Object)id));
        TmBusinessAreaVo vo = new TmBusinessAreaEntityToTmBusinessAreaVo().apply(entity);
        return vo;
    }

    @Override
    public List<ComboTree> findChildrenBusinessArea(TmBusinessAreaVo vo) {
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            List<TmBusinessAreaEntity> list = this.tmBusinessAreaDao.findChildrenBusinessAreaList(vo);
            for (TmBusinessAreaEntity entity : list) {
                String id = entity.getId();
                String sql = "select * from tm_business_area t where t.parent_id = ?";
                List<TmBusinessAreaEntity> lists = this.findBySql(TmBusinessAreaEntity.class, sql, id);
                entity.setTmBusinessAreas(lists);
            }
            ComboTreeModel comboTreeModel = new ComboTreeModel("id", "businessAreaName", "tmBusinessAreas");
            List<ComboTree> comboTrees = this.comboTree(list, comboTreeModel, null, false);
            return comboTrees;
        }
        return null;
    }

    @Override
    public List<TmBusinessAreaVo> findBusinessAreaLists(String conditions) {
        List<TmBusinessAreaVo> list = null;
        if (StringUtils.isNotBlank((CharSequence)conditions)) {
            list = this.tmBusinessAreaDao.findTmBusinessAreaListByConditions(conditions);
        }
        return list;
    }
}

