/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.administrativearea.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.administrativearea.dao.TmAdministrativeAreaDao;
import com.biz.eisp.mdm.administrativearea.entity.TmAdministrativeAreaEntity;
import com.biz.eisp.mdm.administrativearea.service.TmAdministrativeAreaExtendService;
import com.biz.eisp.mdm.administrativearea.service.TmAdministrativeAreaService;
import com.biz.eisp.mdm.administrativearea.transformer.TmAdministrativeAreaEntityToTmAdministrativeAreaVo;
import com.biz.eisp.mdm.administrativearea.transformer.TmAdministrativeAreaVoToTmAdministrativeAreaEntity;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaExcelVo;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmAdministrativeAreaService")
@Transactional
public class TmAdministrativeAreaServiceImpl
extends BaseServiceImpl
implements TmAdministrativeAreaService {
    @Autowired
    private TmAdministrativeAreaDao tmAdministrativeAreaDao;
    @Autowired(required=false)
    private TmAdministrativeAreaExtendService tmAdministrativeAreaExtendService;

    @Override
    public void saveTmAdministrativeArea(TmAdministrativeAreaVo tmAdministrativeAreaVo, Page page) {
        TmAdministrativeAreaEntity tmAdministrativeAreaEntity = null;
        if (StringUtil.isNotEmpty(this.tmAdministrativeAreaExtendService)) {
            try {
                this.tmAdministrativeAreaExtendService.validate(tmAdministrativeAreaVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmAdministrativeAreaEntity = this.tmAdministrativeAreaExtendService.saveBefore(tmAdministrativeAreaVo, page);
        }
        if (StringUtil.isEmpty(tmAdministrativeAreaEntity)) {
            tmAdministrativeAreaEntity = new TmAdministrativeAreaVoToTmAdministrativeAreaEntity(this).apply(tmAdministrativeAreaVo);
        }
        if (StringUtil.isNotEmpty(this.tmAdministrativeAreaExtendService)) {
            tmAdministrativeAreaEntity = this.tmAdministrativeAreaExtendService.saveBefore(tmAdministrativeAreaEntity, tmAdministrativeAreaVo, page);
        }
        this.saveOrUpdate(tmAdministrativeAreaEntity);
        if (StringUtil.isNotEmpty(this.tmAdministrativeAreaExtendService)) {
            tmAdministrativeAreaEntity = this.tmAdministrativeAreaExtendService.savePost(tmAdministrativeAreaEntity, tmAdministrativeAreaVo, page);
        }
    }

    @Override
    public void deleteTmAdministrativeArea(String id) {
        TmAdministrativeAreaEntity tbaEntity = this.get(TmAdministrativeAreaEntity.class, (Serializable)((Object)id));
        if (tbaEntity.getIsLeaf() == 0) {
            throw new BusinessException("\u5b58\u5728\u5b50\u8282\u70b9\u4e0d\u80fd\u5220\u9664");
        }
        this.delete(tbaEntity);
    }

    @Override
    public void updateAdministrativeAreaEnableStatus(TmAdministrativeAreaVo tmAdministrativeAreaVo) {
        TmAdministrativeAreaEntity entity = this.get(TmAdministrativeAreaEntity.class, (Serializable)((Object)tmAdministrativeAreaVo.getId()));
        entity.setEnableStatus(tmAdministrativeAreaVo.getEnableStatus());
        this.updateEntity(entity);
    }

    @Override
    public List<ComboBox> findAdministrativeAreaCombobox(TmAdministrativeAreaExcelVo tba) {
        String sql = "select distinct  t.name text,t.name value  from tm_administrative_area t left join  tm_administrative_area t1 on t1.id=t.PARENT_ID where 1=1";
        List<ComboBox> comList = null;
        if (StringUtil.isNotEmpty(tba.getAreaLevel())) {
            sql = sql + " and t.AREA_LEVEL=?";
            comList = this.findBySql(ComboBox.class, sql, tba.getAreaLevel());
        }
        if (StringUtil.isNotEmpty((String)tba.getAdministrativeAreaName())) {
            sql = sql + " and t1.name=?";
            comList = this.findBySql(ComboBox.class, sql, tba.getAdministrativeAreaName());
        }
        return comList;
    }

    @Override
    public boolean validate(String id, String param, String fieldName) {
        SimpleExpression cr1 = Restrictions.eq((String)fieldName, (Object)param);
        List<Object> tmtbas = new ArrayList();
        if (StringUtil.isNotEmpty((String)id)) {
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)id);
            tmtbas = this.findByCriteria(TmAdministrativeAreaEntity.class, new Criterion[]{cr1, cr2});
        } else {
            tmtbas = this.findByCriteria(TmAdministrativeAreaEntity.class, new Criterion[]{cr1});
        }
        return !CollectionUtils.isEmpty(tmtbas);
    }

    @Override
    public List<TmAdministrativeAreaVo> findAdministrativeAreaList(TmAdministrativeAreaVo tmAdministrativeAreaVo) {
        String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_ADMINISTRATIVE_AREA, tmAdministrativeAreaVo);
        List<TmAdministrativeAreaVo> voList = this.findBySql(TmAdministrativeAreaVo.class, sql, new Object[0]);
        if (DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_ADMINISTRATIVE_AREA, tmAdministrativeAreaVo)) {
            voList = this.findQueryAdministrativeAreaList(tmAdministrativeAreaVo, voList);
        }
        return voList;
    }

    @Override
    public List<TmAdministrativeAreaVo> findTmAdministrativeAreaComboTree(TmAdministrativeAreaVo tmAdministrativeAreaVo, String selfId) {
        List voList = null;
        if (StringUtils.isNotBlank((CharSequence)selfId)) {
            List<TmAdministrativeAreaEntity> entityList = this.findByProperty(TmAdministrativeAreaEntity.class, "id", selfId);
            voList = Lists.transform(entityList, (Function)new TmAdministrativeAreaEntityToTmAdministrativeAreaVo());
        } else {
            voList = this.findAdministrativeAreaList(tmAdministrativeAreaVo);
        }
        return voList;
    }

    private List<TmAdministrativeAreaVo> findQueryAdministrativeAreaList(TmAdministrativeAreaVo tmAdministrativeAreaVo, List<TmAdministrativeAreaVo> voList) {
        if (tmAdministrativeAreaVo.getExportExcel().equals("true")) {
            return voList;
        }
        List allQueryVoList = TreeGridUtil.buildTreeGrid(voList);
        return allQueryVoList;
    }

    @Override
    public void updateTmAdministrativeAreaIsLeaf() {
        this.tmAdministrativeAreaDao.updateLeafNode();
        this.tmAdministrativeAreaDao.updateNotLeafNode();
    }

    @Override
    public TmAdministrativeAreaVo getTmAdministrativeAreaVo(String id) {
        TmAdministrativeAreaEntity entity = this.get(TmAdministrativeAreaEntity.class, (Serializable)((Object)id));
        TmAdministrativeAreaVo vo = new TmAdministrativeAreaEntityToTmAdministrativeAreaVo().apply(entity);
        return vo;
    }

    @Override
    public List<ComboTree> findChildrenAdministrativeArea(TmAdministrativeAreaVo vo) {
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            List<TmAdministrativeAreaEntity> list = this.tmAdministrativeAreaDao.findChildrenAdministrativeAreaList(vo);
            for (TmAdministrativeAreaEntity entity : list) {
                String id = entity.getId();
                String sql = "select * from tm_administrative_area t where t.parent_id = ?";
                List<TmAdministrativeAreaEntity> lists = this.findBySql(TmAdministrativeAreaEntity.class, sql, id);
                entity.setTmAdministrativeAreas(lists);
            }
            ComboTreeModel comboTreeModel = new ComboTreeModel("id", "administrativeAreaName", "tmAdministrativeAreas");
            List<ComboTree> comboTrees = this.comboTree(list, comboTreeModel, null, false);
            return comboTrees;
        }
        return null;
    }

    @Override
    public List<TmAdministrativeAreaVo> findAdministrativeAreaLists(String conditions) {
        List<TmAdministrativeAreaVo> list = null;
        if (StringUtils.isNotBlank((CharSequence)conditions)) {
            list = this.tmAdministrativeAreaDao.findTmAdministrativeAreaListByConditions(conditions);
        }
        return list;
    }
}

