/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.arearange.controller;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.arearange.service.TmAreaRangeService;
import com.biz.eisp.mdm.arearange.vo.TmAreaRangeVo;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaService;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaVo;
import com.biz.eisp.mdm.org.service.TmOrgService;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmAreaRangeController"})
public class TmAreaRangeController
extends BaseController {
    @Autowired
    private TmAreaRangeService tmAreaRangeService;
    @Autowired
    private TmBusinessAreaService tmBusinessAreaService;
    @Autowired
    private TmOrgService tmOrgService;

    @RequestMapping(params={"goAreaRangeMain"})
    public ModelAndView goAreaRangeMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/arearange/tmAreaRangeMain");
    }

    @RequestMapping(params={"goAreaRangeForm"})
    public ModelAndView goAreaRangeForm(TmAreaRangeVo vo, HttpServletRequest request) {
        ModelAndView modelAndView = new ModelAndView("com/biz/eisp/mdm/arearange/tmAreaRangeForm");
        if (StringUtil.isNotEmpty(vo) && StringUtil.isNotEmpty((String)vo.getId())) {
            modelAndView.addObject("vo", (Object)this.tmAreaRangeService.getAreaRangeById(vo.getId()));
        }
        TmBusinessAreaVo tmBusinessAreaVo = new TmBusinessAreaVo();
        tmBusinessAreaVo.setAreaLevel(1);
        List<TmBusinessAreaVo> businessAreaList = this.tmBusinessAreaService.findTmBusinessAreaSingleLevelList(tmBusinessAreaVo);
        modelAndView.addObject("businessAreaList", businessAreaList);
        TmOrgVo tmOrgVo = new TmOrgVo();
        tmOrgVo.setOrgType("32");
        List<TmOrgVo> salesAreaList = this.tmOrgService.getOrgByOrgLevel(tmOrgVo);
        modelAndView.addObject("salesAreaList", salesAreaList);
        return modelAndView;
    }

    @RequestMapping(params={"findAreaRangeList"})
    @ResponseBody
    public DataGrid findAreaRangeList(TmAreaRangeVo vo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmAreaRangeVo> areaRangeList = this.tmAreaRangeService.findAreaRangeList(vo, page);
        return new DataGrid(areaRangeList, page);
    }

    @RequestMapping(params={"saveAreaRange"})
    @ResponseBody
    public AjaxJson saveAreaRange(TmAreaRangeVo vo, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            this.tmAreaRangeService.saveAreaRange(vo);
        }
        catch (BusinessException be) {
            be.printStackTrace();
            j.setSuccess(false);
            j.setMsg(be.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"deleteAreaRangeByIds"})
    @ResponseBody
    public AjaxJson deleteAreaRangeByIds(String ids, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            this.tmAreaRangeService.deleteAreaRangeByIds(ids);
        }
        catch (BusinessException be) {
            be.printStackTrace();
            j.setSuccess(false);
            j.setMsg(be.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(TmAreaRangeVo tmAreaRangeVo, HttpServletRequest request, HttpServletResponse response) {
        List<TmAreaRangeVo> list = this.tmAreaRangeService.findAreaRangeList(tmAreaRangeVo, null);
        this.doExportXls(response, request, list, TmAreaRangeVo.class, "\u4e1a\u52a1\u533a\u57df\u7ba1\u7406\u8868");
    }
}

