/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.authobj.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthHead;
import com.biz.eisp.mdm.authobj.entity.TmFunctionFunEntity;
import com.biz.eisp.mdm.authobj.entity.TmRoleFuncAuthobjEntity;
import com.biz.eisp.mdm.authobj.service.TmFunAuthService;
import com.biz.eisp.mdm.authobj.vo.TmFunctionAuthVo;
import com.biz.eisp.mdm.dict.util.DictUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/funAuthController"})
public class TmFunAuthController
extends BaseController {
    @Autowired
    private TmFunAuthService tmFunAuthService;

    @RequestMapping(params={"funAuth"})
    public ModelAndView operation(HttpServletRequest request, String functionId) {
        request.setAttribute("functionId", (Object)functionId);
        return new ModelAndView("com/biz/eisp/mdm/funAuth/functionAuth");
    }

    @RequestMapping(params={"findFunAuthListByFunId"})
    @ResponseBody
    public DataGrid findFunAuthListByFunId(String funId, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        page.setRows("1000");
        List<TmFunctionFunEntity> tmPositionVoList = this.tmFunAuthService.findFunAuthListByFunId(funId);
        return new DataGrid(tmPositionVoList, null);
    }

    @RequestMapping(params={"findFunAuthListByFunIdForRole"})
    @ResponseBody
    public List<TmFunctionFunEntity> findFunAuthListByFunIdForRole(String funId, HttpServletRequest request, HttpServletResponse response) {
        ArrayList<TmFunctionFunEntity> tmPositionVoList = this.tmFunAuthService.findFunAuthListByFunId(funId);
        tmPositionVoList = tmPositionVoList == null ? new ArrayList<TmFunctionFunEntity>() : tmPositionVoList;
        return tmPositionVoList;
    }

    @RequestMapping(params={"findFunAuthListByFunCode"})
    @ResponseBody
    public DataGrid findFunAuthListByFunCode(HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        page.setRows("1000");
        List<KnlDictDataEntity> list = DictUtil.getDictList("authobj");
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setId(UUID.randomUUID().toString()));
            list.sort((ord1, ord2) -> ord2.getDictCode().compareTo(ord1.getDictCode()));
        }
        return new DataGrid(list, null);
    }

    @RequestMapping(params={"findFunAuthListByFunCodeVal"})
    @ResponseBody
    public List<TmFunAuthEntity> findFunAuthListByFunCodeVal(String funCode, String funId, HttpServletRequest request, HttpServletResponse response) {
        List<TmFunAuthEntity> list = null;
        if (StringUtil.isNotBlank((String)funCode)) {
            String sql = " select id,fun_code,authobj from tm_r_function_authobj where fun_code=? and function_id=? ";
            list = this.tmFunAuthService.findBySql(TmFunAuthEntity.class, sql, funCode, funId);
        }
        list = list == null ? new ArrayList<TmFunAuthEntity>() : list;
        return list;
    }

    @RequestMapping(params={"findFunAuthListByFunCodeValForRole"})
    @ResponseBody
    public List<KnlDictDataEntity> findFunAuthListByFunCodeValForRole(String funCode, String funId, HttpServletRequest request, HttpServletResponse response) {
        List<Object> list = null;
        if (StringUtil.isNotBlank((String)funCode)) {
            String sql = " select id,fun_code,authobj from tm_r_function_authobj where fun_code=? and function_id=? ";
            list = this.tmFunAuthService.findBySql(TmFunAuthEntity.class, sql, funCode, funId);
        }
        list = list == null ? new ArrayList() : list;
        Map<String, TmFunAuthEntity> mapOld = list.stream().collect(Collectors.toMap(TmFunAuthEntity::getAuthobj, item -> item));
        ArrayList<KnlDictDataEntity> knlDictDataEntities = DictUtil.getDictList("authobj");
        knlDictDataEntities = knlDictDataEntities == null ? new ArrayList<KnlDictDataEntity>() : knlDictDataEntities;
        for (int i = 0; i < knlDictDataEntities.size(); ++i) {
            if (mapOld.containsKey(((KnlDictDataEntity)knlDictDataEntities.get(i)).getDictCode())) continue;
            knlDictDataEntities.remove(i);
            --i;
        }
        return knlDictDataEntities;
    }

    @RequestMapping(params={"findFunAuthValForRole"})
    @ResponseBody
    public List<KnlDictDataEntity> findFunAuthValForRole(String authobj, String funCode, String funId, String roleId, HttpServletRequest request, HttpServletResponse response) {
        ArrayList<KnlDictDataEntity> knlDictDataEntities = new ArrayList<KnlDictDataEntity>();
        ArrayList knlDictDataEntitiesAll = DictUtil.getDictList("authobj");
        knlDictDataEntitiesAll = knlDictDataEntitiesAll == null ? new ArrayList() : knlDictDataEntitiesAll;
        String sql = " select b.id,b.AUTHOBJ,b.AUTHOBJ_VALUE from tm_r_role_function a   join tm_r_role_func_authobj b on a.id = b.ROLE_FUNCTION_ID where a.FUNCTION_ID=? and a.ROLE_ID=? and b.fun_code=? and b.authobj = ? ";
        ArrayList roleFuncAuthobjEntities = this.tmFunAuthService.findBySql(TmRoleFuncAuthobjEntity.class, sql, funId, roleId, funCode, authobj);
        roleFuncAuthobjEntities = roleFuncAuthobjEntities == null ? new ArrayList() : roleFuncAuthobjEntities;
        Map<String, TmRoleFuncAuthobjEntity> mapOld = roleFuncAuthobjEntities.stream().collect(Collectors.toMap(TmRoleFuncAuthobjEntity::getAuthobjValue, item -> item));
        for (KnlDictDataEntity knlDictDataEntity : knlDictDataEntitiesAll) {
            if (!authobj.equals(knlDictDataEntity.getDictCode())) continue;
            ArrayList items = DictUtil.getDictByParentId(knlDictDataEntity.getId());
            items = items == null ? new ArrayList() : items;
            for (KnlDictDataEntity item2 : items) {
                if (mapOld.containsKey(item2.getDictCode())) {
                    item2.setStatus("true");
                } else {
                    item2.setStatus("false");
                }
                knlDictDataEntities.add(item2);
            }
        }
        return knlDictDataEntities;
    }

    @RequestMapping(params={"goFunctionFunSaveOrUpdate"})
    public ModelAndView goFunctionFunSaveOrUpdate(String id, String funId, HttpServletRequest request) {
        if (StringUtil.isNotBlank((String)id)) {
            TmFunctionFunEntity entity = this.tmFunAuthService.get(TmFunctionFunEntity.class, (Serializable)((Object)id));
            request.setAttribute("function", (Object)entity);
        }
        request.setAttribute("funId", (Object)funId);
        List<KnlDictDataEntity> list = DictUtil.getDictList("function_permissions_btn");
        request.setAttribute("list", list);
        return new ModelAndView("com/biz/eisp/mdm/funAuth/functionAuthForm");
    }

    @RequestMapping(params={"saveOrUpdateFunctionFun"})
    @ResponseBody
    public AjaxJson saveOrUpdateFunctionFun(TmFunctionFunEntity tmFunctionFunEntity) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            ajaxJson = this.tmFunAuthService.saveOrUpdateFunctionFun(tmFunctionFunEntity, ajaxJson);
        }
        catch (Exception e) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return ajaxJson;
    }

    @RequestMapping(params={"saveOrUpdateItem"})
    @ResponseBody
    public AjaxJson saveOrUpdateItem(@RequestBody TmFunAuthHead head) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            ajaxJson = this.tmFunAuthService.saveOrUpdateItem(head, ajaxJson);
        }
        catch (Exception e) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return ajaxJson;
    }

    @RequestMapping(params={"deleteFunctionFun"})
    @ResponseBody
    public AjaxJson deleteFunctionFun(HttpServletRequest request, HttpServletResponse response, String ids) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            String[] id;
            for (String tempId : id = ids.split(",")) {
                this.tmFunAuthService.deleteFunctionFun(tempId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxJson;
    }

    @RequestMapping(params={"saveFunAuth"})
    @ResponseBody
    public JSONObject saveFunAuth(HttpServletRequest request, HttpServletResponse response, TmFunctionAuthVo funAuth) {
        try {
            this.tmFunAuthService.saveFunAuth(funAuth);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01";
        }
        return this.returnJson();
    }
}

