/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.customer.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.service.TmCustPostService;
import com.biz.eisp.mdm.customer.service.TmCustomerFormExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerMainExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerService;
import com.biz.eisp.mdm.customer.vo.TmCustPostVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.erpcode.commond.QuoteStrategy;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmCustomerController"})
public class TmCustomerController
extends BaseController {
    @Autowired
    private TmCustomerService tmCustomerService;
    @Autowired
    private TmCustPostService tmCustPostService;
    @Autowired(required=false)
    private QuoteStrategy quoteStrategy;
    @Autowired(required=false)
    private TmCustomerFormExtendService tmCustomerFormExtendService;
    @Autowired(required=false)
    private TmCustomerMainExtendService tmCustomerMainExtendService;

    @RequestMapping(params={"goTmCustomerMain"})
    public ModelAndView goTmCustomerMain(HttpServletRequest request) {
        request.setAttribute("extendTableName", (Object)Globals.Table_CUSTOMER);
        if (this.tmCustomerMainExtendService != null) {
            request.setAttribute("includeJSP", (Object)this.tmCustomerMainExtendService.includeJsp());
        }
        request.setAttribute("clickFunctionId", (Object)request.getParameter("clickFunctionId"));
        return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerMain");
    }

    @RequestMapping(params={"goTmCustSearch"})
    public ModelAndView goTmCustSearch(TmCustomerVo vo, String singleSelect, String searchUrl) {
        ModelAndView view = new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerSearchMain");
        if (StringUtil.isEmpty(searchUrl)) {
            searchUrl = "tmCustomerController.do?findTmCustomerBySearchList";
        }
        view.addObject("searchUrl", (Object)searchUrl);
        view.addObject("vo", (Object)vo);
        view.addObject("extendTableName", (Object)Globals.Table_CUSTOMER);
        view.addObject("singleSelect", (Object)singleSelect);
        return view;
    }

    @RequestMapping(params={"goTmCustomer"})
    public ModelAndView goTmCustomer(TmCustomerVo customerVo, HttpServletRequest request, HttpServletResponse response) {
        String sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.Table_CUSTOMER, customerVo);
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        request.setAttribute("extendTableName", (Object)Globals.Table_CUSTOMER);
        String id = customerVo.getId();
        if (StringUtil.isNotEmpty((String)id)) {
            EuPage page = new EuPage(request);
            customerVo = this.tmCustomerService.getTmCustomerVoById(customerVo, page);
            request.setAttribute(Globals.Table_CUSTOMER, (Object)customerVo);
            TmCustPostVo cust = new TmCustPostVo();
            cust.setCustomerId(id);
            List<TmCustPostVo> custPostList = this.tmCustPostService.findTmCustPostList(cust);
            request.setAttribute("custPostList", custPostList);
        }
        if (this.tmCustomerFormExtendService != null) {
            request.setAttribute("includeJSP", (Object)this.tmCustomerFormExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerForm");
    }

    @RequestMapping(params={"goTermCustPostMain"})
    public ModelAndView goTermCustPostMain(String id, HttpServletRequest request) {
        request.setAttribute("customerId", (Object)id);
        return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerTerm");
    }

    @RequestMapping(params={"findTmCustomerList"})
    @ResponseBody
    public DataGrid findTmCustomerList(TmCustomerVo customerVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List<TmCustomerVo> customerList = this.tmCustomerService.findTmCustomerList(customerVo, page, request.getParameter("clickFunctionId"));
        return new DataGrid(customerList, page);
    }

    @RequestMapping(params={"findTmCustomerBySearchList"})
    @ResponseBody
    public DataGrid findTmCustomerBySearchList(TmCustomerVo customerVo, HttpServletRequest request) {
        List<TmCustomerVo> customerList;
        EuPage page = new EuPage(request);
        if (StringUtil.isNotEmpty((String)customerVo.getSearchParam())) {
            customerVo.setCustomerName(customerVo.getSearchParam());
        }
        try {
            customerList = this.tmCustomerService.findTmCustomerList(customerVo, page, request.getParameter("clickFunctionId"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25," + e.getMessage());
        }
        return new DataGrid(customerList, page);
    }

    @RequestMapping(params={"getTmCustomerBySearchList"})
    @ResponseBody
    public AjaxJson getTmCustomerBySearchList(TmCustomerVo customerVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        HashMap<String, Object> aMap = new HashMap<String, Object>();
        EuPage page = new EuPage(request);
        try {
            if (StringUtil.isNotEmpty((String)customerVo.getSearchParam())) {
                customerVo.setCustomerName(customerVo.getSearchParam());
            }
            List<TmCustomerVo> customerList = this.tmCustomerService.findTmCustomerList(customerVo, page, request.getParameter("clickFunctionId"));
            aMap.put("totle", customerList.size());
            j.setObj(customerList);
        }
        catch (Exception e) {
            j.setSuccess(false);
            aMap.put("totle", 0);
            e.printStackTrace();
        }
        j.setAttributes(aMap);
        return j;
    }

    @RequestMapping(params={"findTmCustomerByPosList"})
    @ResponseBody
    public DataGrid findTmCustomerByPosList(TmCustomerVo customerVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List<TmCustomerVo> customerList = this.tmCustomerService.findTmCustomerByPosList(customerVo, page);
        return new DataGrid(customerList, page);
    }

    @RequestMapping(params={"getErpCodeInfo"})
    public void getCustErpCode(String erpCode, HttpServletRequest request, HttpServletResponse response) {
        TmCustomerVo vo = new TmCustomerVo();
        if (this.quoteStrategy != null) {
            vo = this.quoteStrategy.remoteAccess(erpCode);
        }
        super.sendObjToJSON(response, vo);
    }

    @RequestMapping(params={"saveTmCustomer"})
    public void saveCustomer(TmCustomerVo customerVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        this.tmCustomerService.saveTmCustomer(customerVo, page);
        super.sendResponse(response);
    }

    @RequestMapping(params={"deleteTmCustomer"})
    @ResponseBody
    public AjaxJson deleteTmCustomer(String ids, HttpServletRequest request) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            EuPage page = new EuPage(request);
            this.tmCustomerService.deleteTmCustomer(ids, page);
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setMsg("\u5220\u9664\u5931\u8d25:" + e.getMessage());
        }
        return ajaxJson;
    }

    @RequestMapping(params={"goTmLogDetailMain"})
    public ModelAndView goTmLogDetailMain(HttpServletRequest request) {
        String businessId = request.getParameter("id");
        request.setAttribute("actionUrl", (Object)("tmCustomerController.do?findTmLogList&businessId=" + businessId));
        return new ModelAndView("com/biz/eisp/log/tmLogDetailMain");
    }

    @RequestMapping(params={"findTmLogList"})
    public void findTmLogList(TmLogVo tmLogVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmLogVo> tmLogList = this.tmCustomerService.findCustomerLogList(tmLogVo, page);
        this.datagridReturn(response, tmLogList, page);
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(TmCustomerVo customerVo, HttpServletRequest request, HttpServletResponse response) {
        List<TmCustomerVo> customerList = this.tmCustomerService.findTmCustomerList(customerVo, null, request.getParameter("clickFunctionId"));
        this.doExportXls(response, request, customerList, TmCustomerVo.class, "\u5ba2\u6237\u5217\u8868");
    }

    @RequestMapping(params={"validateCustomerName"})
    @ResponseBody
    public ValidForm validateCustomerName(HttpServletRequest request, TmCustomerVo tmCustomerVo) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        if (StringUtil.isNotEmpty((String)tmCustomerVo.getId())) {
            SimpleExpression cr1 = Restrictions.eq((String)"customerName", (Object)param);
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)tmCustomerVo.getId());
            List<TmCustomerEntity> tmCustomers = this.tmCustomerService.findByCriteria(TmCustomerEntity.class, new Criterion[]{cr1, cr2});
            if (!CollectionUtils.isEmpty(tmCustomers)) {
                validForm.setStatus("n");
                validForm.setInfo("\u5ba2\u6237\u540d\u79f0\u5df2\u5b58\u5728");
            }
        } else {
            List<TmCustomerEntity> tmcusts = this.tmCustomerService.findByProperty(TmCustomerEntity.class, "customerName", param);
            if (!CollectionUtils.isEmpty(tmcusts)) {
                validForm.setStatus("n");
                validForm.setInfo("\u5ba2\u6237\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        return validForm;
    }

    @RequestMapping(params={"goTpmCustMain"})
    public ModelAndView goTpmCustMain(TmCustomerVo customerVo, HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/tmCustomer/chooseCustomerMain");
    }

    @RequestMapping(params={"findTpmCustomerList"})
    @ResponseBody
    public DataGrid findTpmCustomerList(TmCustomerVo customerVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List<TmCustomerVo> customerList = this.tmCustomerService.findTpmCustomerList(customerVo, page);
        return new DataGrid(customerList, page);
    }

    @RequestMapping(params={"goTmCustomerByOrgMain"})
    public ModelAndView goTmCustomerByOrgMain(TmCustomerVo tmCustomerVo, HttpServletRequest request) {
        if (StringUtil.isNotEmpty((String)tmCustomerVo.getOrgId())) {
            request.setAttribute("orgId", (Object)tmCustomerVo.getOrgId());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmCustomer/tmCustomerByOrgMain");
    }

    @RequestMapping(params={"findTmCustomerListByOrgMain"})
    @ResponseBody
    public DataGrid findTmCustomerListByOrgMain(TmCustomerVo customerVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        customerVo.setCurrentOrgId(ResourceUtil.getCurrOrg().getId());
        List<TmCustomerVo> customerList = this.tmCustomerService.findTmCustomerListByOrgMain(customerVo, page);
        return new DataGrid(customerList, page);
    }

    @RequestMapping(params={"changeCustomerForOrg"})
    @ResponseBody
    public AjaxJson changeCustomerForOrg(HttpServletRequest request, TmOrgVo tmOrgVo) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.tmCustomerService.changeCustomerForOrg(tmOrgVo);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u8c03\u6574\u5173\u7cfb\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"startOrStop"})
    @ResponseBody
    public AjaxJson startOrStopTmuser(TmCustomerVo tmCustomerVo) {
        AjaxJson json = new AjaxJson();
        try {
            json = this.tmCustomerService.startOrStop(tmCustomerVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return json;
    }
}

