/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.customer.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.mdm.customer.dao.TmCustomerDao;
import com.biz.eisp.mdm.customer.dao.TmRCustPosBgDetailDao;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.entity.TmRCustPosBGEntity;
import com.biz.eisp.mdm.customer.service.TmCustPostService;
import com.biz.eisp.mdm.customer.vo.TmCustPostVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmCustPostService")
@Transactional
public class TmCustPostServiceImpl
extends BaseServiceImpl
implements TmCustPostService {
    @Autowired
    private TmCustomerDao tmCustomerDao;
    @Autowired
    private TmRCustPosBgDetailDao tmRCustPosBgDetailDao;

    @Override
    public void deleteTmCustPost(TmCustPostVo custPostVo) {
        if (StringUtil.isEmpty(custPostVo.getId())) {
            throw new BusinessException("\u5220\u9664\u7ecf\u9500\u5546\u5c97\u4f4d\u5bf9\u5e94\u5173\u7cfb\u4fe1\u606f\u65f6\uff0c\u4e3b\u952eID\u4e3a\u7a7a");
        }
        TmRCustPosBGEntity tmCustPost = this.get(TmRCustPosBGEntity.class, (Serializable)((Object)custPostVo.getId()));
        this.delete(tmCustPost);
    }

    @Override
    public List<TmCustPostVo> findTmCustPostList(TmCustPostVo custPostVo) {
        return this.tmCustomerDao.findTmCustPostDetailList(custPostVo);
    }

    @Override
    public List<TmCustPostVo> findPostList(TmCustPostVo customerVo, Page page) {
        return this.tmCustomerDao.findTmCustPostList(customerVo, page);
    }

    @Override
    public List<TmCustomerVo> findNotAnyPostCustomerList(TmCustPostVo tmCustPostVo, Page page) {
        return this.tmRCustPosBgDetailDao.findNotAnyPostCustomerList(tmCustPostVo, page);
    }

    @Override
    public List<TmCustomerVo> findNotCurrPostCustomerList(TmCustPostVo tmCustPostVo, Page page) {
        return this.tmRCustPosBgDetailDao.findNotCurrPostCustomerList(tmCustPostVo, page);
    }

    @Override
    public void addRelotaionForPositionId(String customerIds, String positionId) {
        if (StringUtil.isEmpty(customerIds) && StringUtil.isEmpty(positionId)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        String[] ids = customerIds.split(",");
        TmPositionEntity tmPositionEntity = this.get(TmPositionEntity.class, (Serializable)((Object)positionId));
        TmCustomerEntity tmCustomerEntity = null;
        String hql = "from TmRCustPosBGEntity where tmCustomer.id=? and tmPosition.id=?";
        for (String customerId : ids) {
            tmCustomerEntity = this.get(TmCustomerEntity.class, (Serializable)((Object)customerId));
            List tmRTermCustPosBGEntities = this.findByHql(hql, positionId, customerId);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmRTermCustPosBGEntities)) continue;
            TmRCustPosBGEntity tmRCustPosBGEntity = new TmRCustPosBGEntity();
            tmRCustPosBGEntity.setTmCustomer(tmCustomerEntity);
            tmRCustPosBGEntity.setTmPosition(tmPositionEntity);
            tmRCustPosBGEntity.setBusinessGroup(tmPositionEntity.getBusinessGroup());
            this.save(tmRCustPosBGEntity);
            String content = "\u5ba2\u6237\u5bf9\u63a5\u4eba\u804c\u4f4d\u6279\u91cf\u8c03\u6574,\u5173\u8054\u5bf9\u63a5\u4eba\u804c\u4f4d:<b>" + tmPositionEntity.getPositionName() + "</b>";
            this.addLog(OperationType.INSERT, "\u7ec8\u7aef\u4e0e\u5ba2\u6237\u5bf9\u5e94\u5173\u7cfb", customerId, content);
        }
    }

    @Override
    public void updatePostCustomerRelation(String relationIds, String positionId) {
        if (StringUtil.isEmpty(relationIds) && StringUtil.isEmpty(positionId)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        String[] ids = relationIds.split(",");
        TmPositionEntity tmPositionEntity = this.get(TmPositionEntity.class, (Serializable)((Object)positionId));
        TmRCustPosBGEntity tmRCustPosBGEntity = null;
        String hql = "from TmRCustPosBGEntity where tmCustomer.id=? and tmPosition.id=?";
        for (String id : ids) {
            tmRCustPosBGEntity = this.get(TmRCustPosBGEntity.class, (Serializable)((Object)id));
            List tmRTermCustPosBGEntities = this.findByHql(hql, tmRCustPosBGEntity.getTmCustomer().getId(), positionId);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmRTermCustPosBGEntities)) continue;
            String content = "\u5ba2\u6237\u5bf9\u63a5\u4eba\u804c\u4f4d\u66ff\u6362,\u539f\u5bf9\u63a5\u4eba\u804c\u4f4d:<b>" + tmRCustPosBGEntity.getTmPosition().getPositionName() + "</b>\u66ff\u6362\u4e3a<b>" + tmPositionEntity.getPositionName() + "<b>";
            this.addLog(OperationType.UPDATE, "\u7ec8\u7aef\u4e0e\u804c\u4f4d\u5bf9\u5e94\u5173\u7cfb", tmRCustPosBGEntity.getTmCustomer().getId(), content);
            tmRCustPosBGEntity.setTmPosition(tmPositionEntity);
            this.updateEntity(tmRCustPosBGEntity);
        }
    }

    @Override
    public void deleteRelotaionForCustomerId(String ids) {
        String[] idArray;
        if (StringUtil.isEmpty(ids)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        for (String id : idArray = ids.split(",")) {
            TmRCustPosBGEntity tmRCustPosBGEntity = this.get(TmRCustPosBGEntity.class, (Serializable)((Object)id));
            String content = "\u5ba2\u6237\u5bf9\u63a5\u4eba\u804c\u4f4d\u6279\u91cf\u8c03\u6574,\u53d6\u6d88\u5173\u8054\u5bf9\u63a5\u4eba\u804c\u4f4d:<b>" + tmRCustPosBGEntity.getTmPosition().getPositionName() + "</b>";
            this.delete(tmRCustPosBGEntity);
            this.addLog(OperationType.DELETE, "\u7ec8\u7aef\u4e0e\u5ba2\u6237\u5bf9\u5e94\u5173\u7cfb", tmRCustPosBGEntity.getTmCustomer().getId(), content);
        }
    }
}

