/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.util.oConvertUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.redis.util.RedisUtils;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.org.dao.TmOrgDao;
import com.biz.eisp.mdm.org.util.TmOrgTreeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ComboxTreeUtil
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String comboxTag = ResourceUtil.getDbConfigProperty("jdbc.username") + "_orgTree";
    public static final String comboxTag_version = ResourceUtil.getDbConfigProperty("jdbc.username") + "_orgTree_version";
    public static final HashMap<String, Long> versionMap = new HashMap();
    public static ConcurrentHashMap<String, List<ComboTree>> currMap = new ConcurrentHashMap();

    public static List<ComboTree> getComboTrees() {
        RedisService redisCacheService = RedisUtils.getRedisService();
        List<ComboTree> list = new ArrayList<ComboTree>();
        if (redisCacheService != null) {
            Map<Object, Object> orgVos = redisCacheService.hmget(comboxTag);
            if (orgVos != null && orgVos.size() > 0) {
                for (Map.Entry<Object, Object> entry : orgVos.entrySet()) {
                    list.add((ComboTree)entry.getValue());
                }
            } else {
                TmOrgDao tmOrgDao = (TmOrgDao)ApplicationContextUtils.getContext().getBean("tmOrgDao");
                List<ComboTree> comboTrees = tmOrgDao.findComboTree();
                HashMap redisMap = new HashMap();
                comboTrees.forEach(item -> redisMap.put(item.getId(), item));
                list = comboTrees;
            }
            list = TmOrgTreeUtil.buildTree(list);
            currMap.put(comboxTag, list);
        }
        return list;
    }

    public static List<ComboTree> getComboxByObj(List<ComboTree> comboTrees, ComboTreeModel comboTreeModel, Object obj) {
        ArrayList<ComboTree> trees = new ArrayList<ComboTree>();
        ReflectHelper reflectHelper = new ReflectHelper(obj);
        String id = oConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getIdField()));
        HashSet<String> tmpSet = new HashSet<String>();
        block0: for (ComboTree ct : comboTrees) {
            ComboTree tmp = null;
            if (ct != null && ct.getId().equals(id)) {
                tmp = ct;
                if (tmpSet.contains(tmp.getId())) break;
                trees.add(tmp);
                tmpSet.add(tmp.getId());
                break;
            }
            List<ComboTree> children = ct.getChildren();
            for (ComboTree chir : children) {
                tmp = ComboxTreeUtil.sementTrees(chir, id);
                if (tmp == null) continue;
                if (tmpSet.contains(tmp.getId())) continue block0;
                trees.add(tmp);
                tmpSet.add(tmp.getId());
                continue block0;
            }
        }
        return trees;
    }

    private static ComboTree sementTrees(ComboTree ct, String id) {
        boolean b = false;
        ComboTree tmp = null;
        if (ct != null && ct.getId().equals(id)) {
            b = true;
            tmp = ct;
        } else {
            List<ComboTree> children = ct.getChildren();
            if (children != null && children.size() > 0) {
                ComboTree comboTree;
                Iterator<ComboTree> iterator = children.iterator();
                while (iterator.hasNext() && (tmp = ComboxTreeUtil.sementTrees(comboTree = iterator.next(), id)) == null) {
                }
            } else {
                tmp = null;
            }
        }
        return tmp;
    }
}

