/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class ZipUtils {
    public static void createFile(InputStream source, String fileName) throws Exception {
        FileOutputStream fos = new FileOutputStream(fileName);
        byte[] buf = new byte[2048];
        int readLen = 0;
        while ((readLen = source.read(buf, 0, 2048)) != -1) {
            fos.write(buf, 0, readLen);
        }
        source.close();
        fos.close();
    }

    public static void zip(String source, String zipFileName) throws Exception {
        File sourceFile = new File(source);
        List<File> files = ZipUtils.getSubFiles(sourceFile);
        ZipOutputStream zos = new ZipOutputStream((OutputStream)new FileOutputStream(zipFileName));
        ZipEntry ze = null;
        byte[] buf = new byte[2048];
        int readLen = 0;
        for (int i = 0; i < files.size(); ++i) {
            File subFile = files.get(i);
            ze = new ZipEntry(ZipUtils.getAbsFileName(sourceFile, subFile));
            ze.setSize(subFile.length());
            ze.setTime(subFile.lastModified());
            zos.putNextEntry(ze);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(subFile));
            while ((readLen = ((InputStream)is).read(buf, 0, 2048)) != -1) {
                zos.write(buf, 0, readLen);
            }
            ((InputStream)is).close();
        }
        zos.close();
    }

    public static void zip(List<String> files, String zipFileName) throws Exception {
        ZipOutputStream zos = new ZipOutputStream((OutputStream)new FileOutputStream(zipFileName));
        ZipEntry ze = null;
        byte[] buf = new byte[2048];
        int readLen = 0;
        for (int i = 0; i < files.size(); ++i) {
            File subFile = new File(files.get(i));
            ze = new ZipEntry(subFile.getName());
            ze.setSize(subFile.length());
            ze.setTime(subFile.lastModified());
            zos.putNextEntry(ze);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(subFile));
            while ((readLen = ((InputStream)is).read(buf, 0, 2048)) != -1) {
                zos.write(buf, 0, readLen);
            }
            ((InputStream)is).close();
        }
        zos.close();
    }

    public static void unzip(String zipFileName, String target) throws Exception {
        ZipFile zipfile = new ZipFile(zipFileName);
        Enumeration subFiles = zipfile.getEntries();
        ZipEntry zipEntry = null;
        byte[] buf = new byte[1024];
        while (subFiles.hasMoreElements()) {
            zipEntry = (ZipEntry)subFiles.nextElement();
            if (zipEntry.isDirectory()) continue;
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(ZipUtils.getRealFileName(target, zipEntry.getName())));
            BufferedInputStream is = new BufferedInputStream(zipfile.getInputStream(zipEntry));
            int readLen = 0;
            while ((readLen = ((InputStream)is).read(buf, 0, 1024)) != -1) {
                ((OutputStream)os).write(buf, 0, readLen);
            }
            ((InputStream)is).close();
            ((OutputStream)os).close();
        }
        zipfile.close();
    }

    public static void unzipFirstEntry(String zipFileName, String entryFileName) throws Exception {
        ZipFile zipfile = new ZipFile(zipFileName);
        Enumeration subFiles = zipfile.getEntries();
        ZipEntry zipEntry = null;
        byte[] buf = new byte[1024];
        while (subFiles.hasMoreElements()) {
            zipEntry = (ZipEntry)subFiles.nextElement();
            if (zipEntry.isDirectory()) continue;
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(entryFileName));
            BufferedInputStream is = new BufferedInputStream(zipfile.getInputStream(zipEntry));
            int readLen = 0;
            while ((readLen = ((InputStream)is).read(buf, 0, 1024)) != -1) {
                ((OutputStream)os).write(buf, 0, readLen);
            }
            ((InputStream)is).close();
            ((OutputStream)os).close();
        }
        zipfile.close();
    }

    public static void ungzFirstEntry(String gzFileName, String entryFileName) throws Exception {
        GZIPInputStream gzi = new GZIPInputStream(new FileInputStream(gzFileName));
        byte[] buf = new byte[1024];
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(entryFileName));
        int readLen = 0;
        while ((readLen = gzi.read(buf, 0, 1024)) != -1) {
            ((OutputStream)os).write(buf, 0, readLen);
        }
        gzi.close();
        ((OutputStream)os).close();
    }

    private static File getRealFileName(String source, String absFileName) {
        String[] dirs = absFileName.split("/");
        File file = new File(source);
        if (dirs.length > 1) {
            for (int i = 0; i < dirs.length - 1; ++i) {
                file = new File(file, dirs[i]);
            }
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        file = new File(file, dirs[dirs.length - 1]);
        return file;
    }

    private static String getAbsFileName(File sourceFile, File subFile) {
        String result = subFile.getName();
        if (sourceFile.isDirectory()) {
            File sub = subFile;
            while ((sub = sub.getParentFile()) != null && !sub.equals(sourceFile)) {
                result = sub.getName() + "/" + result;
            }
        }
        return result;
    }

    private static List<File> getSubFiles(File source) {
        ArrayList<File> files = new ArrayList<File>();
        if (source.isDirectory()) {
            File[] tmp = source.listFiles();
            for (int i = 0; i < tmp.length; ++i) {
                if (tmp[i].isFile()) {
                    files.add(tmp[i]);
                }
                if (!tmp[i].isDirectory()) continue;
                files.addAll(ZipUtils.getSubFiles(tmp[i]));
            }
        } else {
            files.add(source);
        }
        return files;
    }

    public static Key getKey(String keyPath) throws Exception {
        FileInputStream fis = new FileInputStream(keyPath);
        byte[] b = new byte[16];
        fis.read(b);
        SecretKeySpec dks = new SecretKeySpec(b, "AES");
        fis.close();
        return dks;
    }

    public static Key getKey(byte[] key) throws Exception {
        SecretKeySpec dks = new SecretKeySpec(key, 0, 16, "AES");
        return dks;
    }

    public static void encrypt(String srcFile, String destFile, Key privateKey) throws Exception {
        SecureRandom sr = new SecureRandom();
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec spec = new IvParameterSpec(privateKey.getEncoded());
        cipher.init(1, privateKey, spec, sr);
        FileInputStream fis = new FileInputStream(srcFile);
        FileOutputStream fos = new FileOutputStream(destFile);
        byte[] b = new byte[2048];
        int byteread = 0;
        while ((byteread = fis.read(b)) != -1) {
            fos.write(cipher.doFinal(b, 0, byteread));
        }
        fos.close();
        fis.close();
    }

    public static String encryptPass(String str, String key) {
        String result = null;
        try {
            Key privateKey = ZipUtils.getKey(key.getBytes());
            SecureRandom sr = new SecureRandom();
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec spec = new IvParameterSpec(privateKey.getEncoded());
            cipher.init(1, privateKey, spec, sr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void encryptZip(String source, String destFile, String keyFile) throws Exception {
        Key key = ZipUtils.getKey(keyFile);
        File temp = new File(UUID.randomUUID().toString() + ".zip");
        temp.deleteOnExit();
        ZipUtils.zip(source, temp.getAbsolutePath());
        ZipUtils.encrypt(temp.getAbsolutePath(), destFile, key);
        temp.delete();
    }

    public static void decrypt(String srcFile, String destFile, Key privateKey) throws Exception {
        SecureRandom sr = new SecureRandom();
        Cipher ciphers = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec spec = new IvParameterSpec(privateKey.getEncoded());
        ciphers.init(2, privateKey, spec, sr);
        FileInputStream fis = new FileInputStream(srcFile);
        FileOutputStream fos = new FileOutputStream(destFile);
        byte[] b = new byte[2064];
        int byteread = 0;
        while ((byteread = fis.read(b)) != -1) {
            fos.write(ciphers.doFinal(b, 0, byteread));
        }
        fos.close();
        fis.close();
    }

    public static void decryptUnzip(String srcFile, String target, String keyFile) throws Exception {
        File temp = new File(UUID.randomUUID().toString() + ".zip");
        temp.deleteOnExit();
        ZipUtils.decrypt(srcFile, temp.getAbsolutePath(), ZipUtils.getKey(keyFile));
        ZipUtils.unzip(temp.getAbsolutePath(), target);
        temp.delete();
    }

    public static void createKey(String keyFile) throws Exception {
        SecureRandom sr = new SecureRandom();
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        kg.init(128, sr);
        SecretKey key = kg.generateKey();
        File f = new File(keyFile);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        f.createNewFile();
        FileOutputStream fos = new FileOutputStream(f);
        fos.write(key.getEncoded());
    }

    public static void main(String[] args) throws Exception {
        ZipUtils.unzip("G:/ziptest/base.zip", "G:/ziptest/base");
    }
}

