/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.config.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.TmTableConfigService;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmTableConfigServiceImpl")
@Transactional
public class TmTableConfigServiceImpl
extends BaseServiceImpl
implements TmTableConfigService {
    @Override
    public List<TmMdmTableConfigEntity> getColumnsByTableName(String tableName, String orderColumn) {
        return this.findByPropertyisOrder(TmMdmTableConfigEntity.class, "tableName", tableName, true, orderColumn);
    }

    @Override
    public void saveTableConfig(String saveJsonData) {
        String tableName = "";
        JSONArray jsonArray = JSON.parseArray((String)saveJsonData.replaceAll("&amp;", "&"));
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject obj = (JSONObject)jsonArray.get(i);
            TmMdmTableConfigEntity tableConfig = (TmMdmTableConfigEntity)JSON.toJavaObject((JSON)obj, TmMdmTableConfigEntity.class);
            if (StringUtil.isEmpty(tableName)) {
                tableName = tableConfig.getTableName();
            }
            TmMdmTableConfigEntity newTableConfig = null;
            if (StringUtil.isNotEmpty((String)tableConfig.getId())) {
                newTableConfig = this.get(TmMdmTableConfigEntity.class, (Serializable)((Object)tableConfig.getId()));
                try {
                    MyBeanUtils.copyBean2Bean(newTableConfig, tableConfig);
                    if (newTableConfig.getAddShowMode() != null && newTableConfig.getAddShowMode() == 0) {
                        newTableConfig.setAddShowMode(null);
                    }
                    if (newTableConfig.getUpdateShowMode() != null && newTableConfig.getUpdateShowMode() == 0) {
                        newTableConfig.setUpdateShowMode(null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.updateEntity(newTableConfig);
        }
        this.updateTableCache(tableName);
    }

    private void updateTableCache(String tableName) {
        if (StringUtil.isNotEmpty((String)tableName)) {
            List<TmMdmTableConfigEntity> tableColumns = this.findByPropertyisOrder(TmMdmTableConfigEntity.class, "tableName", tableName, true, "columnOrder");
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            HashMap<String, String> clounmMap = new HashMap<String, String>();
            HashMap<String, String> cloumnDictTypeMap = new HashMap<String, String>();
            HashMap<String, TmMdmTableConfigEntity> allFieldEntity = new HashMap<String, TmMdmTableConfigEntity>();
            ArrayList<TmMdmTableConfigEntity> tableConfigImp = new ArrayList<TmMdmTableConfigEntity>();
            for (TmMdmTableConfigEntity tableColumn : tableColumns) {
                allFieldEntity.put(tableColumn.getField(), tableColumn);
                if (StringUtil.isNotEmpty((String)tableColumn.getDictType())) {
                    cloumnDictTypeMap.put(tableColumn.getField(), tableColumn.getDictType());
                }
                String columnDesc = StringUtil.isNotEmpty((String)tableColumn.getFieldName()) ? tableColumn.getFieldName() : tableColumn.getColumnDesc();
                clounmMap.put(tableColumn.getField(), columnDesc);
                fieldMap.put(tableColumn.getColumnName(), columnDesc);
                if (StringUtil.isNotEmpty(tableColumn.getImportOut())) {
                    String keyName = tableColumn.getTableName() + tableColumn.getField();
                    if (StringUtil.isNotEmpty((String)tableColumn.getFieldProperty())) {
                        keyName = tableColumn.getTableName() + tableColumn.getFieldProperty();
                    }
                    DynamicConfigUtil.allTableConfigByField.put(keyName.toLowerCase(), tableColumn);
                }
                if (!StringUtil.isNotEmpty(tableColumn.getAddShowMode()) || tableColumn.getAddShowMode() != 1) continue;
                tableConfigImp.add(tableColumn);
            }
            DynamicConfigUtil.allTableConfigEntity.put(tableName, allFieldEntity);
            DynamicConfigUtil.allTableConfigDictColumn.put(tableName, cloumnDictTypeMap);
            DynamicConfigUtil.allTableConfigField.put(tableName, fieldMap);
            DynamicConfigUtil.allTableConfigColumn.put(tableName, clounmMap);
            DynamicConfigUtil.allTableConfig.put(tableName.toLowerCase(), tableColumns);
            DynamicConfigUtil.allTableConfigImpColumn.put(tableName, tableConfigImp);
        }
    }

    @Override
    public void importTable(String tableName) {
        ArrayList<TmMdmTableConfigEntity> saveList = new ArrayList<TmMdmTableConfigEntity>();
        ArrayList<TmMdmTableConfigEntity> delList = new ArrayList<TmMdmTableConfigEntity>();
        List<TmMdmTableConfigEntity> hisList = this.getColumnsByTableName(tableName, "columnOrder");
        String sql = this.getSearchTableColumnSql(tableName);
        List<TmMdmTableConfigEntity> nowList = this.findBySql(TmMdmTableConfigEntity.class, sql, new Object[0]);
        if (hisList != null && hisList.size() > 0) {
            for (TmMdmTableConfigEntity table : hisList) {
                if (this.hasContain(nowList, table)) continue;
                delList.add(table);
            }
            this.deleteAllEntity(delList);
        }
        for (TmMdmTableConfigEntity t : nowList) {
            if (this.hasContain(hisList, t)) continue;
            saveList.add(t);
        }
        this.batchSave(saveList);
    }

    private boolean hasContain(List<TmMdmTableConfigEntity> list, TmMdmTableConfigEntity tableConfig) {
        boolean flag = false;
        for (TmMdmTableConfigEntity t : list) {
            if (!StringUtil.equals(t.getColumnName(), tableConfig.getColumnName())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private String getSearchTableColumnSql(String tableName) {
        String sql = "select t.Table_Name tableName,t.COLUMN_NAME columnName,case when instr(t1.COMMENTS,'\uff0c')>0 then substr(t1.COMMENTS,0,instr(t1.COMMENTS,'\uff0c')-1) else t1.COMMENTS end columnDesc, t.data_type||'('||t.data_length||')'  columnType, substr(replace(initcap('a' || t.COLUMN_NAME), '_', ''), 2) field,ROWNUM columnOrder from user_tab_columns t left join user_col_comments t1 on t1.Table_Name=t.Table_Name and t1.COLUMN_NAME=t.COLUMN_NAME where t.Table_Name='" + tableName + "'";
        return sql;
    }
}

