/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.role.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.entity.TmRPositionRoleEntity;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.service.TmRoleService;
import com.biz.eisp.mdm.role.vo.TmRolePositionImportVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TmRolePositionHandler
extends ImpEventHandler<TmRolePositionImportVo> {
    private List<TmRPositionRoleEntity> importDataList = new ArrayList<TmRPositionRoleEntity>();
    private TmRoleService tmRoleService;
    private int succNum = 0;
    private int errNum = 0;
    private StringBuilder errors = new StringBuilder();

    public TmRolePositionHandler() {
        this.tmRoleService = (TmRoleService)ApplicationContextUtils.getContext().getBean(TmRoleService.class);
    }

    @Override
    public void endRow(Map<String, Object> row, TmRolePositionImportVo bean) throws ValidateException {
        String positionCode = bean.getPositionCode();
        String roleCode = bean.getRoleCode();
        TmPositionEntity positionEntity = this.tmRoleService.findUniqueByProperty(TmPositionEntity.class, "positionCode", positionCode);
        TmRoleEntity roleEntity = this.tmRoleService.findUniqueByProperty(TmRoleEntity.class, "roleCode", roleCode);
        if (positionEntity == null) {
            this.addErrorMsg("\u804c\u4f4d\u7f16\u7801\uff1a" + positionCode + "\u4e0d\u5b58\u5728");
        }
        if (roleEntity == null) {
            this.addErrorMsg("\u89d2\u8272\u7f16\u7801\uff1a" + roleCode + "\u4e0d\u5b58\u5728");
        }
        if (positionEntity != null && roleEntity != null) {
            TmRPositionRoleEntity entity = this.getExistTmRPositionRoleEntity(positionEntity.getId(), roleEntity.getId());
            if (entity == null) {
                entity = new TmRPositionRoleEntity();
            }
            entity.setTmPosition(positionEntity);
            entity.setTmRole(roleEntity);
            this.importDataList.add(entity);
            ++this.succNum;
            this.setSuccNum(this.succNum);
        }
    }

    private TmRPositionRoleEntity getExistTmRPositionRoleEntity(String positionId, String actRoleId) {
        String hql = "from TmRPositionRoleEntity where tmPosition.id = ? and tmRole.id = ?";
        List tmRPositionActRoleEntityList = this.tmRoleService.findByHql(hql, positionId, actRoleId);
        if (CollectionUtil.listNotEmptyNotSizeZero(tmRPositionActRoleEntityList)) {
            return (TmRPositionRoleEntity)tmRPositionActRoleEntityList.get(0);
        }
        return null;
    }

    private void addErrorMsg(String error) throws ValidateException {
        this.errors.append("\u3010\u7b2c" + this.getRowNumber() + "\u884c\u3011:" + error).append("<br/>");
        ++this.errNum;
        if (this.errNum > 200) {
            throw new ValidateException(this.errors.toString());
        }
    }

    @Override
    public void end() {
        if (this.errNum > 0) {
            throw new BusinessException(this.errors.toString());
        }
        this.saveData();
    }

    private void saveData() {
        if (CollectionUtil.listNotEmptyNotSizeZero(this.importDataList)) {
            for (TmRPositionRoleEntity entity : this.importDataList) {
                this.tmRoleService.saveOrUpdate(entity);
            }
        }
    }
}

