/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.collect.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.UserRedis;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.mdm.collect.dao.TmUserCollectDao;
import com.biz.eisp.mdm.collect.entity.TmUserCollectEntity;
import com.biz.eisp.mdm.collect.service.TmUserCollectService;
import com.biz.eisp.mdm.collect.transformer.TmUserCollectEntityToTmUserCollectVo;
import com.biz.eisp.mdm.collect.transformer.TmUserCollectVoToTmUserCollectEntity;
import com.biz.eisp.mdm.collect.vo.TmUserCollectVo;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.function.service.TmFunctionService;
import com.biz.eisp.mdm.icon.service.TmIconService;
import com.biz.eisp.mdm.icon.vo.TmIconVo;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmUserCollectService")
@Transactional
public class TmUserCollectServiceImpl
extends BaseServiceImpl
implements TmUserCollectService {
    @Autowired
    private TmUserCollectDao tmUserCollectDao;
    @Autowired
    private TmFunctionService tmFunctionService;
    @Autowired
    private TmIconService tmIconService;

    @Override
    public String saveOrUpdateUserCollect(TmUserCollectVo ic) {
        TmUserCollectEntity icon = null;
        UserRedis userRedis = UserUtils.getUser();
        ic.setUserId(userRedis.getId());
        ic.setUsername(userRedis.getUsername());
        if (StringUtil.isEmpty(ic.getFunctionId())) {
            throw new BusinessException("functionId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TmFunctionEntity tmFunctionEntity = this.tmFunctionService.get(TmFunctionEntity.class, (Serializable)((Object)ic.getFunctionId()));
        if (tmFunctionEntity != null) {
            ic.setFunctionName(tmFunctionEntity.getFunctionName());
            ic.setFunctionUrl(tmFunctionEntity.getFunctionUrl());
            TmIconVo tmIconVo = this.tmIconService.getIconById(tmFunctionEntity.getTmIcon().getId());
            ic.setIconId(tmIconVo.getId());
            ic.setIconPath(tmIconVo.getIconPath());
        }
        TmUserCollectVoToTmUserCollectEntity transForm = new TmUserCollectVoToTmUserCollectEntity(this);
        icon = transForm.apply(ic);
        this.saveOrUpdate(icon);
        return "\u64cd\u4f5c\u6210\u529f";
    }

    @Override
    public TmUserCollectVo getUserCollectById(String id) {
        TmUserCollectEntity ie = this.get(TmUserCollectEntity.class, (Serializable)((Object)id));
        if (ie != null) {
            TmUserCollectEntityToTmUserCollectVo trans = new TmUserCollectEntityToTmUserCollectVo(this);
            return trans.apply(ie);
        }
        return null;
    }

    @Override
    public List<TmUserCollectVo> getTmUserCollectList(TmUserCollectVo tmUserCollectVo) {
        return this.tmUserCollectDao.getTmUserCollectList(tmUserCollectVo);
    }

    @Override
    public AjaxJson delUserCollect(String ids) {
        String[] iconIds;
        AjaxJson j = new AjaxJson();
        for (String id : iconIds = ids.split(",")) {
            TmUserCollectEntity tmUserCollectEntity = this.get(TmUserCollectEntity.class, (Serializable)((Object)id));
            if (tmUserCollectEntity == null) {
                j.setMsg("\u5220\u9664\u5931\u8d25\uff01");
                j.setSuccess(false);
                return j;
            }
            this.delete(tmUserCollectEntity);
        }
        j.setMsg("\u5220\u9664\u6210\u529f\uff01");
        return j;
    }

    @Override
    public AjaxJson delUserCollectByFunId(String functionId) {
        AjaxJson j = new AjaxJson();
        TmUserCollectVo tmUserCollectVo = new TmUserCollectVo();
        tmUserCollectVo.setFunctionId(functionId);
        List<TmUserCollectVo> tmUserCollectVos = this.getTmUserCollectList(tmUserCollectVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(tmUserCollectVos)) {
            TmUserCollectVo vo = tmUserCollectVos.get(0);
            if (vo == null) {
                j.setMsg("\u5220\u9664\u5931\u8d25\uff01");
                j.setSuccess(false);
                return j;
            }
            this.deleteEntityById(TmUserCollectEntity.class, (Serializable)((Object)vo.getId()));
        }
        j.setMsg("\u5220\u9664\u6210\u529f\uff01");
        return j;
    }
}

